/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSSessionImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class GSBytesMessageImpl
extends GSMessageImpl
implements BytesMessage {
    private static final long serialVersionUID = 1L;
    private ByteArrayOutputStream bytesOut;
    private DataOutputStream dataOut;
    private DataInputStream dataIn;

    public GSBytesMessageImpl() throws JMSException {
    }

    public GSBytesMessageImpl(GSSessionImpl session, byte[] bytesArray) throws JMSException {
        super(session, "Bytes");
        this.Body = bytesArray;
    }

    public GSBytesMessageImpl(GSSessionImpl session) throws JMSException {
        this(session, (byte[])null);
    }

    public void setBytes(byte[] bytesArray) {
        this.Body = bytesArray;
    }

    public byte[] getBytes() {
        return (byte[])this.Body;
    }

    public void seal() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.flush();
            this.Body = this.bytesOut.toByteArray();
            this.dataOut.close();
            this.bytesOut.close();
            this.dataOut = null;
            this.bytesOut = null;
        }
    }

    public long getBodyLength() throws JMSException {
        this.checkBodyReadOnly();
        return ((byte[])this.Body).length;
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readBoolean();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readByte();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readUnsignedByte();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readShort();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readUnsignedShort();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readChar();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readInt();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readLong();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readFloat();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readDouble();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public String readUTF() throws JMSException {
        this.initializeReading();
        try {
            this.dataIn.mark(Integer.MAX_VALUE);
            return this.dataIn.readUTF();
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        return this.readBytes(value, value.length);
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.initializeReading();
        if (value == null) {
            throw new NullPointerException("Byte buffer is null");
        }
        if (length < 0 || length > value.length) {
            throw new IndexOutOfBoundsException("Illegal byte buffer size. Must be between 0 and value.length.");
        }
        this.dataIn.mark(Integer.MAX_VALUE);
        try {
            int n;
            int count;
            for (n = 0; n < length && (count = this.dataIn.read(value, n, length - n)) >= 0; n += count) {
            }
            if (n == 0 && length > 0) {
                n = -1;
            }
            return n;
        }
        catch (EOFException eof) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageEOFException jmsEx = new MessageEOFException(eof.toString());
            jmsEx.setLinkedException((Exception)eof);
            throw jmsEx;
        }
        catch (IOException ioe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException(e.toString());
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
            MessageFormatException jmsEx = new MessageFormatException("Format error occurred" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeBoolean(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeByte(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeShort(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeChar(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeInt(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeLong(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeFloat(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeDouble(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.writeUTF(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(value);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(value, offset, length);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Could not write data:" + ioe.toString());
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
    }

    public void writeObject(Object value) throws JMSException {
        if (value == null) {
            throw new NullPointerException();
        }
        this.initializeWriting();
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(value.toString());
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            throw new MessageFormatException("Cannot write non-primitive type:" + value.getClass());
        }
    }

    public void reset() throws JMSException {
        if (this.dataOut != null) {
            try {
                this.dataOut.flush();
                this.Body = this.bytesOut.toByteArray();
                this.dataOut.close();
                this.bytesOut.close();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed: " + ioe.toString());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
        }
        if (this.dataIn != null) {
            try {
                this.dataIn.close();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed: " + ioe.toString());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
        }
        this.setBodyReadOnly(true);
        this.bytesOut = null;
        this.dataIn = null;
        this.dataOut = null;
    }

    private void initializeWriting() throws MessageNotWriteableException {
        this.checkBodyReadOnly();
        if (this.dataOut == null) {
            this.bytesOut = new ByteArrayOutputStream();
            this.dataOut = new DataOutputStream(this.bytesOut);
        }
    }

    private void initializeReading() throws MessageNotReadableException {
        this.checkBodyWriteOnly();
        if (this.dataIn == null) {
            byte[] body;
            if (this.Body == null) {
                body = new byte[]{};
                this.Body = body;
            } else {
                body = (byte[])this.Body;
            }
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(body, 0, body.length);
            this.dataIn = new DataInputStream(bytesIn);
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.Body = new byte[0];
        this.setBodyReadOnly(false);
        try {
            if (this.dataOut != null) {
                this.dataOut.close();
            }
            if (this.dataIn != null) {
                this.dataIn.close();
            }
            if (this.bytesOut != null) {
                this.bytesOut.close();
            }
        }
        catch (IOException e) {
            JMSException jmsEx = new JMSException("IOException while clearing message body: " + e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        finally {
            this.dataOut = null;
            this.dataIn = null;
            this.bytesOut = null;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\n\n\tBytesMessage:");
        sb.append("\n\t\tbytesOut:\t\t");
        sb.append(this.bytesOut);
        sb.append("\n\t\tdataIn:\t\t\t");
        sb.append(this.dataIn);
        sb.append("\n\t\tdataOut:\t\t");
        sb.append(this.dataOut);
        return sb.toString();
    }

    @Override
    GSMessageImpl duplicate() throws JMSException {
        GSBytesMessageImpl dup = new GSBytesMessageImpl();
        this.copyTo(dup);
        return dup;
    }

    @Override
    protected Object cloneBody() {
        if (this.Body == null) {
            return null;
        }
        byte[] body = (byte[])this.Body;
        byte[] cloned = new byte[body.length];
        System.arraycopy(body, 0, cloned, 0, body.length);
        return cloned;
    }
}

