/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.gigaspaces.client.DirectSpaceProxyFactory;
import com.gigaspaces.client.transaction.DistributedTransactionManagerProvider;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceSecurityException;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.LookupFinder;
import com.j_spaces.core.client.LookupRequest;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.jms.GSConnectionImpl;
import com.j_spaces.jms.utils.GSJMSAdmin;
import com.j_spaces.jms.utils.IMessageConverter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.TransactionManager;

public class GSConnectionFactoryImpl
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
Externalizable,
Remote {
    private static final long serialVersionUID = 1L;
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.jms");
    private static final Object distributedTransactionManagerProviderLock = new Object();
    private static final Random random = new Random();
    private static final String ID_SUFFIX = GSConnectionFactoryImpl.generateIdSuffix();
    private static final String AUTH_DEF_ANONYMOUSE_NAME = "anonymous";
    private static DistributedTransactionManagerProvider distributedTransactionManagerProvider;
    private static TransactionManager dtm;
    private IJSpace m_space;
    private IMessageConverter messageConverter;
    private int connectionsCounter;
    private transient GSJMSAdmin admin;
    private Hashtable<String, GSConnectionImpl> connectionsHash;

    private static String generateIdSuffix() {
        String hostIPStr = SystemInfo.singleton().network().getHost().getHostAddress();
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(hostIPStr, ".");
        while (st.hasMoreTokens()) {
            sb.insert(0, st.nextToken());
        }
        return sb.toString();
    }

    public GSConnectionFactoryImpl() {
    }

    public GSConnectionFactoryImpl(IJSpace space, IMessageConverter messageConverter) throws JMSException {
        this.m_space = space;
        this.messageConverter = messageConverter;
        this.connectionsHash = new Hashtable();
    }

    protected IMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    protected IJSpace getSpace() {
        return this.m_space;
    }

    protected String getSpaceName() {
        return this.m_space.getName();
    }

    protected SpaceURL getSpaceURL() {
        return this.m_space.getURL();
    }

    protected GSJMSAdmin getAdmin() throws JMSException {
        if (this.admin == null) {
            this.admin = GSJMSAdmin.getInstance();
        }
        return this.admin;
    }

    protected void setSpaceSecurityContext(String username, String password) throws JMSException {
        if (username == null) {
            throw new JMSSecurityException("Unauthenticated Username- Username must not be null");
        }
        if (password == null) {
            throw new JMSSecurityException("Unauthenticated Password- Password must not be null");
        }
        try {
            if (username.equalsIgnoreCase(AUTH_DEF_ANONYMOUSE_NAME) && password.equalsIgnoreCase(AUTH_DEF_ANONYMOUSE_NAME)) {
                return;
            }
            if (!this.m_space.isSecured()) {
                throw new JMSSecurityException("The space < " + this.getSpaceName() + " > must be defined as a Secured Space.");
            }
            ((ISpaceProxy)this.m_space).login((CredentialsProvider)new DefaultCredentialsProvider(username, password));
        }
        catch (SpaceSecurityException se) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "exception inside setSpaceSecurityContext(user,pass): " + se.toString(), se);
            }
            JMSSecurityException e = new JMSSecurityException("SpaceSecurityException : " + se.toString());
            e.setLinkedException((Exception)((Object)se));
            throw e;
        }
        catch (RemoteException re) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.log(Level.INFO, "exception inside setSpaceSecurityContext(user,pass): " + re.toString(), re);
            }
            JMSException e = new JMSException("RemoteException : " + re.toString());
            e.setLinkedException((Exception)re);
            throw e;
        }
    }

    protected synchronized String nextCnxKey() {
        if (this.connectionsCounter == Integer.MAX_VALUE) {
            this.connectionsCounter = 0;
        }
        ++this.connectionsCounter;
        int randLong = random.nextInt(Integer.MAX_VALUE);
        return "" + this.connectionsCounter + randLong + "_" + ID_SUFFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionManager getLocalTransactionManager() throws JMSException {
        if (distributedTransactionManagerProvider == null) {
            try {
                Object object = distributedTransactionManagerProviderLock;
                synchronized (object) {
                    if (distributedTransactionManagerProvider == null) {
                        distributedTransactionManagerProvider = new DistributedTransactionManagerProvider();
                    }
                }
            }
            catch (TransactionException re) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Exception inside GSConnectionFactoryImpl.createLocalTransactionManager() : " + re.toString(), re);
                }
                JMSException e = new JMSException("RemoteException: " + re.toString());
                e.setLinkedException((Exception)((Object)re));
                throw e;
            }
        }
        return distributedTransactionManagerProvider.getTransactionManager();
    }

    public TransactionManager getDistributedTransactionManager() throws JMSException {
        if (dtm == null) {
            try {
                LookupRequest request = LookupRequest.TransactionManager().setLocators(this.getSpaceURL().getProperty("locators")).setGroups(this.getSpaceURL().getProperty("groups")).setTimeout(10000L);
                dtm = (TransactionManager)LookupFinder.find((LookupRequest)request);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Created Distributed Transaction Manager: " + dtm.toString());
                }
            }
            catch (FinderException fe) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to create Exception Distributed Transaction Manager.", fe);
                }
                JMSException e = new JMSException("FinderException: " + fe.toString());
                e.setLinkedException((Exception)((Object)fe));
                throw e;
            }
        }
        return dtm;
    }

    void addConnection(GSConnectionImpl connection) throws JMSException {
        this.connectionsHash.put(connection.connFacParent.getSpaceURL().getURL(), connection);
    }

    void removeConnection(GSConnectionImpl connection) {
        this.connectionsHash.remove(connection.connFacParent.getSpaceURL().getURL());
    }

    private GSConnectionImpl createGSConnection(String prefix) throws JMSException {
        GSConnectionImpl conn = new GSConnectionImpl(this);
        String connKey = prefix + this.nextCnxKey();
        conn.setCnxKey(connKey);
        conn.updateClientIDInternally(connKey + "_" + this.getSpaceName());
        this.addConnection(conn);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSConnectionFactoryImpl.createGSConnection() connKey: " + connKey);
        }
        return conn;
    }

    private GSConnectionImpl createGSConnection(String prefix, String userName, String password) throws JMSException {
        this.setSpaceSecurityContext(userName, password);
        return this.createGSConnection(prefix);
    }

    public Connection createConnection() throws JMSException {
        return this.createGSConnection("c");
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createGSConnection("c", userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createGSConnection("qc");
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return this.createGSConnection("qc", userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createGSConnection("tc");
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return this.createGSConnection("tc", userName, password);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_space.getDirectProxy().getFactory());
        out.writeObject(this.messageConverter);
        out.writeInt(this.connectionsCounter);
        out.writeObject(this.connectionsHash);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DirectSpaceProxyFactory factory = (DirectSpaceProxyFactory)in.readObject();
        this.m_space = factory.createSpaceProxy();
        this.messageConverter = (IMessageConverter)in.readObject();
        this.connectionsCounter = in.readInt();
        this.connectionsHash = (Hashtable)in.readObject();
    }
}

