/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.core.IJSpace;
import com.j_spaces.jms.GSConnectionFactoryImpl;
import com.j_spaces.jms.GSConnectionMetaDataImpl;
import com.j_spaces.jms.GSQueueSessionImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.GSTopicSessionImpl;
import com.j_spaces.jms.TransactionCreateException;
import com.j_spaces.jms.utils.CyclicCounter;
import com.j_spaces.jms.utils.StringsUtils;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;

class GSConnectionImpl
implements Connection,
QueueConnection,
TopicConnection {
    private String m_clientID;
    private ExceptionListener errorHandler;
    protected boolean closing = false;
    protected boolean closed = false;
    protected boolean stopped = true;
    private volatile CyclicCounter sessionsC = new CyclicCounter();
    private String cnxKey;
    private final Vector sessions;
    private GSConnectionMetaDataImpl m_metaData;
    GSConnectionFactoryImpl connFacParent;
    private boolean m_modified = false;
    private boolean m_clientIdSet = false;
    private final int m_compressionMinSize;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.jms");
    ReentrantLock txnLock = new ReentrantLock();

    public GSConnectionImpl(GSConnectionFactoryImpl _connFacParent) throws JMSException {
        this.connFacParent = _connFacParent;
        this.sessions = new Vector();
        this.m_compressionMinSize = this.connFacParent.getAdmin().getCompressionMinSize();
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        GSSessionImpl session = new GSSessionImpl(this, transacted, acknowledgeMode);
        if (!this.isStopped()) {
            session.start();
        }
        return session;
    }

    public String getClientID() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        this.setModified();
        return this.m_clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        boolean isSuggestedIDValid = this.isValidExtClientID(clientID);
        if (this.m_clientIdSet || isSuggestedIDValid && !this.isValidExtClientID(this.m_clientID)) {
            throw new IllegalStateException("The client id has already been set");
        }
        if (!isSuggestedIDValid) {
            throw new InvalidClientIDException("Attempt to set the invalid client id:  " + clientID);
        }
        if (this.m_modified) {
            throw new IllegalStateException("The client identifier must be set before any other operation is performed");
        }
        this.m_clientID = clientID;
        this.m_clientIdSet = true;
    }

    private boolean isValidExtClientID(String _clientID) {
        return !_clientID.startsWith("tc_") && !_clientID.startsWith("qc_") && !_clientID.startsWith("xatc_") && !_clientID.startsWith("xaqc_") && !StringsUtils.isEmpty(_clientID);
    }

    protected void updateClientIDInternally(String updatedClientID) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        this.m_clientID = updatedClientID;
    }

    protected void setModified() {
        this.m_modified = true;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        if (this.m_metaData == null) {
            this.m_metaData = new GSConnectionMetaDataImpl();
        }
        this.setModified();
        return this.m_metaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        this.setModified();
        return this.errorHandler;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        this.setModified();
        this.errorHandler = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSession(GSSessionImpl childSession) {
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            this.sessions.addElement(childSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(GSSessionImpl childSession) {
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            this.sessions.remove(childSession);
            childSession = null;
        }
    }

    void onException(JMSException jE) {
        if (this.errorHandler != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("calling ExceptionListener.onException(): " + this.cnxKey);
            }
            this.errorHandler.onException(jE);
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ExceptionListener is not set for connection: " + this.cnxKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            this.ensureOpen();
            this.setModified();
            if (this.stopped) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.start()  starting connection: " + this.toString());
                }
                for (int i = 0; i < this.sessions.size(); ++i) {
                    GSSessionImpl session = (GSSessionImpl)this.sessions.get(i);
                    session.start();
                }
                this.stopped = false;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.start()  connection was started: " + this.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            this.ensureOpen();
            this.setModified();
            if (!this.stopped) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.stop()  stopping connection: " + this.toString());
                }
                for (int i = 0; i < this.sessions.size(); ++i) {
                    GSSessionImpl session = (GSSessionImpl)this.sessions.get(i);
                    session.stop();
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.stop()  connection was stopped: " + this.getCnxKey());
                }
                this.stopped = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        GSConnectionImpl gSConnectionImpl = this;
        synchronized (gSConnectionImpl) {
            if (!this.closed) {
                this.closing = true;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.close()  closing connection: " + this.toString());
                }
                this.stop();
                while (!this.sessions.isEmpty()) {
                    GSSessionImpl session = (GSSessionImpl)this.sessions.elementAt(0);
                    try {
                        session.close();
                    }
                    catch (JMSException jMSException) {}
                }
                this.getConnFacParent().removeConnection(this);
                this.closed = true;
                this.closing = false;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSConnectionImpl.close() connection was closed: " + this.toString());
                }
            }
        }
    }

    protected boolean isStopped() {
        return this.stopped;
    }

    protected void ensureOpen() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSConnectionImpl.createConnectionConsumer() method is not implemented. ");
        }
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSConnectionImpl.createDurableConnectionConsumer() method is not implemented. ");
        }
        return null;
    }

    String nextSessionId() {
        return this.cnxKey + "_sess_" + this.sessionsC.increment();
    }

    IJSpace getSpace() {
        return this.connFacParent.getSpace();
    }

    public Transaction getTransaction(boolean localTransaction, long leaseTime) throws TransactionCreateException {
        Transaction tr;
        this.txnLock.lock();
        try {
            Transaction.Created tCreated = localTransaction ? TransactionFactory.create((TransactionManager)this.connFacParent.getLocalTransactionManager(), (long)leaseTime) : TransactionFactory.create((TransactionManager)this.connFacParent.getDistributedTransactionManager(), (long)leaseTime);
            tr = tCreated.transaction;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSConnectionImpl.getTransaction() leaseTime: " + leaseTime + "  |  TX.id: " + ((ServerTransaction)tr).id + "|  TX.mgr: " + ((ServerTransaction)tr).mgr.toString());
            }
        }
        catch (Exception e) {
            String msg = "Failed to create transaction: " + e;
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, msg);
            }
            throw new TransactionCreateException(msg, e);
        }
        finally {
            this.txnLock.unlock();
        }
        return tr;
    }

    TransactionManager getTransactionManager() throws JMSException {
        return this.connFacParent.getLocalTransactionManager();
    }

    protected String getCnxKey() {
        return this.cnxKey;
    }

    protected void setCnxKey(String string) {
        this.cnxKey = string;
    }

    public String toString() {
        return "GSConnectionImpl || client  ID: " + this.m_clientID + " || connection ID: " + this.getCnxKey();
    }

    protected GSConnectionFactoryImpl getConnFacParent() {
        return this.connFacParent;
    }

    public int getCompressionMinSize() {
        return this.m_compressionMinSize;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer((Destination)queue, messageSelector, sessionPool, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        GSQueueSessionImpl session = new GSQueueSessionImpl(this, transacted, acknowledgeMode);
        if (!this.isStopped()) {
            session.start();
        }
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer((Destination)topic, messageSelector, sessionPool, maxMessages);
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Forbidden call on a closed connection.");
        }
        GSTopicSessionImpl session = new GSTopicSessionImpl(this, transacted, acknowledgeMode);
        if (!this.isStopped()) {
            session.start();
        }
        return session;
    }
}

