/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.utils.ConversionHelper;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;

public class GSMapMessageImpl
extends GSMessageImpl
implements MapMessage {
    private static final long serialVersionUID = 1L;

    public GSMapMessageImpl() throws JMSException {
    }

    public GSMapMessageImpl(GSSessionImpl session, HashMap<String, Object> map) throws JMSException {
        super(session, "Map");
        this.Body = map;
    }

    public GSMapMessageImpl(GSSessionImpl session) throws JMSException {
        this(session, (HashMap<String, Object>)null);
    }

    public void setMap(HashMap<String, Object> map) {
        this.Body = map;
    }

    public HashMap<String, Object> getMap() {
        return (HashMap)this.Body;
    }

    public final boolean getBoolean(String name) throws JMSException, MessageFormatException {
        HashMap body = (HashMap)this.Body;
        return ConversionHelper.getBoolean(body.get(name));
    }

    public final byte getByte(String name) throws JMSException, MessageFormatException {
        HashMap body = (HashMap)this.Body;
        return ConversionHelper.getByte(body.get(name));
    }

    public final short getShort(String name) throws JMSException, MessageFormatException {
        HashMap body = (HashMap)this.Body;
        return ConversionHelper.getShort(body.get(name));
    }

    public final char getChar(String name) throws JMSException, MessageFormatException {
        HashMap body = (HashMap)this.Body;
        return ConversionHelper.getChar(body.get(name));
    }

    public final int getInt(String name) throws JMSException, MessageFormatException {
        HashMap body = (HashMap)this.Body;
        return ConversionHelper.getInt(body.get(name));
    }

    public final long getLong(String name) throws JMSException, MessageFormatException {
        HashMap body = (HashMap)this.Body;
        return ConversionHelper.getLong(body.get(name));
    }

    public final float getFloat(String name) throws JMSException, MessageFormatException {
        HashMap body = (HashMap)this.Body;
        return ConversionHelper.getFloat(body.get(name));
    }

    public final double getDouble(String name) throws JMSException, MessageFormatException {
        HashMap body = (HashMap)this.Body;
        return ConversionHelper.getDouble(body.get(name));
    }

    public final String getString(String name) throws JMSException, MessageFormatException {
        HashMap body = (HashMap)this.Body;
        return ConversionHelper.getString(body.get(name));
    }

    public final byte[] getBytes(String name) throws JMSException, MessageFormatException {
        HashMap body = (HashMap)this.Body;
        return ConversionHelper.getBytes(body.get(name));
    }

    public final Object getObject(String name) throws JMSException {
        byte[] result = null;
        HashMap body = (HashMap)this.Body;
        Object value = body.get(name);
        if (value != null) {
            if (value instanceof Boolean) {
                result = (byte[])value;
            } else if (value instanceof Byte) {
                result = (byte[])value;
            } else if (value instanceof Short) {
                result = (byte[])value;
            } else if (value instanceof Character) {
                result = (byte[])value;
            } else if (value instanceof Integer) {
                result = (byte[])value;
            } else if (value instanceof Long) {
                result = (byte[])value;
            } else if (value instanceof Float) {
                result = (byte[])value;
            } else if (value instanceof Double) {
                result = (byte[])value;
            } else if (value instanceof String) {
                result = (byte[])value;
            } else if (value instanceof byte[]) {
                result = this.getBytes(name);
            } else {
                throw new MessageFormatException("MapMessage contains an unsupported Java primitive type:  " + value.getClass().getName());
            }
        }
        return result;
    }

    public Enumeration getMapNames() throws JMSException {
        HashMap body = (HashMap)this.Body;
        return Collections.enumeration(body.keySet());
    }

    public final void setBoolean(String name, boolean value) throws JMSException {
        this.checkPropertiesReadOnly();
        HashMap body = (HashMap)this.Body;
        body.put(name, value);
    }

    public final void setByte(String name, byte value) throws JMSException {
        this.checkPropertiesReadOnly();
        HashMap body = (HashMap)this.Body;
        body.put(name, value);
    }

    public final void setShort(String name, short value) throws JMSException {
        this.checkPropertiesReadOnly();
        HashMap body = (HashMap)this.Body;
        body.put(name, value);
    }

    public final void setChar(String name, char value) throws JMSException {
        this.checkPropertiesReadOnly();
        HashMap body = (HashMap)this.Body;
        body.put(name, Character.valueOf(value));
    }

    public final void setInt(String name, int value) throws JMSException {
        this.checkPropertiesReadOnly();
        HashMap body = (HashMap)this.Body;
        body.put(name, value);
    }

    public final void setLong(String name, long value) throws JMSException {
        this.checkPropertiesReadOnly();
        HashMap body = (HashMap)this.Body;
        body.put(name, value);
    }

    public final void setFloat(String name, float value) throws JMSException {
        this.checkPropertiesReadOnly();
        HashMap body = (HashMap)this.Body;
        body.put(name, Float.valueOf(value));
    }

    public final void setDouble(String name, double value) throws JMSException {
        this.checkPropertiesReadOnly();
        HashMap body = (HashMap)this.Body;
        body.put(name, value);
    }

    public final void setString(String name, String value) throws JMSException {
        this.checkPropertiesReadOnly();
        HashMap body = (HashMap)this.Body;
        body.put(name, value);
    }

    public final void setBytes(String name, byte[] value) throws JMSException {
        this.checkPropertiesReadOnly();
        byte[] bytes = null;
        if (value != null) {
            bytes = new byte[value.length];
            System.arraycopy(value, 0, bytes, 0, bytes.length);
        }
        HashMap body = (HashMap)this.Body;
        body.put(name, bytes);
    }

    public final void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkPropertiesReadOnly();
        byte[] bytes = null;
        if (value != null) {
            bytes = new byte[length];
            System.arraycopy(value, offset, bytes, 0, length);
        }
        HashMap body = (HashMap)this.Body;
        body.put(name, bytes);
    }

    public final void setObject(String name, Object value) throws JMSException {
        this.checkPropertiesReadOnly();
        if (value == null) {
            HashMap body = (HashMap)this.Body;
            body.put(name, null);
        } else if (value instanceof Boolean) {
            this.setBoolean(name, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByte(name, (Byte)value);
        } else if (value instanceof Short) {
            this.setShort(name, (Short)value);
        } else if (value instanceof Character) {
            this.setChar(name, ((Character)value).charValue());
        } else if (value instanceof Integer) {
            this.setInt(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLong(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloat(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDouble(name, (Double)value);
        } else if (value instanceof String) {
            this.setString(name, (String)value);
        } else if (value instanceof byte[]) {
            this.setBytes(name, (byte[])value);
        } else {
            throw new MessageFormatException("MapMessage does not support objects of type=" + value.getClass().getName());
        }
    }

    public boolean itemExists(String name) throws JMSException {
        HashMap body = (HashMap)this.Body;
        return body.containsKey(name);
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.Body = new HashMap();
    }

    @Override
    GSMessageImpl duplicate() throws JMSException {
        GSMapMessageImpl dup = new GSMapMessageImpl();
        this.copyTo(dup);
        return dup;
    }

    @Override
    protected Object cloneBody() {
        if (this.Body == null) {
            return null;
        }
        HashMap body = (HashMap)this.Body;
        HashMap cloned = new HashMap(body.size());
        cloned.putAll(body);
        return cloned;
    }
}

