/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.events.DataEventSessionFactory;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.io.MarshObject;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.jms.CommitFailedException;
import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSQueueImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.GSTemporaryQueueImpl;
import com.j_spaces.jms.GSTemporaryTopicImpl;
import com.j_spaces.jms.GSTopicImpl;
import com.j_spaces.jms.ReceiveFromQueueException;
import com.j_spaces.jms.RollbackFailedException;
import com.j_spaces.jms.SpaceLostException;
import com.j_spaces.jms.TransactionCreateException;
import com.j_spaces.jms.utils.StringsUtils;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Time;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionRolledBackException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.transaction.Transaction;

public class GSMessageConsumerImpl
implements MessageConsumer,
QueueReceiver,
TopicSubscriber {
    private MessageListener m_messageListener;
    private OnMessageEventListener onMessageEventListener;
    private AsyncPoller asyncPoller;
    protected Destination m_dest;
    protected String m_destName = "TempDestName";
    protected GSSessionImpl m_session;
    protected volatile boolean m_isQueue = true;
    private EventSessionConfig eventSessionConfig;
    private DataEventSession eventSession;
    protected volatile boolean m_closed = false;
    private transient IJSpace m_space;
    public String m_durableSubscriptionName;
    private static final long RECEIVE_NO_WAIT_TIMEOUT = 2000L;
    private String m_consumerID;
    private String m_selector;
    private GSMessageImpl m_jmsMessageTemplate = null;
    private Object synchTopicNotifyLock = new Object();
    private GSMessageImpl currentMessage = null;
    private GSMessageImpl topicWakeupObject = new GSMessageImpl();
    private boolean m_noLocal = false;
    private String connectionKey;
    private long RECEIVE_TIME_FRAME = 3000L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.jms");

    public GSMessageConsumerImpl(GSSessionImpl session, Destination dest, String consumerID, String subsriptionName, String selector, boolean noLocal) throws JMSException {
        if (session == null) {
            throw new IllegalArgumentException("Argument 'session' is null");
        }
        if (dest == null) {
            throw new InvalidDestinationException("Argument 'dest' is null");
        }
        this.m_session = session;
        this.m_dest = dest;
        this.m_destName = this.m_dest.toString();
        this.m_consumerID = consumerID;
        this.m_durableSubscriptionName = subsriptionName;
        this.m_selector = selector;
        this.m_space = this.m_session.getConn().getSpace();
        this.connectionKey = this.m_session.getConn().getCnxKey();
        this.m_noLocal = noLocal;
        this.initTemplates();
        try {
            this.m_space.snapshot((Object)this.m_jmsMessageTemplate);
        }
        catch (RemoteException re) {
            JMSException e = new JMSException("RemoteException while space.snapshot(): ", re.toString());
            e.setLinkedException((Exception)re);
            throw e;
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Exception while space.snapshot(): ", e.toString());
            jmse.setLinkedException(e);
            throw jmse;
        }
        if (this.m_dest instanceof GSTopicImpl) {
            this.m_isQueue = false;
            this.onMessageEventListener = new OnMessageEventListener();
            try {
                this.createEventSessionConfig();
            }
            catch (IOException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.toString2() + "IOException inside GSMessageConsumerImpl: Failed to create DataEventSession configuration", e);
                }
                JMSException e1 = new JMSException("Failed to create DataEventSession configuration: " + e.toString());
                e1.setLinkedException((Exception)e);
                throw e1;
            }
            this.registerToNotifications();
        } else if (this.m_dest instanceof GSQueueImpl) {
            this.m_isQueue = true;
        }
        if (this.m_dest instanceof GSTemporaryQueueImpl) {
            String tempQueueSrcID = ((GSTemporaryQueueImpl)this.m_dest).getSourceID();
            if (StringsUtils.isEmpty(tempQueueSrcID) || !tempQueueSrcID.equals(this.m_session.getSessionID())) {
                throw new JMSSecurityException("Forbidden consumer with SessionID " + this.m_session.getSessionID() + " on this temporary queue with the session src id  " + tempQueueSrcID + " |  queueName: " + this.m_destName);
            }
        } else if (this.m_dest instanceof GSTemporaryTopicImpl) {
            String tempTopicSrcID = ((GSTemporaryTopicImpl)this.m_dest).getSourceID();
            if (StringsUtils.isEmpty(tempTopicSrcID) || !tempTopicSrcID.equals(this.m_session.getSessionID())) {
                throw new JMSSecurityException("Forbidden consumer with SessionID " + this.m_session.getSessionID() + " on this temporary topic with the session src id  " + tempTopicSrcID + " |  topicName: " + this.m_destName);
            }
            this.m_isQueue = false;
        }
    }

    private void initTemplates() {
        this.m_jmsMessageTemplate = new GSMessageImpl();
        this.m_jmsMessageTemplate.setDestinationName(this.m_destName);
        this.m_jmsMessageTemplate.setProperties(null);
    }

    private void createEventSessionConfig() throws IOException {
        this.eventSessionConfig = new EventSessionConfig();
        this.eventSessionConfig.setFifo(true);
        this.eventSessionConfig.setReplicateNotifyTemplate(true);
        this.eventSessionConfig.setTriggerNotifyTemplate(false);
    }

    GSMessageImpl getMessageTemplate() {
        return this.m_jmsMessageTemplate;
    }

    boolean checkMessageForConsumer(GSMessageImpl message) throws JMSException {
        if (!this.isValid(message)) {
            long ttl = message.getJMSExpiration();
            Time expTime = new Time(ttl);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString2() + "Not delivering JMS message < " + message.JMSMessageID + " > due to expiration: " + expTime);
            }
            return false;
        }
        if (this.m_noLocal) {
            boolean pass;
            String prodConnection = message.getStringProperty("JMS_GSConnectionKey");
            boolean bl = pass = !this.connectionKey.equals(prodConnection);
            if (!pass && _logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString2() + "Not delivering JMS message < " + message.JMSMessageID + " > due to noLocal attribute.");
            }
            return pass;
        }
        return true;
    }

    private boolean isValid(GSMessageImpl message) throws JMSException {
        long ttl = message.getJMSExpiration();
        return ttl == 0L || ttl - SystemTime.timeMillis() >= 0L;
    }

    synchronized void registerToNotifications() throws JMSException {
        if (this.m_closed) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.toString2() + "GSMessageConsumerImpl.registerToNotifications(): Called on a closed consumer.");
            }
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.toString2() + "GSMessageConsumerImpl.registerToNotifications(): registering for notifications");
        }
        try {
            this.eventSession = DataEventSessionFactory.create((IJSpace)this.m_space, (EventSessionConfig)this.eventSessionConfig);
            this.eventSession.addListener((Object)this.m_jmsMessageTemplate, (RemoteEventListener)this.onMessageEventListener, NotifyActionType.NOTIFY_WRITE);
        }
        catch (IOException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.toString2() + "GSMessageConsumerImpl.startAsynchronous(): IOException while creating event session" + e);
            }
            JMSException e1 = new JMSException("Failed to create event session.");
            e1.setLinkedException((Exception)e);
            throw e1;
        }
    }

    synchronized void unregisterToNotifications() throws JMSException {
        if (this.eventSession == null) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.toString2() + "GSMessageConsumerImpl.unregisterToNotifications(): unregistering from notifications");
        }
        try {
            this.eventSession.close();
        }
        catch (IOException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.toString2() + "GSMessageConsumerImpl.stopAsynchronous(): IOException while closing event session" + e);
            }
            JMSException e1 = new JMSException("Failed to close event session.");
            e1.setLinkedException((Exception)e);
            throw e1;
        }
        catch (UnknownLeaseException e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.toString2() + "GSMessageConsumerImpl.stopAsynchronous(): UnknownLeaseException while closing event session" + (Object)((Object)e));
            }
            JMSException e1 = new JMSException("Failed to close event session.");
            e1.setLinkedException((Exception)((Object)e));
            throw e1;
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.toString2() + "GSMessageConsumerImpl.stopAsynchronous(): UnknownLeaseException while closing event session" + e);
            }
            JMSException e1 = new JMSException("Failed to close event session.");
            e1.setLinkedException(e);
            throw e1;
        }
        finally {
            this.eventSession = null;
        }
    }

    public String getMessageSelector() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed consumer.");
        }
        return this.m_selector;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed consumer.");
        }
        return this.m_messageListener;
    }

    private void prepareMessageForConsumer(GSMessageImpl message) throws JMSException {
        message.setSession(this.m_session);
        message.setBodyReadOnly(true);
        message.setPropertiesReadOnly(true);
        if (message instanceof TextMessage && message.Body != null && message.Body instanceof MarshObject) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, this.toString2() + "Decompressing message: " + message.JMSMessageID);
            }
            try {
                Object decompressed = this.m_session.decompressObject((MarshObject)message.Body);
                message.Body = decompressed.toString();
            }
            catch (IOException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, this.toString2() + "IOException while decompressing message: " + message.JMSMessageID);
                }
                JMSException e1 = new JMSException("Failed to decompress message: " + message.JMSMessageID);
                e1.setLinkedException((Exception)e);
                throw e1;
            }
            catch (ClassNotFoundException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, this.toString2() + "ClassNotFoundException while decompressing message: " + message.JMSMessageID);
                }
                JMSException e1 = new JMSException("Failed to decompress message: " + message.JMSMessageID);
                e1.setLinkedException((Exception)e);
                throw e1;
            }
        }
    }

    public synchronized void setMessageListener(MessageListener listener) throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("GSMessageConsumerImpl.setMessageListener() -- Forbidden call on a closed consumer.");
        }
        this.innerSetMessageListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void innerSetMessageListener(MessageListener listener) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.toString2() + "Setting MessageListener: " + listener);
        }
        if (listener != null) {
            if (this.m_messageListener == null) {
                this.m_messageListener = listener;
                this.m_session.m_msgListeners.increment();
                this.asyncPoller = new AsyncPoller(this.m_consumerID);
                this.asyncPoller.start();
            } else {
                this.m_messageListener = listener;
            }
        } else if (this.m_messageListener != null) {
            Object object = this.m_session.stopMonitor;
            synchronized (object) {
                if (this.asyncPoller != null) {
                    this.asyncPoller.setShutDown();
                    this.notifyStop();
                    if (this.m_session.m_stopped) {
                        this.m_session.stopMonitor.notifyAll();
                    }
                }
            }
            if (this.asyncPoller != null) {
                block14: {
                    try {
                        this.asyncPoller.join(60000L);
                    }
                    catch (InterruptedException e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block14;
                        _logger.log(Level.SEVERE, this.toString2() + "Failed to wait for shutdown of thread " + this.asyncPoller.getName() + ".\n" + e);
                    }
                }
                this.asyncPoller = null;
            }
            this.m_messageListener = listener;
            this.m_session.m_msgListeners.decrement();
        }
    }

    public Message receive() throws JMSException {
        return this.receive(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(long timeout) throws JMSException {
        if (this.m_closed) {
            return null;
        }
        if (this.m_session.m_msgListeners.getValue() != 0) {
            throw new IllegalStateException("Forbidden call to receive() on asynchronous session.");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.toString2() + "GSMessageConsumerImpl.receive()");
        }
        if (timeout == 0L) {
            timeout = Long.MAX_VALUE;
        }
        long startTime = 0L;
        GSMessageImpl message = null;
        while (!this.m_closed && timeout > 10L) {
            Object re;
            try {
                startTime = SystemTime.timeMillis();
                Object object = this.m_session.stopMonitor;
                synchronized (object) {
                    block75: {
                        block76: {
                            if (!this.m_session.m_stopped) break block75;
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, this.toString2() + "receive(): Waiting on a stopped session.");
                            }
                            try {
                                this.m_session.stopMonitor.wait(timeout);
                            }
                            catch (InterruptedException e) {
                                if (!_logger.isLoggable(Level.SEVERE)) break block76;
                                _logger.log(Level.SEVERE, this.toString2() + "receive(): Interrupted while waiting on a stopped session: " + e);
                            }
                        }
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, this.toString2() + "receive(): Stopped waiting on a stopped session - restarting iteration.");
                        }
                        continue;
                    }
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, this.toString2() + "onProcess=true");
                    }
                    this.m_session.onProcess = true;
                }
                if (this.m_isQueue) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, this.toString2() + "Retrieving a message from queue.");
                    }
                    message = this.receiveFromQueueNoBlock(timeout);
                } else {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, this.toString2() + "Retrieving a message from topic.");
                    }
                    message = this.receiveFromTopic(timeout);
                }
                if (message == null) continue;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, this.toString2() + "receive(): Got message: " + message.JMSMessageID);
                }
                if (this.checkMessageForConsumer(message)) {
                    this.prepareMessageForConsumer(message);
                    if (this.m_session.isAutoAck()) {
                        this.m_session.acknowledge();
                        if (this.m_isQueue && !this.m_session.isAutoAck()) {
                            this.m_session.renewTransaction();
                        }
                    } else {
                        this.m_session.addUnackedMessage(message, this.m_consumerID);
                    }
                    ++this.m_session.m_numOfConsumedMsg;
                    break;
                }
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, this.toString2() + "Message not valid for consumer: " + message.JMSMessageID);
            }
            catch (ReceiveFromQueueException e) {
                String text;
                block79: {
                    block78: {
                        text = "Internal error while fetching a message from a Queue. ";
                        if (_logger.isLoggable(Level.SEVERE)) {
                            _logger.log(Level.SEVERE, this.toString2() + text + e.orig);
                        }
                        if (this.m_session.isAutoAck()) {
                            if (!_logger.isLoggable(Level.FINE)) continue;
                            _logger.log(Level.FINE, this.toString2() + "receive(): Session's ack mode is AUTO_ACKNOWLEDGE or DUPS_OK_ACKNOWLEDGE.\nRenewing transaction.");
                            continue;
                        }
                        if (this.m_session.m_acknowledgeMode == 0) {
                            block77: {
                                if (_logger.isLoggable(Level.FINE)) {
                                    _logger.log(Level.FINE, this.toString2() + "receive(): Session's ack mode is SESSION_TRANSACTED.\nRolling back transaction " + this.m_session.getTransaction());
                                }
                                try {
                                    this.m_session.rollback();
                                }
                                catch (JMSException e1) {
                                    if (!_logger.isLoggable(Level.SEVERE)) break block77;
                                    _logger.log(Level.SEVERE, this.toString2() + "receive(): Failed to roll back transaction");
                                }
                            }
                            re = new TransactionRolledBackException(text + "Transaction rolled back.");
                            re.setLinkedException(e.orig);
                            throw re;
                        }
                        if (this.m_session.m_acknowledgeMode != 2) continue;
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, this.toString2() + "receive(): Session's ack mode is CLIENT_ACKNOWLEDGE.\nRecovering messages of transaction " + this.m_session.getTransaction());
                        }
                        try {
                            this.m_session.recoverMessages();
                        }
                        catch (RollbackFailedException e1) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block78;
                            _logger.log(Level.SEVERE, this.toString2() + "receive(): Failed to recover messages of transaction " + this.m_session.getTransaction() + e1.orig);
                        }
                    }
                    try {
                        this.m_session.renewTransaction();
                    }
                    catch (TransactionCreateException e1) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block79;
                        _logger.log(Level.SEVERE, this.toString2() + "receive(): Failed to renew transaction", e1.orig);
                    }
                }
                re = new TransactionRolledBackException(text + "Transaction rolled back.");
                re.setLinkedException(e.orig);
                throw re;
            }
            catch (CommitFailedException e) {
                String text = "Internal error during auto commit. Message=" + message.JMSMessageID + ", Txn=" + this.m_session.getTransaction();
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, this.toString2() + text + e.orig);
                }
                try {
                    this.m_session.renewTransaction();
                }
                catch (TransactionCreateException e1) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, this.toString2() + "receive(): Failed to renew transaction: " + e1.orig);
                }
            }
            catch (TransactionCreateException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break;
                _logger.log(Level.SEVERE, this.toString2() + "receive(): Failed to renew transaction: " + e.orig);
                break;
            }
            finally {
                long now = SystemTime.timeMillis();
                timeout -= now - startTime;
                re = this.m_session.stopMonitor;
                synchronized (re) {
                    if (this.m_session.onProcess) {
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, this.toString2() + "onProcess=false");
                        }
                        this.m_session.onProcess = false;
                        this.m_session.stopMonitor.notifyAll();
                    }
                }
            }
        }
        return (Message)message;
    }

    public Message receiveNoWait() throws JMSException {
        return this.receive(2000L);
    }

    public boolean isClosed() {
        return this.m_closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        if (this.m_closed) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString2() + "GSMessageConsumerImpl.close(): Consumer already closed.");
            }
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.toString2() + "GSMessageConsumerImpl.close(): Closing consumer.");
        }
        this.m_session.removeConsumer(this);
        if (!this.m_isQueue) {
            this.unregisterToNotifications();
        }
        Object object = this.m_session.stopMonitor;
        synchronized (object) {
            this.m_closed = true;
            while (this.m_session.onProcess) {
                try {
                    this.notifyStop();
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(this.toString2() + "GSMessageConsumerImpl.close(): Waiting for process to finish.");
                    }
                    this.m_session.stopMonitor.wait();
                }
                catch (InterruptedException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.severe(this.toString2() + "GSMessageConsumerImpl.close(): InterruptedException while waiting for process to finish.");
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this.toString2() + "GSMessageConsumerImpl.close(): No message on process.");
            }
            if (this.m_session.m_stopped) {
                this.m_session.stopMonitor.notifyAll();
            }
        }
        if (this.m_messageListener != null) {
            this.innerSetMessageListener(null);
        }
        if (!this.m_isQueue) {
            object = this.synchTopicNotifyLock;
            synchronized (object) {
                this.synchTopicNotifyLock.notify();
            }
        }
    }

    public String toString() {
        return "MessageConsumer | Consumer ID: " + this.m_consumerID + " | Session ID: " + this.m_session.getSessionID();
    }

    private String toString2() {
        return "MessageConsumer[" + this.m_consumerID + "], Listener=" + this.m_messageListener + ": ";
    }

    public String getConsumerID() {
        return this.m_consumerID;
    }

    protected GSSessionImpl getSession() {
        return this.m_session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GSMessageImpl receiveFromTopic(long timeout) {
        GSMessageImpl message;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "receiveFromTopic(): Receiving from Topic");
        }
        if ((message = this.m_session.getNextRecoveredMessage()) != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, this.toString2() + "receiveFromTopic(): Recovered message found: " + message.JMSMessageID);
            }
            message.JMSRedelivered = Boolean.TRUE;
            return message;
        }
        long startTime = SystemTime.timeMillis();
        Object object = this.synchTopicNotifyLock;
        synchronized (object) {
            while (this.currentMessage == null && timeout > 0L) {
                block10: {
                    try {
                        this.synchTopicNotifyLock.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block10;
                        _logger.log(Level.SEVERE, this.toString2() + "receiveFromTopic(): InterruptedException while waiting for a message from a topic: " + e);
                    }
                }
                long now = SystemTime.timeMillis();
                timeout -= now - startTime;
                startTime = now;
            }
            if (this.currentMessage != null) {
                message = this.currentMessage != this.topicWakeupObject ? this.currentMessage : null;
                this.currentMessage = null;
                this.synchTopicNotifyLock.notify();
                return message;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyStop() {
        if (!this.m_isQueue) {
            Object object = this.synchTopicNotifyLock;
            synchronized (object) {
                if (this.currentMessage == null) {
                    this.currentMessage = this.topicWakeupObject;
                    this.synchTopicNotifyLock.notify();
                }
            }
        }
    }

    private GSMessageImpl receiveFromQueue(long timeout) throws ReceiveFromQueueException {
        Transaction txn = this.m_session.getTransaction();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "receiveFromQueue(): Receiving from Queue, txn=" + txn);
        }
        try {
            return (GSMessageImpl)this.m_space.take((Object)this.m_jmsMessageTemplate, txn, timeout);
        }
        catch (Exception e) {
            throw new ReceiveFromQueueException(e);
        }
    }

    private GSMessageImpl receiveFromQueueNoBlock(long timeout) throws ReceiveFromQueueException {
        long startTime = SystemTime.timeMillis();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, this.toString2() + "timeout=" + timeout);
        }
        while (!this.m_closed && !this.m_session.m_stopped && timeout > 10L) {
            GSMessageImpl message;
            long timeToWait = Math.min(timeout, this.RECEIVE_TIME_FRAME);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, this.toString2() + "Next timeToWait=" + timeToWait);
            }
            if ((message = this.receiveFromQueue(timeToWait)) != null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, this.toString2() + "Got message: " + message);
                }
                return message;
            }
            long now = SystemTime.timeMillis();
            timeout -= now - startTime;
            startTime = now;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, this.toString2() + "Exiting: m_closed=" + this.m_closed + ", m_stopped=" + this.m_session.m_stopped + ", timeout=" + timeout);
        }
        return null;
    }

    public String getName() {
        return this.m_durableSubscriptionName;
    }

    public boolean isDurableSubscriber() {
        return !StringsUtils.isEmpty(this.m_durableSubscriptionName);
    }

    public Queue getQueue() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed consumer.");
        }
        if (this.m_dest == null) {
            return null;
        }
        if (this.m_dest instanceof Queue) {
            return (Queue)this.m_dest;
        }
        throw new JMSException("The destination type of this producer is not a queue.");
    }

    public boolean getNoLocal() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed consumer.");
        }
        return this.m_noLocal;
    }

    public Topic getTopic() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed consumer.");
        }
        if (this.m_dest == null) {
            return null;
        }
        if (this.m_dest instanceof Topic) {
            return (Topic)this.m_dest;
        }
        throw new JMSException("The destination type of this producer is not a topic.");
    }

    public Destination getDestination() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed consumer.");
        }
        return this.m_dest;
    }

    private class AsyncPoller
    extends GSThread {
        boolean shutdown;

        public AsyncPoller(String consumerID) {
            super(consumerID + "_JMSAsyncPoller");
            this.shutdown = false;
        }

        public void setShutDown() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            GSMessageImpl message = null;
            while (!this.shutdown && !GSMessageConsumerImpl.this.m_closed && GSMessageConsumerImpl.this.m_messageListener != null) {
                String text;
                try {
                    Object object = GSMessageConsumerImpl.this.m_session.stopMonitor;
                    synchronized (object) {
                        block93: {
                            block94: {
                                if (!GSMessageConsumerImpl.this.m_session.m_stopped) break block93;
                                if (_logger.isLoggable(Level.FINE)) {
                                    _logger.log(Level.FINE, this.getName() + ": Waiting on a stopped session.");
                                }
                                try {
                                    GSMessageConsumerImpl.this.m_session.stopMonitor.wait();
                                }
                                catch (InterruptedException e) {
                                    if (!_logger.isLoggable(Level.SEVERE)) break block94;
                                    _logger.log(Level.SEVERE, this.getName() + ": Interrupted while waiting on a stopped session: " + e);
                                }
                            }
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, this.getName() + ": Stopped waiting on a stopped session - restarting iteration.");
                            }
                            continue;
                        }
                        if (_logger.isLoggable(Level.FINEST)) {
                            _logger.log(Level.FINEST, this.getName() + ": onProcess=true");
                        }
                        GSMessageConsumerImpl.this.m_session.onProcess = true;
                    }
                    message = GSMessageConsumerImpl.this.m_isQueue ? GSMessageConsumerImpl.this.receiveFromQueue(GSMessageConsumerImpl.this.RECEIVE_TIME_FRAME) : GSMessageConsumerImpl.this.receiveFromTopic(Long.MAX_VALUE);
                    if (message == null) {
                        if (!_logger.isLoggable(Level.FINE)) continue;
                        _logger.log(Level.FINE, this.getName() + ": No message was received.");
                        continue;
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, this.getName() + ": Received message: " + message.JMSMessageID);
                    }
                    if (!GSMessageConsumerImpl.this.checkMessageForConsumer(message)) continue;
                    GSMessageConsumerImpl.this.prepareMessageForConsumer(message);
                    GSMessageConsumerImpl.this.m_session.addUnackedMessage(message, GSMessageConsumerImpl.this.m_consumerID);
                    ++GSMessageConsumerImpl.this.m_session.m_numOfConsumedMsg;
                    GSMessageConsumerImpl.this.m_messageListener.onMessage((Message)message);
                    if (!GSMessageConsumerImpl.this.m_session.isAutoAck()) continue;
                    GSMessageConsumerImpl.this.m_session.acknowledge();
                    if (!GSMessageConsumerImpl.this.m_isQueue || GSMessageConsumerImpl.this.m_session.isAutoAck()) continue;
                    GSMessageConsumerImpl.this.m_session.renewTransaction();
                }
                catch (JMSException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, this.getName() + ": JMSException while handling message: " + message, e);
                }
                catch (ReceiveFromQueueException e) {
                    String exText;
                    block97: {
                        block96: {
                            text = "Internal error while fetching a message from a Queue - The space might be lost.\n";
                            if (_logger.isLoggable(Level.SEVERE)) {
                                _logger.log(Level.SEVERE, this.getName() + ": " + text, e.orig);
                            }
                            if (GSMessageConsumerImpl.this.m_session.isAutoAck()) {
                                if (!_logger.isLoggable(Level.FINE)) continue;
                                _logger.log(Level.FINE, this.getName() + ": The session's acknowledge mode is AUTO_ACKNOWLEDGE or DUPS_OK_ACKNOWLEDGE.");
                                continue;
                            }
                            if (GSMessageConsumerImpl.this.m_session.m_acknowledgeMode == 0) {
                                block95: {
                                    if (_logger.isLoggable(Level.INFO)) {
                                        _logger.log(Level.INFO, this.getName() + ": The session's acknowledge mode is SESSION_TRANSACTED.\nRolling back transaction " + GSMessageConsumerImpl.this.m_session.getTransaction());
                                    }
                                    try {
                                        GSMessageConsumerImpl.this.m_session.rollback();
                                    }
                                    catch (JMSException e1) {
                                        if (!_logger.isLoggable(Level.FINE)) break block95;
                                        _logger.log(Level.FINE, this.getName() + ": Failed to roll back transaction: " + GSMessageConsumerImpl.this.m_session.getTransaction(), e1.getLinkedException());
                                    }
                                }
                                exText = text + "The session's acknowledge mode is SESSION_TRANSACTED. The transaction was rolled back.";
                                GSMessageConsumerImpl.this.m_session.getConn().onException(new SpaceLostException(exText, e.orig, GSMessageConsumerImpl.this.m_session));
                                continue;
                            }
                            if (GSMessageConsumerImpl.this.m_session.m_acknowledgeMode != 2) continue;
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, this.getName() + ": The session's acknowledge mode is CLIENT_ACKNOWLEDGE.\nRecovering messages of transaction " + GSMessageConsumerImpl.this.m_session.getTransaction());
                            }
                            try {
                                GSMessageConsumerImpl.this.m_session.recoverMessages();
                            }
                            catch (RollbackFailedException e1) {
                                if (!_logger.isLoggable(Level.FINE)) break block96;
                                _logger.log(Level.FINE, this.getName() + ": Failed to recover messages of transaction " + GSMessageConsumerImpl.this.m_session.getTransaction(), e1.orig);
                            }
                        }
                        try {
                            GSMessageConsumerImpl.this.m_session.renewTransaction();
                        }
                        catch (TransactionCreateException e1) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block97;
                            _logger.log(Level.SEVERE, this.getName() + ": Failed to renew transaction", e1.orig);
                        }
                    }
                    exText = text + "The session's acknowledge mode is CLIENT_ACKNOWLEDGE. Unacknowledged messages are recovered.";
                    GSMessageConsumerImpl.this.m_session.getConn().onException(new SpaceLostException(exText, e.orig, GSMessageConsumerImpl.this.m_session));
                }
                catch (CommitFailedException e) {
                    text = ": Internal error during commit. Message=" + message.JMSMessageID + ", Txn=" + GSMessageConsumerImpl.this.m_session.getTransaction();
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, this.getName() + text + e.orig);
                    }
                    try {
                        GSMessageConsumerImpl.this.m_session.renewTransaction();
                    }
                    catch (TransactionCreateException e1) {
                        if (!_logger.isLoggable(Level.SEVERE)) continue;
                        _logger.log(Level.SEVERE, this.getName() + ": Failed to renew transaction: " + e1.orig);
                    }
                }
                catch (TransactionCreateException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, this.getName() + ": Failed to renew transaction: " + e.orig);
                }
                catch (RuntimeException e) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, this.getName() + ": RuntimeException not caught by client during asynchronous delivery: " + e + message);
                    }
                    if (!GSMessageConsumerImpl.this.m_session.isAutoAck()) continue;
                    GSMessageConsumerImpl.this.m_session.recoverMessages();
                    if (!GSMessageConsumerImpl.this.m_isQueue) continue;
                    try {
                        GSMessageConsumerImpl.this.m_session.renewTransaction();
                    }
                    catch (TransactionCreateException e1) {
                        if (!_logger.isLoggable(Level.SEVERE)) continue;
                        _logger.log(Level.SEVERE, this.getName() + ": Failed to renew transaction: " + e1.orig);
                    }
                    continue;
                    catch (RollbackFailedException e1) {
                        try {
                            if (_logger.isLoggable(Level.SEVERE)) {
                                _logger.log(Level.SEVERE, this.getName() + ": Failed to roll back transaction: " + GSMessageConsumerImpl.this.m_session.getTransaction(), e1.orig);
                            }
                            if (!GSMessageConsumerImpl.this.m_isQueue) continue;
                        }
                        catch (Throwable throwable) {
                            block98: {
                                if (GSMessageConsumerImpl.this.m_isQueue) {
                                    try {
                                        GSMessageConsumerImpl.this.m_session.renewTransaction();
                                    }
                                    catch (TransactionCreateException e12) {
                                        if (!_logger.isLoggable(Level.SEVERE)) break block98;
                                        _logger.log(Level.SEVERE, this.getName() + ": Failed to renew transaction: " + e12.orig);
                                    }
                                }
                            }
                            throw throwable;
                        }
                        try {
                            GSMessageConsumerImpl.this.m_session.renewTransaction();
                        }
                        catch (TransactionCreateException e13) {
                            if (!_logger.isLoggable(Level.SEVERE)) continue;
                            _logger.log(Level.SEVERE, this.getName() + ": Failed to renew transaction: " + e13.orig);
                        }
                    }
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.SEVERE)) continue;
                    _logger.log(Level.SEVERE, this.getName() + ": Exception during asynchronous message delivery: " + e);
                }
                finally {
                    Object e = GSMessageConsumerImpl.this.m_session.stopMonitor;
                    synchronized (e) {
                        if (GSMessageConsumerImpl.this.m_session.onProcess) {
                            if (_logger.isLoggable(Level.FINEST)) {
                                _logger.log(Level.FINEST, this.getName() + ": onProcess=false");
                            }
                            GSMessageConsumerImpl.this.m_session.onProcess = false;
                            GSMessageConsumerImpl.this.m_session.stopMonitor.notifyAll();
                        }
                    }
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.getName() + ": shutting down!");
            }
        }
    }

    class OnMessageEventListener
    implements RemoteEventListener {
        public void notify(RemoteEvent theEvent) throws UnknownEventException, RemoteException {
            block5: {
                try {
                    GSMessageImpl message = (GSMessageImpl)((EntryArrivedRemoteEvent)theEvent).getObject();
                    if (!GSMessageConsumerImpl.this.m_closed) {
                        this.messageArrived(message);
                    } else if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, GSMessageConsumerImpl.this.toString2() + "OnMessageEventListener.notify(): Called on a closed consumer." + message);
                    }
                }
                catch (UnusableEntryException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block5;
                    _logger.log(Level.SEVERE, GSMessageConsumerImpl.this.toString2() + "OnMessageEventListener.notify(): UnusableEntryException while extracting ExternalEntry: " + (Object)((Object)e));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void messageArrived(GSMessageImpl message) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, GSMessageConsumerImpl.this.toString2() + "messageArrived(): " + message.JMSMessageID);
            }
            Object object = GSMessageConsumerImpl.this.synchTopicNotifyLock;
            synchronized (object) {
                while (GSMessageConsumerImpl.this.currentMessage != null) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, GSMessageConsumerImpl.this.toString2() + "messageArrived(): A message is already pending: " + ((GSMessageConsumerImpl)GSMessageConsumerImpl.this).currentMessage.JMSMessageID);
                    }
                    try {
                        GSMessageConsumerImpl.this.synchTopicNotifyLock.wait();
                    }
                    catch (InterruptedException e) {
                        if (GSMessageConsumerImpl.this.m_session.isLocalConsumer(GSMessageConsumerImpl.this.m_consumerID)) {
                            if (!_logger.isLoggable(Level.SEVERE)) continue;
                            _logger.log(Level.SEVERE, GSMessageConsumerImpl.this.toString2() + "messageArrived(): The notification thread was interrupted. Notification message: " + message.JMSMessageID);
                            continue;
                        }
                        if (!_logger.isLoggable(Level.INFO)) continue;
                        _logger.log(Level.INFO, GSMessageConsumerImpl.this.toString2() + "messageArrived(): The notification thread is exiting. Notification message: " + message.JMSMessageID);
                    }
                }
                GSMessageConsumerImpl.this.currentMessage = message;
                GSMessageConsumerImpl.this.synchTopicNotifyLock.notify();
                while (!GSMessageConsumerImpl.this.m_closed && GSMessageConsumerImpl.this.currentMessage != null) {
                    try {
                        GSMessageConsumerImpl.this.synchTopicNotifyLock.wait();
                    }
                    catch (InterruptedException e) {
                        if (GSMessageConsumerImpl.this.m_session.isLocalConsumer(GSMessageConsumerImpl.this.m_consumerID)) {
                            if (!_logger.isLoggable(Level.SEVERE)) continue;
                            _logger.log(Level.SEVERE, GSMessageConsumerImpl.this.toString2() + "messageArrived(): The notification thread was interrupted while waiting to be released: " + ((GSMessageConsumerImpl)GSMessageConsumerImpl.this).currentMessage.JMSMessageID);
                            continue;
                        }
                        if (!_logger.isLoggable(Level.INFO)) continue;
                        _logger.log(Level.INFO, GSMessageConsumerImpl.this.toString2() + "messageArrived(): The notification thread is exiting. The consumer is closed. Pending message: " + ((GSMessageConsumerImpl)GSMessageConsumerImpl.this).currentMessage.JMSMessageID);
                    }
                }
            }
        }
    }
}

