/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.core.EntrySerializationException;
import com.j_spaces.core.client.IReplicatable;
import com.j_spaces.core.client.MetaDataEntry;
import com.j_spaces.jms.CommitFailedException;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.RollbackFailedException;
import com.j_spaces.jms.TransactionCreateException;
import com.j_spaces.jms.utils.ConversionHelper;
import com.j_spaces.jms.utils.IMessageConverter;
import com.j_spaces.jms.utils.SerializationHelper;
import com.j_spaces.jms.utils.StringsUtils;
import com.j_spaces.kernel.ClassHelper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TransactionRolledBackException;

public class GSMessageImpl
extends MetaDataEntry
implements Externalizable,
IReplicatable {
    private static final Integer[] constIntValues = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.jms");
    private boolean bodyRO = false;
    private boolean propertiesRO = false;
    private long ttl = 0L;
    public String DestinationName;
    protected transient GSSessionImpl session;
    public Object Body;
    public Destination JMSDestination;
    public Integer JMSDeliveryMode;
    public Long JMSExpiration;
    public Integer JMSPriority;
    public String JMSMessageID;
    public Long JMSTimestamp;
    public Object JMSCorrelationID;
    public Destination JMSReplyTo;
    public String JMSType;
    public Boolean JMSRedelivered;
    public Map<String, Object> Properties;
    protected static String[] indexedFields = new String[]{"DestinationName"};
    public static final String SIMPLE = "Simple";
    public static final String TEXT = "Text";
    public static final String OBJECT = "Object";
    public static final String MAP = "Map";
    public static final String STREAM = "Stream";
    public static final String BYTES = "Bytes";
    public static final String BODY_STR_NAME = "message_body";
    public static final String JMS_DESTINATION = "JMSDestination";
    public static final String JMS_DELIVERY_MODE = "JMSDeliveryMode";
    public static final String JMS_EXPIRATION = "JMSExpiration";
    public static final String JMS_PRIORITY = "JMSPriority";
    public static final String JMS_MESSAGE_ID = "JMSMessageID";
    public static final String JMS_TIMESTAMP = "JMSTimestamp";
    public static final String JMS_CORRELATION_ID = "JMSCorrelationID";
    public static final String JMS_REPLY_TO = "JMSReplyTo";
    public static final String JMS_TYPE = "JMSType";
    public static final String JMS_REDELIVERED = "JMSRedelivered";
    public static final String JMS_GSPRODUCER_KEY_PROP_NAME = "JMS_GSProducerKey";
    public static final String JMS_GSTTL_KEY_PROP_NAME = "JMS_GSTTLKey";
    public static final String JMSX_GROUPID = "JMSXGroupID";
    public static final String JMSX_GROUPSEQ = "JMSXGroupSeq";
    public static final String JMSX_USERID = "JMSXUserID";
    public static final String PROPERTIES_STR_NAME = "message_client_properties";
    public static final String JMS_GSCONNECTION_KEY_NAME = "JMS_GSConnectionKey";
    public static final String JMS_GSCONVERTER = "JMS_GSMessageConverter";
    private static final byte OBJECT_BIT = 0;
    private static final byte INTEGER_BIT = 1;
    private static final byte DOUBLE_BIT = 2;
    private static final byte FLOAT_BIT = 3;
    private static final byte LONG_BIT = 4;
    private static final byte STRING_BIT = 5;
    private static final byte SHORT_BIT = 6;
    private static final byte BOOLEAN_BIT = 7;
    private static final byte CHAR_BIT = 8;
    private static final byte BYTE_BIT = 9;

    public GSMessageImpl() {
        this.setFifo(true);
        this.setNOWriteLeaseMode(true);
        this.makeTransient();
    }

    public GSMessageImpl(GSSessionImpl session, String type) throws JMSException {
        this();
        this.setSession(session);
        this.setJMSType(type);
        this.Properties = new HashMap<String, Object>(0);
    }

    public static String[] __getSpaceIndexedFields() {
        return indexedFields;
    }

    public void setRoutingIndexes(String[] indexes) {
        indexedFields = indexes;
    }

    GSSessionImpl getSession() {
        return this.session;
    }

    void setTTL(long ttl) {
        this.ttl = ttl;
    }

    long getTTL() {
        return this.ttl;
    }

    void setSession(GSSessionImpl session) {
        this.session = session;
    }

    void setBodyReadOnly(boolean readOnly) {
        this.bodyRO = readOnly;
    }

    void setPropertiesReadOnly(boolean readOnly) {
        this.propertiesRO = readOnly;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acknowledge() throws JMSException {
        this.session.ensureOpen();
        if (this.session.m_acknowledgeMode != 2) {
            if (!_logger.isLoggable(Level.FINE)) return;
            _logger.fine("GSMessageImpl.acknowledge(): Session's acknowledge mode != CLIENT_ACKNOWLEDGE - ignoring." + this.JMSMessageID);
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSMessageImpl.acknowledge(): " + this.JMSMessageID);
        }
        try {
            this.session.acknowledge();
            if (!this.session.m_isQueue) return;
            if (this.session.isAutoAck()) return;
        }
        catch (CommitFailedException e) {
            try {
                block15: {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "GSMessageImpl.acknowledge(): Failed to acknowledge consumed messages: " + e.orig);
                    }
                    try {
                        this.session.recoverMessages();
                    }
                    catch (RollbackFailedException e1) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block15;
                        _logger.log(Level.SEVERE, "GSMessageImpl.acknowledge(): Failed to recover messages of transaction " + this.session.getTransaction() + e1.orig);
                    }
                }
                TransactionRolledBackException re = new TransactionRolledBackException("Failed to acknowledge consumed messages. Transaction rolled back.");
                re.setLinkedException(e.orig);
                throw re;
            }
            catch (Throwable throwable) {
                if (!this.session.m_isQueue) throw throwable;
                if (this.session.isAutoAck()) throw throwable;
                try {
                    this.session.renewTransaction();
                    throw throwable;
                }
                catch (TransactionCreateException e2) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "GSMessageImpl.acknowledge(): Failed to renew transaction");
                    }
                    JMSException je = new JMSException("Failed to renew transaction");
                    je.setLinkedException(e2.orig);
                    throw je;
                }
            }
        }
        try {
            this.session.renewTransaction();
            return;
        }
        catch (TransactionCreateException e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "GSMessageImpl.acknowledge(): Failed to renew transaction");
            }
            JMSException je = new JMSException("Failed to renew transaction");
            je.setLinkedException(e.orig);
            throw je;
        }
    }

    public void setDestinationName(String name) {
        this.DestinationName = name;
    }

    public String getDestinationName() {
        return this.DestinationName;
    }

    public void clearBody() throws JMSException {
        this.Body = null;
        this.setBodyReadOnly(false);
    }

    public void setJMSCorrelationID(String value) throws JMSException {
        this.JMSCorrelationID = value;
    }

    public String getJMSCorrelationID() throws JMSException {
        if (this.JMSCorrelationID != null) {
            if (this.JMSCorrelationID instanceof String) {
                return (String)this.JMSCorrelationID;
            }
            throw new JMSException("JMSCorrelationID is an array of bytes");
        }
        return null;
    }

    public void setJMSCorrelationIDAsBytes(byte[] value) throws JMSException {
        if (value != null) {
            this.JMSCorrelationID = new byte[value.length];
            System.arraycopy(value, 0, this.JMSCorrelationID, 0, value.length);
        } else {
            this.JMSCorrelationID = value;
        }
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (this.JMSCorrelationID != null) {
            if (this.JMSCorrelationID instanceof byte[]) {
                byte[] correlatiomId = (byte[])this.JMSCorrelationID;
                byte[] id = new byte[correlatiomId.length];
                System.arraycopy(correlatiomId, 0, id, 0, correlatiomId.length);
                return id;
            }
            throw new JMSException("JMSCorrelationID is a String");
        }
        return null;
    }

    public void setJMSDeliveryMode(int value) throws JMSException {
        if (value == 1) {
            this.makeTransient();
        } else if (value == 2) {
            this.makePersistent();
        } else {
            throw new JMSException("Delivery Mode of " + value + " is not valid");
        }
        this.JMSDeliveryMode = constIntValues[value];
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (this.JMSDeliveryMode != null) {
            return this.JMSDeliveryMode;
        }
        return 2;
    }

    public void setJMSDestination(Destination value) throws JMSException {
        this.JMSDestination = value;
        this.setDestinationName(value != null ? value.toString() : null);
    }

    public Destination getJMSDestination() throws JMSException {
        return this.JMSDestination;
    }

    public void setJMSExpiration(long value) throws JMSException {
        this.JMSExpiration = value;
    }

    public long getJMSExpiration() throws JMSException {
        if (this.JMSExpiration != null) {
            return this.JMSExpiration;
        }
        return 0L;
    }

    public void setJMSMessageID(String value) throws JMSException {
        this.JMSMessageID = value;
    }

    public String getJMSMessageID() throws JMSException {
        return this.JMSMessageID;
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (0 > priority || priority > 9) {
            throw new JMSException("Priority of " + priority + " is not valid");
        }
        this.JMSPriority = constIntValues[priority];
    }

    public int getJMSPriority() throws JMSException {
        if (this.JMSPriority != null) {
            return this.JMSPriority;
        }
        return 4;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.JMSRedelivered = redelivered ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean getJMSRedelivered() throws JMSException {
        if (this.JMSRedelivered != null) {
            return this.JMSRedelivered;
        }
        return false;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        this.JMSReplyTo = destination;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.JMSReplyTo;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.JMSTimestamp = timestamp;
    }

    public long getJMSTimestamp() throws JMSException {
        if (this.JMSTimestamp != null) {
            return this.JMSTimestamp;
        }
        return 0L;
    }

    public void setJMSType(String type) throws JMSException {
        if (!(type != null && (type.equals(SIMPLE) || type.equals(TEXT) || type.equals(OBJECT) || type.equals(MAP) || type.equals(STREAM) || type.equals(BYTES)))) {
            throw new JMSException("JMS type of " + type + "is not valid");
        }
        this.JMSType = type;
    }

    public String getJMSType() throws JMSException {
        if (this.JMSType != null) {
            return this.JMSType;
        }
        return SIMPLE;
    }

    public void clearProperties() throws JMSException {
        this.Properties.clear();
        this.setPropertiesReadOnly(false);
    }

    public Enumeration getPropertyNames() throws JMSException {
        HashSet<String> propNames = new HashSet<String>();
        for (String name : this.Properties.keySet()) {
            if (name.startsWith("JMS_GS") || name.startsWith("JMSX")) continue;
            propNames.add(name);
        }
        return Collections.enumeration(propNames);
    }

    public boolean propertyExists(String name) throws JMSException {
        return this.Properties.containsKey(name);
    }

    protected void checkPropertiesReadOnly() throws JMSException {
        if (this.propertiesRO) {
            throw new MessageNotWriteableException("Can't change message properties as they are read-only.");
        }
    }

    protected final void checkBodyReadOnly() throws MessageNotWriteableException {
        if (this.bodyRO) {
            throw new MessageNotWriteableException("Can't change message body as it is read-only.");
        }
    }

    protected final void checkBodyWriteOnly() throws MessageNotReadableException {
        if (!this.bodyRO) {
            throw new MessageNotReadableException("Can't read a value as the message body is write-only.");
        }
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value = this.Properties.get(name);
        return ConversionHelper.getBoolean(value);
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value = this.Properties.get(name);
        return ConversionHelper.getByte(value);
    }

    public double getDoubleProperty(String name) throws JMSException {
        Object value = this.Properties.get(name);
        return ConversionHelper.getDouble(value);
    }

    public float getFloatProperty(String name) throws JMSException {
        Object value = this.Properties.get(name);
        return ConversionHelper.getFloat(value);
    }

    public int getIntProperty(String name) throws JMSException {
        Object value = this.Properties.get(name);
        return ConversionHelper.getInt(value);
    }

    public long getLongProperty(String name) throws JMSException {
        Object value = this.Properties.get(name);
        return ConversionHelper.getLong(value);
    }

    public Object getObjectProperty(String name) throws JMSException {
        return this.Properties.get(name);
    }

    public short getShortProperty(String name) throws JMSException {
        Object value = this.Properties.get(name);
        return ConversionHelper.getShort(value);
    }

    public String getStringProperty(String name) throws JMSException {
        Object value = this.Properties.get(name);
        return ConversionHelper.getString(value);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkPropertiesReadOnly();
        Boolean i = value ? Boolean.TRUE : Boolean.FALSE;
        this.checkProperty(name, i);
        this.Properties.put(name, i);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkPropertiesReadOnly();
        Byte i = value;
        this.checkProperty(name, i);
        this.Properties.put(name, i);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkPropertiesReadOnly();
        Double i = value;
        this.checkProperty(name, i);
        this.Properties.put(name, i);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkPropertiesReadOnly();
        Float i = Float.valueOf(value);
        this.checkProperty(name, i);
        this.Properties.put(name, i);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        this.checkPropertiesReadOnly();
        Integer i = value;
        this.checkProperty(name, i);
        this.Properties.put(name, i);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        this.checkPropertiesReadOnly();
        Long i = value;
        this.checkProperty(name, i);
        this.Properties.put(name, i);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkPropertiesReadOnly();
        this.checkProperty(name, value);
        if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value == null) {
            this.Properties.put(name, value);
            return;
        } else {
            if (!(value instanceof IMessageConverter)) throw new MessageFormatException("Invalid object type: Message.setObjectProperty() does not support objects of type " + value.getClass().getName());
            if (!name.equals(JMS_GSCONVERTER)) throw new MessageFormatException("Property value of type IMessageConverter can be set only for the property JMS_GSMessageConverter");
            this.Properties.put(name, value);
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        this.checkPropertiesReadOnly();
        Short i = value;
        this.checkProperty(name, i);
        this.Properties.put(name, i);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        this.checkPropertiesReadOnly();
        this.checkProperty(name, value);
        this.Properties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof GSMessageImpl) {
            if (this.JMSMessageID != null) {
                return this.JMSMessageID.equals(((GSMessageImpl)o).JMSMessageID);
            }
            return ((GSMessageImpl)o).JMSMessageID == null;
        }
        return false;
    }

    public int hashCode() {
        if (this.JMSMessageID != null) {
            return this.JMSMessageID.hashCode();
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(this.getClass().getName());
        sb.append(":\n\tBody:\n\t\t");
        sb.append(this.Body);
        sb.append("\n\tHeaders:");
        sb.append("\n\t\tJMSDestination:\t\t");
        sb.append(this.JMSDestination);
        sb.append("\n\t\tJMSDeliveryMode:\t");
        sb.append(this.JMSDeliveryMode);
        sb.append("\n\t\tJMSExpiration:\t\t");
        sb.append(this.JMSExpiration);
        sb.append("\n\t\tJMSPriority:\t\t");
        sb.append(this.JMSPriority);
        sb.append("\n\t\tJMSMessageID:\t\t");
        sb.append(this.JMSMessageID);
        sb.append("\n\t\tJMSTimestamp:\t\t");
        sb.append(this.JMSTimestamp);
        sb.append("\n\t\tJMSCorrelationID:\t");
        sb.append(this.JMSCorrelationID);
        sb.append("\n\t\tJMSReplyTo:\t\t");
        sb.append(this.JMSReplyTo);
        sb.append("\n\t\tJMSType:\t\t");
        sb.append(this.JMSType);
        sb.append("\n\t\tJMSRedelivered:\t\t");
        sb.append(this.JMSRedelivered);
        sb.append("\n\tProperties:\n\t\t");
        if (this.Properties != null) {
            sb.append(this.Properties.toString());
        }
        return sb.toString();
    }

    GSMessageImpl duplicate() throws JMSException {
        GSMessageImpl dup = new GSMessageImpl();
        this.copyTo(dup);
        return dup;
    }

    protected void copyTo(GSMessageImpl dup) {
        dup.setFifo(this.isFifo());
        if (this.isTransient()) {
            dup.makeTransient();
        } else {
            dup.makePersistent();
        }
        dup.setNOWriteLeaseMode(this.isNOWriteLeaseMode());
        dup.bodyRO = this.bodyRO;
        dup.propertiesRO = this.propertiesRO;
        dup.session = this.session;
        dup.DestinationName = this.DestinationName;
        dup.ttl = this.ttl;
        dup.JMSDestination = this.JMSDestination;
        dup.JMSDeliveryMode = this.JMSDeliveryMode;
        dup.JMSExpiration = this.JMSExpiration;
        dup.JMSPriority = this.JMSPriority;
        dup.JMSMessageID = this.JMSMessageID;
        dup.JMSTimestamp = this.JMSTimestamp;
        dup.JMSCorrelationID = this.JMSCorrelationID;
        dup.JMSReplyTo = this.JMSReplyTo;
        dup.JMSType = this.JMSType;
        dup.JMSRedelivered = this.JMSRedelivered;
        dup.Body = this.cloneBody();
        dup.Properties = this.cloneProperties();
    }

    protected Object cloneObject(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String || obj instanceof Boolean || obj instanceof Byte || obj instanceof Short || obj instanceof Character || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
            return obj;
        }
        if (obj instanceof byte[]) {
            byte[] body = (byte[])obj;
            byte[] data = new byte[body.length];
            System.arraycopy(body, 0, data, 0, body.length);
            return data;
        }
        return SerializationHelper.deepClone(obj);
    }

    protected Object cloneBody() {
        return this.cloneObject(this.Body);
    }

    HashMap<String, Object> cloneProperties() {
        if (this.Properties == null) {
            return null;
        }
        HashMap<String, Object> props = new HashMap<String, Object>(this.Properties.size());
        props.putAll(this.Properties);
        return props;
    }

    public void setProperties(HashMap<String, Object> props) {
        this.Properties = props;
    }

    private void checkProperty(String name, Object val) throws JMSException {
        if (name == null) {
            throw new JMSException("The name of a property must not be null.");
        }
        if (name.equals("")) {
            throw new JMSException("The name of a property must not be an empty String.");
        }
        char[] chars = name.toCharArray();
        if (chars.length == 0) {
            throw new JMSException("zero-length name is not a valid property name");
        }
        if (!Character.isJavaIdentifierStart(chars[0])) {
            throw new JMSException("Property name " + name + " is not a valid property name");
        }
        for (int i = 1; i < chars.length; ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            throw new JMSException("Property name" + name + " is not a valid property name");
        }
        if (name.startsWith("JMSX")) {
            boolean found = false;
            for (int i = 0; i < GSSessionImpl.JMSX_CLIENT_NAMES.length; ++i) {
                Object[] types = GSSessionImpl.JMSX_CLIENT_NAMES[i];
                if (!types[0].equals(name)) continue;
                if (val == null) {
                    throw new MessageFormatException("Property=" + name + " may not be null");
                }
                Class type = (Class)types[1];
                if (!type.equals(val.getClass())) {
                    throw new MessageFormatException("Expected type " + type.getName() + " for property" + name + ", but got type " + val.getClass().getName());
                }
                if (name.equals(JMSX_GROUPSEQ) && (Integer)val <= 0) {
                    throw new JMSException("JMSXGroupSeq must have a value > 0");
                }
                found = true;
                break;
            }
            if (!found) {
                throw new JMSException("The property name '" + name + "' is not a valid java identifier.Property names with prefix 'JMSX' are reserved for provider usage and cannot be set by clients.");
            }
        }
        if (name.startsWith("JMSX")) {
            if (name.equals(JMSX_GROUPID)) {
                if (!ClassHelper.getPrimitiveName(val.getClass()).equalsIgnoreCase("int")) {
                    // empty if block
                }
                return;
            }
            if (name.equals(JMSX_GROUPSEQ)) {
                return;
            }
            throw new JMSException("The property name '" + name + "' is not a valid java identifier.Property names with prefix 'JMSX' are reserved for provider usage.");
        }
        if (name.startsWith("JMS_GS")) {
            if (name.equals(JMS_GSCONNECTION_KEY_NAME)) {
                return;
            }
            if (name.equals(JMS_GSCONVERTER)) {
                if (val == null || val instanceof IMessageConverter) {
                    return;
                }
                throw new MessageFormatException("The value of property " + name + " should be of type IMessageConverter.");
            }
            throw new JMSException("The property name '" + name + "' is not a valid java identifier.Property names with prefix 'JMS_GS' arereserved for JMS Message usage and cannot be set by clients.");
        }
        if (name.startsWith("JMS")) {
            throw new JMSException("The property name '" + name + "' is not a valid java identifier.Property names with prefix 'JMS' are reserved for JMS Message usage and cannot be set by clients.");
        }
        if (!StringsUtils.isValidJavaIdentifier(name)) {
            throw new JMSException("The property name '" + name + "' is not a valid java identifier.");
        }
        if (GSSessionImpl.reservedSelectorIdentifiers.contains(name.toUpperCase())) {
            throw new JMSException("The property name '" + name + "' is reserved due to message selector syntax.");
        }
    }

    private int buildFlags() {
        int flags = 0;
        if (this.DestinationName != null) {
            flags |= 1;
        }
        if (this.JMSDestination != null) {
            flags |= 2;
        }
        if (this.JMSDeliveryMode != null) {
            flags |= 4;
        }
        if (this.JMSExpiration != null) {
            flags |= 8;
        }
        if (this.JMSPriority != null) {
            flags |= 0x10;
        }
        if (this.JMSMessageID != null) {
            flags |= 0x20;
        }
        if (this.JMSTimestamp != null) {
            flags |= 0x40;
        }
        if (this.JMSCorrelationID != null) {
            flags |= 0x80;
        }
        if (this.JMSReplyTo != null) {
            flags |= 0x100;
        }
        if (this.JMSType != null) {
            flags |= 0x200;
        }
        if (this.JMSRedelivered != null) {
            flags |= 0x400;
        }
        if (this.Body != null) {
            flags |= 0x800;
        }
        if (this.Properties != null) {
            flags |= 0x1000;
        }
        return flags;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            super._writeExternal(out);
            int flags = this.buildFlags();
            out.writeInt(flags);
            if (this.DestinationName != null) {
                out.writeUTF(this.DestinationName);
            }
            if (this.JMSDestination != null) {
                if (out instanceof ObjectOutputStream) {
                    ((ObjectOutputStream)out).writeUnshared(this.JMSDestination);
                } else {
                    out.writeObject(this.JMSDestination);
                }
            }
            if (this.JMSDeliveryMode != null) {
                out.writeInt(this.JMSDeliveryMode);
            }
            if (this.JMSExpiration != null) {
                out.writeLong(this.JMSExpiration);
            }
            if (this.JMSPriority != null) {
                out.writeInt(this.JMSPriority);
            }
            if (this.JMSMessageID != null) {
                out.writeUTF(this.JMSMessageID);
            }
            if (this.JMSTimestamp != null) {
                out.writeLong(this.JMSTimestamp);
            }
            if (this.JMSCorrelationID != null) {
                if (this.JMSCorrelationID instanceof byte[]) {
                    byte[] correlationId = (byte[])this.JMSCorrelationID;
                    out.writeByte(9);
                    out.writeInt(correlationId.length);
                    out.write(correlationId);
                } else {
                    out.writeByte(5);
                    out.writeUTF(this.JMSCorrelationID.toString());
                }
            }
            if (this.JMSReplyTo != null) {
                if (out instanceof ObjectOutputStream) {
                    ((ObjectOutputStream)out).writeUnshared(this.JMSReplyTo);
                } else {
                    out.writeObject(this.JMSReplyTo);
                }
            }
            if (this.JMSType != null) {
                out.writeUTF(this.JMSType);
            }
            if (this.JMSRedelivered != null) {
                out.writeBoolean(this.JMSRedelivered);
            }
            if (this.Body != null) {
                if (out instanceof ObjectOutputStream) {
                    ((ObjectOutputStream)out).writeUnshared(this.Body);
                } else {
                    out.writeObject(this.Body);
                }
            }
            if (this.Properties != null) {
                out.writeInt(this.Properties.size());
                for (String name : this.Properties.keySet()) {
                    out.writeUTF(name);
                    this.writePrimitiveObject(out, this.Properties.get(name), name);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof EntrySerializationException) {
                throw (EntrySerializationException)ex;
            }
            throw new EntrySerializationException("Failed to serialize JMS message: " + this.toString(), (Throwable)ex);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            super._readExternal(in);
            int flags = in.readInt();
            if ((flags & 1) != 0) {
                this.DestinationName = in.readUTF();
            }
            if ((flags & 2) != 0) {
                this.JMSDestination = in instanceof ObjectInputStream ? (Destination)((ObjectInputStream)in).readUnshared() : (Destination)in.readObject();
            }
            if ((flags & 4) != 0) {
                this.JMSDeliveryMode = in.readInt();
            }
            if ((flags & 8) != 0) {
                this.JMSExpiration = in.readLong();
            }
            if ((flags & 0x10) != 0) {
                this.JMSPriority = in.readInt();
            }
            if ((flags & 0x20) != 0) {
                this.JMSMessageID = in.readUTF();
            }
            if ((flags & 0x40) != 0) {
                this.JMSTimestamp = in.readLong();
            }
            if ((flags & 0x80) != 0) {
                byte type = in.readByte();
                if (type == 9) {
                    int size = in.readInt();
                    byte[] correlationId = new byte[size];
                    in.readFully(correlationId);
                    this.JMSCorrelationID = correlationId;
                } else {
                    this.JMSCorrelationID = in.readUTF();
                }
            }
            if ((flags & 0x100) != 0) {
                this.JMSReplyTo = in instanceof ObjectInputStream ? (Destination)((ObjectInputStream)in).readUnshared() : (Destination)in.readObject();
            }
            if ((flags & 0x200) != 0) {
                this.JMSType = in.readUTF();
            }
            if ((flags & 0x400) != 0) {
                this.JMSRedelivered = in.readBoolean();
            }
            if ((flags & 0x800) != 0) {
                this.Body = in instanceof ObjectInputStream ? ((ObjectInputStream)in).readUnshared() : in.readObject();
            }
            if ((flags & 0x1000) != 0) {
                int size = in.readInt();
                this.Properties = new HashMap<String, Object>(size);
                for (int i = 0; i < size; ++i) {
                    String name = in.readUTF();
                    Object value = this.readPrimitiveObject(in, name);
                    this.Properties.put(name, value);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof EntrySerializationException) {
                throw (EntrySerializationException)ex;
            }
            String id = this.JMSMessageID != null ? this.JMSMessageID : "";
            throw new EntrySerializationException("Failed to deserialize JMS message: " + id, (Throwable)ex);
        }
    }

    private void writePrimitiveObject(ObjectOutput out, Object obj, String name) throws IOException {
        try {
            if (obj instanceof Integer) {
                out.writeByte(1);
                out.writeInt((Integer)obj);
            } else if (obj instanceof Double) {
                out.writeByte(2);
                out.writeDouble((Double)obj);
            } else if (obj instanceof Float) {
                out.writeByte(3);
                out.writeFloat(((Float)obj).floatValue());
            } else if (obj instanceof Long) {
                out.writeByte(4);
                out.writeLong((Long)obj);
            } else if (obj instanceof String && (long)((String)obj).length() <= 65535L) {
                out.writeByte(5);
                out.writeUTF((String)obj);
            } else if (obj instanceof Short) {
                out.writeByte(6);
                out.writeShort(((Short)obj).shortValue());
            } else if (obj instanceof Boolean) {
                out.writeByte(7);
                out.writeBoolean((Boolean)obj);
            } else if (obj instanceof Character) {
                out.writeByte(8);
                out.writeChar(((Character)obj).charValue());
            } else if (obj instanceof Byte) {
                out.writeByte(9);
                out.writeByte(((Byte)obj).byteValue());
            } else {
                out.writeByte(0);
                if (out instanceof ObjectOutputStream) {
                    ((ObjectOutputStream)out).writeUnshared(obj);
                } else {
                    out.writeObject(obj);
                }
            }
        }
        catch (IOException ex) {
            throw new EntrySerializationException("Failed to serialize JMS message property: JMSMessageID=" + this.JMSMessageID + ", Property Name: " + name + ", Property Value: " + obj, (Throwable)ex);
        }
    }

    private Object readPrimitiveObject(ObjectInput in, String name) throws IOException, ClassNotFoundException {
        try {
            byte bitCode = in.readByte();
            switch (bitCode) {
                case 1: {
                    return in.readInt();
                }
                case 2: {
                    return in.readDouble();
                }
                case 3: {
                    return Float.valueOf(in.readFloat());
                }
                case 4: {
                    return in.readLong();
                }
                case 5: {
                    return in.readUTF();
                }
                case 6: {
                    return in.readShort();
                }
                case 7: {
                    return in.readBoolean();
                }
                case 8: {
                    return Character.valueOf(in.readChar());
                }
                case 9: {
                    return in.readByte();
                }
            }
            if (in instanceof ObjectInputStream) {
                return ((ObjectInputStream)in).readUnshared();
            }
            return in.readObject();
        }
        catch (IOException ex) {
            throw new EntrySerializationException("Failed to deserialize JMS message property: JMSMessageID=" + this.JMSMessageID + ", Property Name: " + name, (Throwable)ex);
        }
    }

    private static final class BitMap {
        private static final int DESTINATION_NAME_BIT = 1;
        private static final int JMS_DESTINATION_BIT = 2;
        private static final int JMS_DELIVERY_MODE_BIT = 4;
        private static final int JMS_EXPIRATION_BIT = 8;
        private static final int JMS_PRIORITY_BIT = 16;
        private static final int JMS_MESSAGE_ID_BIT = 32;
        private static final int JMS_TIMESTAMP_BIT = 64;
        private static final int JMS_CORRELATION_ID_BIT = 128;
        private static final int JMS_REPLY_TO_BIT = 256;
        private static final int JMS_TYPE_BIT = 512;
        private static final int JMS_REDELIVERED_BIT = 1024;
        private static final int BODY_BIT = 2048;
        private static final int PROPERTIES_BIT = 4096;

        private BitMap() {
        }
    }
}

