/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.jms.GSBytesMessageImpl;
import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.utils.IMessageConverter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import net.jini.core.transaction.TransactionException;

public class GSMessageProducerImpl
implements MessageProducer,
QueueSender,
TopicPublisher {
    private int m_deliveryMode = 1;
    private int m_priority = 4;
    private long m_timeToLive = 0L;
    protected GSSessionImpl m_session = null;
    protected Destination m_dest = null;
    protected volatile boolean m_closed = false;
    private volatile boolean m_messageIDDisabled = false;
    private volatile boolean m_timestampDisabled = false;
    private String m_producerID;
    private String m_connectionKey;
    private String m_msgIDPrefix;
    private IMessageConverter messageConverter;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.jms");

    public GSMessageProducerImpl(GSSessionImpl sess, Destination m_dest, IMessageConverter messageConverter) throws JMSException {
        if (sess == null) {
            throw new IllegalArgumentException("GSMessageProducerImpl  Argument 'session' is null");
        }
        this.m_session = sess;
        this.m_dest = m_dest;
        this.messageConverter = messageConverter;
        this.m_msgIDPrefix = "ID:" + this.m_session.getSessionID() + "_m";
        this.m_connectionKey = this.m_session.getConn().getCnxKey();
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.m_messageIDDisabled = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.m_messageIDDisabled;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.m_timestampDisabled = value;
    }

    public void setProducerID(String m_producerID) {
        this.m_producerID = m_producerID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.m_timestampDisabled;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.m_deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        return this.m_deliveryMode;
    }

    public void setPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            throw new JMSException(priority + " is an invalid priority value");
        }
        this.m_priority = priority;
    }

    public int getPriority() throws JMSException {
        return this.m_priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        if (timeToLive < 0L) {
            throw new JMSException(timeToLive + " is an invalid TimeToLive value");
        }
        this.m_timeToLive = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        return this.m_timeToLive;
    }

    public Destination getDestination() throws JMSException {
        return this.m_dest;
    }

    public synchronized void close() throws JMSException {
        if (this.m_closed) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSMessageProducerImpl.close(): " + this.toString());
        }
        this.m_session.removeProducer(this);
        this.m_session = null;
        this.m_closed = true;
    }

    public void send(Message message) throws JMSException {
        if (this.m_dest == null) {
            throw new UnsupportedOperationException("No destination is specified for this producer: " + this.m_producerID);
        }
        this.send(this.m_dest, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (this.m_dest == null) {
            throw new UnsupportedOperationException("No destination is specified for this producer: " + this.m_producerID);
        }
        this.send(this.m_dest, message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Destination _destination, Message _message, int _deliveryMode, int _priority, long _timeToLive) throws JMSException {
        block13: {
            if (_destination == null || !(_destination instanceof Queue) && !(_destination instanceof Topic)) {
                throw new InvalidDestinationException("Can't send message to an unidentified destination: " + _destination);
            }
            if (_deliveryMode != 1 && _deliveryMode != 2) {
                throw new JMSException("Delivery Mode of " + _deliveryMode + " is not valid (should be " + 1 + " integer for a Non-Persistent delivery, or " + 2 + " integer for a Persistent delivery).");
            }
            if (0 > _priority || _priority > 9) {
                throw new JMSException("Message Priority of " + _priority + " is not valid (should be an integer between 0 and 9).");
            }
            GSMessageImpl message = (GSMessageImpl)_message;
            try {
                this.prepareMessageToSend(message, _deliveryMode, _priority, _timeToLive, _destination);
                this.m_session.handleSendMessage(message);
            }
            catch (RemoteException re) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Exception inside GSMessageProducerImpl.send(: " + re.toString(), re);
                }
                JMSException e = new JMSException("RemoteException : " + re.toString());
                e.setLinkedException((Exception)re);
                throw e;
            }
            catch (TransactionException te) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Exception inside GSMessageProducerImpl.send(: " + te.toString(), te);
                }
                JMSException e = new JMSException("TransactionException : " + te.toString());
                e.setLinkedException((Exception)((Object)te));
                throw e;
            }
            catch (EntryAlreadyInSpaceException eaine) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.severe("GSMessageProducerImpl.send() EntryAlreadyInSpaceException: " + message.DestinationName + "  |  destination:  " + _destination + "  |  uid:  " + message.__getEntryInfo().m_UID);
                }
                JMSException e = new JMSException("EntryAlreadyInSpaceException : " + eaine.toString());
                e.setLinkedException((Exception)((Object)eaine));
                throw e;
            }
            catch (Exception e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "Exception inside GSMessageProducerImpl.send(): ", e);
                }
                if (e instanceof InterruptedException) break block13;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, e.toString(), e);
                }
                JMSException jmse = new JMSException("Exception: " + e.toString());
                jmse.setLinkedException(e);
                throw jmse;
            }
        }
    }

    private void prepareMessageToSend(GSMessageImpl message, int deliveryMode, int priority, long timeToLive, Destination destination) throws JMSException {
        if (message instanceof GSBytesMessageImpl) {
            try {
                ((GSBytesMessageImpl)message).seal();
            }
            catch (IOException e) {
                JMSException jmse = new JMSException("IOException while clearing message body: " + e.toString());
                jmse.setLinkedException((Exception)e);
                throw jmse;
            }
        }
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        message.setJMSDestination(destination);
        message.setJMSRedelivered(false);
        String msgID = this.m_msgIDPrefix + this.m_session.nextMessageNum();
        message.setJMSMessageID(msgID);
        message.__setEntryInfo(null);
        Long now = SystemTime.timeMillis();
        if (timeToLive == 0L) {
            message.setJMSExpiration(0L);
        } else {
            message.setJMSExpiration(now + timeToLive);
        }
        message.setTTL(timeToLive);
        if (!this.m_timestampDisabled) {
            message.setJMSTimestamp(now);
        }
        message.setBodyReadOnly(false);
        message.setPropertiesReadOnly(false);
        message.setStringProperty("JMS_GSConnectionKey", this.m_connectionKey);
        if (this.messageConverter != null && !message.Properties.containsKey("JMS_GSMessageConverter")) {
            message.Properties.put("JMS_GSMessageConverter", this.messageConverter);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MessageProducer | Producer ID: ");
        sb.append(this.m_producerID);
        sb.append("  |  Session ID: ");
        if (this.m_session == null) {
            sb.append(" NULL session");
        } else {
            sb.append(this.m_session.getSessionID());
        }
        return sb.toString();
    }

    public String getProducerID() {
        return this.m_producerID;
    }

    protected GSSessionImpl getSession() {
        return this.m_session;
    }

    public Queue getQueue() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        if (this.m_dest == null) {
            return null;
        }
        if (this.m_dest instanceof Queue) {
            return (Queue)this.m_dest;
        }
        throw new JMSException("The destination type of this producer is not a queue.");
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send((Destination)queue, message, deliveryMode, priority, timeToLive);
    }

    public Topic getTopic() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed producer.");
        }
        if (this.m_dest == null) {
            return null;
        }
        if (this.m_dest instanceof Topic) {
            return (Topic)this.m_dest;
        }
        throw new JMSException("The destination type of this producer is not a topic.");
    }

    public void publish(Message message) throws JMSException {
        this.send(message);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.send((Destination)topic, message);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send((Destination)topic, message, deliveryMode, priority, timeToLive);
    }
}

