/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.utils.SerializationHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.ObjectMessage;

public class GSObjectMessageImpl
extends GSMessageImpl
implements ObjectMessage {
    private static final long serialVersionUID = 1L;

    public GSObjectMessageImpl() throws JMSException {
    }

    public GSObjectMessageImpl(GSSessionImpl session, Serializable objBody) throws JMSException {
        super(session, "Object");
        this.setObject(objBody);
    }

    public GSObjectMessageImpl(GSSessionImpl session) throws JMSException {
        this(session, (Serializable)null);
    }

    public final void setObject(Serializable obj) throws JMSException {
        this.checkBodyReadOnly();
        this.Body = this.cloneObject(obj);
    }

    public final Serializable getObject() throws MessageFormatException {
        Object clone = this.cloneBody();
        if (clone != null) {
            return (Serializable)clone;
        }
        return null;
    }

    public void writeBody(DataOutput dataOut) throws IOException {
        SerializationHelper.writeObject((OutputStream)((Object)dataOut), this.Body);
    }

    public void readBody(DataInput dataIn) throws IOException {
        try {
            this.Body = SerializationHelper.readObject((InputStream)((Object)dataIn));
        }
        catch (ClassNotFoundException ex) {
            throw new IOException(ex.toString());
        }
    }

    @Override
    GSMessageImpl duplicate() throws JMSException {
        GSObjectMessageImpl dup = new GSObjectMessageImpl();
        this.copyTo(dup);
        return dup;
    }

    @Override
    protected Object cloneBody() {
        return this.cloneObject(this.Body);
    }
}

