/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.gigaspaces.client.iterator.GSIteratorConfig;
import com.gigaspaces.client.iterator.IteratorScope;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.core.client.GSIterator;
import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSSessionImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import net.jini.core.entry.UnusableEntryException;

public class GSQueueBrowserImpl
implements QueueBrowser {
    private GSSessionImpl m_session;
    private Queue m_queue;
    private String m_selector;
    private boolean m_closed = false;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.jms");
    private static final int iteratorBufferSize = Integer.getInteger("com.gs.jms.iterator.buffersize", 1000);
    private GSIterator gsIterator;

    GSQueueBrowserImpl(GSSessionImpl sess, Queue queue, String selector) throws JMSException {
        this.m_session = sess;
        this.m_queue = queue;
        this.m_selector = selector;
        if (this.m_queue == null) {
            throw new InvalidDestinationException("GSQueueBrowserImpl Invalid queue: " + this.m_queue);
        }
        GSMessageImpl template = new GSMessageImpl();
        template.setDestinationName(this.m_queue.getQueueName());
        ArrayList<GSMessageImpl> templates = new ArrayList<GSMessageImpl>(1);
        templates.add(template);
        GSIteratorConfig config = new GSIteratorConfig();
        config.setBufferSize(iteratorBufferSize);
        config.setIteratorScope(IteratorScope.CURRENT_AND_FUTURE);
        try {
            this.gsIterator = new GSIterator(this.m_session.getConn().getSpace(), templates, config);
        }
        catch (RemoteException re) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Exception inside GSQueueBrowserImpl: " + re.toString(), re);
            }
            JMSException e = new JMSException("RemoteException: " + re.toString());
            e.setLinkedException((Exception)re);
            throw e;
        }
        catch (UnusableEntryException uue) {
            if (uue instanceof EntryNotInSpaceException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "The Entry " + ((EntryNotInSpaceException)uue).getUID() + " is no longer in Space " + uue.getCause(), uue);
                }
            }
            JMSException ex = new JMSException("UnusableEntryException : ");
            ex.setLinkedException((Exception)((Object)uue));
            throw ex;
        }
    }

    public String toString() {
        return "QueueBrowser for the session:" + this.m_session.toString();
    }

    public Queue getQueue() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed browser.");
        }
        return this.m_queue;
    }

    public String getMessageSelector() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed browser.");
        }
        return this.m_selector;
    }

    public Enumeration getEnumeration() throws JMSException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed browser.");
        }
        return new QueueEnumeration(this.gsIterator);
    }

    public void close() throws JMSException {
        try {
            if (!this.m_closed) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSQueueBrowserImpl.close() closing browser: " + this.toString());
                }
                this.m_session.removeBrower(this);
            }
            this.m_closed = true;
        }
        finally {
            if (null != this.gsIterator) {
                this.gsIterator.cancel();
                this.gsIterator = null;
            }
        }
    }

    private class QueueEnumeration
    implements Enumeration {
        private GSIterator iterator;

        private QueueEnumeration(GSIterator _gsIterator) {
            this.iterator = _gsIterator;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.iterator == null) {
                return false;
            }
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            if (this.iterator == null || !this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            Object o = this.iterator.next();
            GSMessageImpl msg = (GSMessageImpl)o;
            msg.setBodyReadOnly(true);
            msg.setPropertiesReadOnly(true);
            return o;
        }
    }
}

