/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.gigaspaces.internal.io.CompressedMarshObjectConvertor;
import com.gigaspaces.internal.io.MarshObject;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.client.EntryNotInSpaceException;
import com.j_spaces.jms.CommitFailedException;
import com.j_spaces.jms.GSBytesMessageImpl;
import com.j_spaces.jms.GSConnectionImpl;
import com.j_spaces.jms.GSMapMessageImpl;
import com.j_spaces.jms.GSMessageConsumerImpl;
import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSMessageProducerImpl;
import com.j_spaces.jms.GSObjectMessageImpl;
import com.j_spaces.jms.GSQueueBrowserImpl;
import com.j_spaces.jms.GSQueueImpl;
import com.j_spaces.jms.GSSimpleMessageImpl;
import com.j_spaces.jms.GSStreamMessageImpl;
import com.j_spaces.jms.GSTemporaryQueueImpl;
import com.j_spaces.jms.GSTemporaryTopicImpl;
import com.j_spaces.jms.GSTextMessageImpl;
import com.j_spaces.jms.GSTopicImpl;
import com.j_spaces.jms.JMSAckDataEntry;
import com.j_spaces.jms.MessageAcks;
import com.j_spaces.jms.RollbackFailedException;
import com.j_spaces.jms.TransactionCreateException;
import com.j_spaces.jms.utils.CyclicCounter;
import com.j_spaces.jms.utils.IMessageConverter;
import com.j_spaces.jms.utils.StringsUtils;
import com.j_spaces.kernel.pool.IResource;
import com.j_spaces.kernel.pool.ResourcePool;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionRolledBackException;
import javax.jms.XASession;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

public class GSSessionImpl
implements Session,
TopicSession,
QueueSession,
Runnable {
    String m_sessionID;
    IJSpace m_space = null;
    protected volatile boolean m_closed = false;
    protected volatile boolean m_closing = false;
    protected volatile boolean m_stopped = true;
    protected Map<String, GSMessageConsumerImpl> m_consumers;
    protected Vector<GSMessageProducerImpl> m_producers;
    protected Vector<GSQueueBrowserImpl> m_browsers;
    private GSConnectionImpl m_conn;
    final int m_acknowledgeMode;
    protected Transaction _tx = null;
    public static final long txLeaseTime = 36000000L;
    volatile CyclicCounter m_msgListeners = new CyclicCounter();
    private volatile CyclicCounter m_messagesC = new CyclicCounter();
    private volatile CyclicCounter m_producersC = new CyclicCounter();
    private volatile CyclicCounter m_consumersC = new CyclicCounter();
    volatile int m_numOfConsumedMsg = 0;
    volatile int m_numOfProducedMsg = 0;
    private static boolean useLocalTransactions;
    private static String txnType;
    Object stopMonitor = new Object();
    boolean onProcess = false;
    protected LinkedList<GSMessageImpl> sentMessages;
    protected LinkedList<MessageQueueElement> unackedMessages;
    private LinkedList<MessageQueueElement> recoverMessages;
    private Hashtable<String, MessageAcks> _deliveries;
    protected boolean m_isQueue = true;
    private static Random random;
    private static final Logger _logger;
    static final HashSet<String> reservedSelectorIdentifiers;
    static final Object[][] JMSX_CLIENT_NAMES;
    private String m_providerName;
    private ResourcePool<CompressedMarshObjectConvertor> _compressedConvertorPool = null;
    private int m_compressionMinSize;
    private final ReentrantLock closeLock = new ReentrantLock();

    public GSSessionImpl(GSConnectionImpl conn, boolean isTransacted, int acknowledgeMode) throws JMSException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "GSSessionImpl.GSSessionImpl()");
        }
        if (!isTransacted && acknowledgeMode != 1 && acknowledgeMode != 2 && acknowledgeMode != 3) {
            throw new JMSException("Can't create a non transacted session with an invalid acknowledge mode.");
        }
        this.m_space = conn.getSpace();
        this.m_sessionID = conn.nextSessionId();
        this.m_conn = conn;
        this.m_providerName = conn.getMetaData().getJMSProviderName();
        this._deliveries = new Hashtable();
        this.m_consumers = new HashMap<String, GSMessageConsumerImpl>();
        this.m_producers = new Vector();
        this.m_browsers = new Vector();
        this.recoverMessages = new LinkedList();
        this.unackedMessages = new LinkedList();
        if (!isTransacted) {
            this.m_acknowledgeMode = acknowledgeMode;
            if (this.m_acknowledgeMode == 2) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "GSSessionImpl.GSSessionImpl(): The session's acknowledge mode is CLIENT_ACKNOWLEDGE. The session will use " + txnType + " transactions: " + this.m_sessionID);
                }
                try {
                    this.renewTransaction();
                }
                catch (TransactionCreateException e) {
                    JMSException jmse = new JMSException(e.msg);
                    jmse.setLinkedException(e.orig);
                    throw jmse;
                }
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "GSSessionImpl.GSSessionImpl(): The session is not transacted: " + this.m_sessionID);
            }
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "GSSessionImpl.GSSessionImpl(): Session is transacted: " + this.m_sessionID);
            }
            this.m_acknowledgeMode = 0;
            this.sentMessages = new LinkedList();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "GSSessionImpl.GSSessionImpl(): The session is transacted  and it will use " + txnType + " transactions: " + this.m_sessionID);
            }
            try {
                this.renewTransaction();
            }
            catch (TransactionCreateException e) {
                JMSException jmse = new JMSException(e.msg);
                jmse.setLinkedException(e.orig);
                throw jmse;
            }
        }
        this.m_compressionMinSize = this.m_conn.getCompressionMinSize();
        this._compressedConvertorPool = new ResourcePool(CompressedMarshObjectConvertor.getFactory(), 0, 100);
        conn.addSession(this);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.GSSessionImpl() session: " + this.getClass().getName() + " |\t" + this.toString() + " |\tspace: " + this.m_space);
        }
    }

    public String getJMSProviderName() {
        return this.m_providerName;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.createBytesMessage(null);
    }

    public BytesMessage createBytesMessage(byte[] bytesArrayBody) throws JMSException {
        this.ensureOpen();
        GSBytesMessageImpl bytesMsg = new GSBytesMessageImpl(this, bytesArrayBody);
        return bytesMsg;
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.createMapMessage(new HashMap<String, Object>());
    }

    MapMessage createMapMessage(HashMap<String, Object> map) throws JMSException {
        this.ensureOpen();
        GSMapMessageImpl mapMsg = new GSMapMessageImpl(this, map);
        return mapMsg;
    }

    public Message createMessage() throws JMSException {
        this.ensureOpen();
        return new GSSimpleMessageImpl(this);
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.ensureOpen();
        GSObjectMessageImpl objMsg = new GSObjectMessageImpl(this);
        return objMsg;
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.ensureOpen();
        GSObjectMessageImpl objMsg = new GSObjectMessageImpl(this, object);
        return objMsg;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.ensureOpen();
        GSStreamMessageImpl streamMsg = new GSStreamMessageImpl(this);
        return streamMsg;
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.createTextMessage(null);
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.ensureOpen();
        GSTextMessageImpl textMsg = new GSTextMessageImpl(this, text);
        return textMsg;
    }

    public boolean getTransacted() throws JMSException {
        this.ensureOpen();
        return this.m_acknowledgeMode == 0;
    }

    protected Transaction getTransaction() {
        return this._tx;
    }

    public int getAcknowledgeMode() throws IllegalStateException {
        return this.m_acknowledgeMode;
    }

    synchronized void handleSendMessage(GSMessageImpl message) throws RemoteException, TransactionException, JMSException {
        if (this.m_acknowledgeMode != 0) {
            this.doSend(message, null);
            if (this.m_space.isEmbedded()) {
                message.setProperties(message.cloneProperties());
            }
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSSessionImpl.sendMessage(): Adding message to sent messages list: " + message.JMSMessageID);
            }
            GSMessageImpl duplicate = message.duplicate();
            this.sentMessages.add(duplicate);
        }
    }

    synchronized boolean doSend(GSMessageImpl message, Transaction tx) throws RemoteException, TransactionException, JMSException {
        Object messageConverterProp;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("GSSessionImpl.doSend(): Sending message: Txn=" + tx + message);
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.doSend(): Sending message: Txn=" + tx + ", ID=" + message.JMSMessageID);
        }
        long ttl = message.getTTL();
        if (ttl != 0L) {
            long now = SystemTime.timeMillis();
            if ((ttl -= now - message.getJMSTimestamp()) <= 0L) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.warning("GSSessionImpl.doSend(): Message expired and won't be sent: " + message.getJMSMessageID());
                }
                return false;
            }
        } else {
            ttl = Long.MAX_VALUE;
        }
        if ((messageConverterProp = message.Properties.remove("JMS_GSMessageConverter")) != null && messageConverterProp instanceof IMessageConverter) {
            Object objToWrite;
            IMessageConverter messageConverter = (IMessageConverter)messageConverterProp;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSSessionImpl.doSend(): Converting JMS message " + message.JMSMessageID + " with MessageConverter: " + messageConverter.getClass().getName());
            }
            if ((objToWrite = messageConverter.toObject((Message)message)) == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSSessionImpl.doSend(): MessageConverter returned null for message " + message.JMSMessageID + ". Nothing is sent to the space.");
                }
                return false;
            }
            if (objToWrite instanceof Entry) {
                return this.writeEntry((Entry)objToWrite, tx, ttl);
            }
            if (objToWrite instanceof Entry[]) {
                try {
                    return this.writeEntries((Entry[])objToWrite, tx, ttl);
                }
                catch (IOException e) {
                    JMSException jmse = new JMSException("Failed to write entries");
                    jmse.setLinkedException((Exception)e);
                    throw jmse;
                }
            }
            return this.writeObject(objToWrite, tx, ttl);
        }
        return this.writeEntry((Entry)message, tx, ttl);
    }

    private boolean writeEntry(Entry entry, Transaction tx, long ttl) throws RemoteException, TransactionException {
        if (entry instanceof GSTextMessageImpl) {
            int lengthInBytes;
            GSTextMessageImpl txtMsg = (GSTextMessageImpl)entry;
            if (txtMsg.Body != null && (lengthInBytes = txtMsg.Body.toString().length() * 2) > this.m_compressionMinSize) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSSessionImpl.doSend(): Compressing message body. bytes=" + lengthInBytes);
                }
                this.doSendCompressMessage(txtMsg, tx, ttl);
                return true;
            }
        }
        this.m_space.write((Object)entry, tx, ttl);
        ++this.m_numOfProducedMsg;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeEntries(Entry[] entries, Transaction tx, long ttl) throws RemoteException, TransactionException, IOException {
        GSTextMessageImpl txtMsg = null;
        HashMap<GSTextMessageImpl, Object> contents = new HashMap<GSTextMessageImpl, Object>();
        if (entries.length == 0) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSSessionImpl.writeEntries(): MessageConverter returned a zero length Entry array. Nothing is sent to the space.");
            }
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.writeEntries(): Writing " + entries.length + " entries to the space. tx=" + tx + ", ttl=" + ttl);
        }
        try {
            for (int i = 0; i < entries.length; ++i) {
                int lengthInBytes;
                Entry entry = entries[i];
                if (!(entry instanceof GSTextMessageImpl)) continue;
                txtMsg = (GSTextMessageImpl)entry;
                if (txtMsg.Body == null || (lengthInBytes = txtMsg.Body.toString().length() * 2) <= this.m_compressionMinSize) continue;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSSessionImpl.writeEntries(): Compressing message body. bytes=" + lengthInBytes);
                }
                MarshObject compressedObject = this.compressObject(txtMsg.Body);
                contents.put(txtMsg, txtMsg.Body);
                txtMsg.Body = compressedObject;
            }
            this.m_space.writeMultiple((Object[])entries, tx, ttl);
            this.m_numOfProducedMsg += entries.length;
        }
        catch (IOException e) {
            if (_logger.isLoggable(Level.SEVERE) && txtMsg != null) {
                _logger.severe("GSSessionImpl.writeEntries(): IOException while compressing message body: " + txtMsg.Body);
            }
        }
        finally {
            if (contents.size() > 0) {
                Iterator iter = contents.keySet().iterator();
                txtMsg = (GSTextMessageImpl)iter.next();
                txtMsg.Body = contents.get(txtMsg);
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean writeObject(Object obj, Transaction tx, long ttl) throws RemoteException, TransactionException {
        if (obj instanceof Object[]) {
            Object[] objects = (Object[])obj;
            if (objects.length <= 0) {
                if (!_logger.isLoggable(Level.FINE)) return false;
                _logger.fine("GSSessionImpl.writeObject(): MessageConverter returned a zero length array. Nothing is sent to the space.");
                return false;
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSSessionImpl.writeObject(): Writing " + objects.length + " objects to the space. tx=" + tx + ", ttl=" + ttl);
            }
            this.m_space.writeMultiple(objects, tx, ttl);
            this.m_numOfProducedMsg += objects.length;
            return true;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.writeObject(): Writing object: " + obj + ", tx=" + tx + ", ttl=" + ttl);
        }
        this.m_space.write(obj, tx, ttl);
        ++this.m_numOfProducedMsg;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendCompressMessage(GSTextMessageImpl message, Transaction tx, long ttl) throws RemoteException, TransactionException {
        Object messageBody;
        block6: {
            messageBody = message.Body;
            try {
                MarshObject compressedObject = this.compressObject(message.Body);
                message.Body = compressedObject;
            }
            catch (IOException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block6;
                _logger.severe("GSSessionImpl.doSend(): IOException while compressing message body. Sending uncompressed: " + message.Body);
            }
        }
        try {
            this.m_space.write((Object)message, tx, ttl);
            ++this.m_numOfProducedMsg;
        }
        finally {
            if (message.Body instanceof MarshObject) {
                message.Body = messageBody;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarshObject compressObject(Object objToCompress) throws IOException {
        CompressedMarshObjectConvertor cv = null;
        try {
            MarshObject cmo;
            cv = (CompressedMarshObjectConvertor)this._compressedConvertorPool.getResource();
            MarshObject marshObject = cmo = cv.getMarshObject(objToCompress);
            return marshObject;
        }
        finally {
            if (cv != null) {
                this._compressedConvertorPool.freeResource((IResource)cv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object decompressObject(MarshObject objToDecompress) throws IOException, ClassNotFoundException {
        CompressedMarshObjectConvertor cv = null;
        Object obj = null;
        try {
            cv = (CompressedMarshObjectConvertor)this._compressedConvertorPool.getResource();
            obj = cv.getObject(objToDecompress);
        }
        finally {
            if (cv != null) {
                this._compressedConvertorPool.freeResource((IResource)cv);
            }
        }
        return obj;
    }

    void prepareAck(String destName, String producerKey, String consumerKey, String ackedMessageID, boolean queueMode) {
        MessageAcks acks = this._deliveries.get(destName);
        if (acks == null) {
            acks = new MessageAcks(queueMode, destName);
            this._deliveries.put(destName, acks);
        }
        acks.addAck(producerKey, consumerKey, ackedMessageID, destName);
    }

    void acknowledge() throws CommitFailedException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSsessionImpl.acknowledge(): " + this.m_sessionID);
        }
        this.unackedMessages.clear();
        if (this.m_isQueue && !this.isAutoAck()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Acknowledging messages. Txn=" + this._tx);
            }
            this.commitLocalTransaction();
        }
    }

    public void commit() throws JMSException {
        this.ensureOpen();
        this.ensureTX();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.commit(): Committing JMS transaction: " + this._tx);
        }
        try {
            this.sendMessages(this.sentMessages, this._tx);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSSessionImpl.commit(): Committing local transaction: " + this._tx);
            }
            this.commitLocalTransaction();
            this.renewTransaction();
        }
        catch (JMSException mfE) {
            block25: {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "JMSException during GSSessionImpl.commit(): ", mfE);
                    _logger.log(Level.SEVERE, "Rolling back transaction: " + this._tx);
                }
                try {
                    this.rollback();
                }
                catch (JMSException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block25;
                    _logger.log(Level.SEVERE, "Failed to roll back transaction: " + this._tx, e);
                }
            }
            TransactionRolledBackException tE = new TransactionRolledBackException("JMSException during GSSessionImpl.commit()");
            tE.setLinkedException((Exception)((Object)mfE));
            throw tE;
        }
        catch (TransactionException te) {
            block26: {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "TransactionException during GSSessionImpl.commit(): ", te);
                    _logger.log(Level.SEVERE, "Rolling back transaction: " + this._tx);
                }
                try {
                    this.rollback();
                }
                catch (JMSException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block26;
                    _logger.log(Level.SEVERE, "Failed to roll back transaction: " + this._tx, e);
                }
            }
            TransactionRolledBackException e = new TransactionRolledBackException("TransactionException during GSSessionImpl.commit()");
            e.setLinkedException((Exception)((Object)te));
            throw e;
        }
        catch (RemoteException re) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "RemoteException during GSSessionImpl.commit(): ", re);
                _logger.log(Level.SEVERE, "Rolling back transaction: " + this._tx);
            }
            try {
                this.rollback();
            }
            catch (JMSException e) {
                // empty catch block
            }
            TransactionRolledBackException e = new TransactionRolledBackException("RemoteException during GSSessionImpl.commit()");
            e.setLinkedException((Exception)re);
            throw e;
        }
        catch (CommitFailedException cfe) {
            block27: {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Internal error during GSSessionImpl.commit(): ", cfe.orig);
                    _logger.log(Level.SEVERE, "Rolling back transaction: " + this._tx);
                }
                try {
                    this.rollback();
                }
                catch (JMSException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block27;
                    _logger.log(Level.SEVERE, "Failed to roll back transaction: " + this._tx, e);
                }
            }
            TransactionRolledBackException e = new TransactionRolledBackException("Failed to commit transaction:" + this._tx + "\nThe transaction was rolled back.");
            e.setLinkedException(cfe.orig);
            throw e;
        }
        catch (TransactionCreateException tce) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to renew transaction after commit: ", tce.orig);
                _logger.log(Level.SEVERE, "Rolling back transaction: " + this._tx);
            }
            JMSException e = new JMSException("Failed to renew transaction after commit");
            e.setLinkedException(tce.orig);
            throw e;
        }
        finally {
            this.sentMessages.clear();
            this.unackedMessages.clear();
        }
    }

    boolean sendMessages(LinkedList<GSMessageImpl> messages, Transaction tx) throws RemoteException, TransactionException, JMSException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("GSSession.sendProducedMessages()");
        }
        boolean messagesSent = false;
        int size = messages.size();
        GSMessageImpl[] copy = new GSMessageImpl[size];
        Iterator iter = messages.iterator();
        for (int j = 0; j < size; ++j) {
            copy[j] = (GSMessageImpl)iter.next();
        }
        for (int i = 0; i < copy.length; ++i) {
            messagesSent |= this.doSend(copy[i], tx);
        }
        return messagesSent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws JMSException {
        this.ensureOpen();
        this.ensureTX();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.rollback(): Rolling back transaction: " + this._tx);
        }
        this.sentMessages.clear();
        try {
            this.recoverMessages();
        }
        catch (RollbackFailedException e) {
            try {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.fine("GSSessionImpl.rollback(): Failed to roll back transaction: " + this._tx);
                }
                JMSException je = new JMSException("Failed to roll back transaction: " + this._tx);
                je.setLinkedException(e.orig);
                throw je;
            }
            catch (Throwable throwable) {
                try {
                    this.renewTransaction();
                    throw throwable;
                }
                catch (TransactionCreateException e2) {
                    JMSException jmse = new JMSException(e2.msg);
                    jmse.setLinkedException(e2.orig);
                    throw jmse;
                }
            }
        }
        try {
            this.renewTransaction();
            return;
        }
        catch (TransactionCreateException e) {
            JMSException jmse = new JMSException(e.msg);
            jmse.setLinkedException(e.orig);
            throw jmse;
        }
    }

    void renewTransaction() throws TransactionCreateException {
        if (this.m_conn == null || this.m_closing) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSSessionImpl.renewTransaction(): The Session is closed. Not renewing transaction.");
            }
            this._tx = null;
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.renewTransaction(): Renewing transaction.");
        }
        try {
            this._tx = this.m_conn.getTransaction(useLocalTransactions, 36000000L);
        }
        catch (TransactionCreateException re) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "GSSessionImpl.renewTransaction(): Failed to renew transaction: ", re.orig);
            }
            this._tx = null;
            throw re;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.renewTransaction(): New transaction: " + this._tx);
        }
    }

    boolean cancel(Transaction tx) throws IllegalStateException {
        return false;
    }

    boolean isAutoAck() {
        return this.m_acknowledgeMode == 1 || this.m_acknowledgeMode == 3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recover() throws JMSException {
        block24: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "GSSessionImpl.recover()");
            }
            if (this.getTransacted()) {
                throw new IllegalStateException("Forbidden call for recover on a transacted session.");
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "GSSessionImpl.recover(): Stopping session");
            }
            this.stop();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "GSSessionImpl.recover(): Session stopped");
            }
            try {
                this.recoverMessages();
                if (!this.m_isQueue || this.isAutoAck()) break block24;
            }
            catch (RollbackFailedException e) {
                try {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.fine("GSSessionImpl.recover(): Failed to roll back transaction: " + this._tx);
                    }
                    JMSException je = new JMSException("Failed to roll back transaction: " + this._tx);
                    je.setLinkedException(e.orig);
                    throw je;
                }
                catch (Throwable throwable) {
                    if (this.m_isQueue && !this.isAutoAck()) {
                        try {
                            this.renewTransaction();
                            throw throwable;
                        }
                        catch (TransactionCreateException e2) {
                            JMSException jmse = new JMSException(e2.msg);
                            jmse.setLinkedException(e2.orig);
                            throw jmse;
                        }
                        finally {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.log(Level.FINE, "GSSessionImpl.recover(): Restarting session");
                            }
                            this.start();
                        }
                    }
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "GSSessionImpl.recover(): Restarting session");
                    }
                    this.start();
                    throw throwable;
                }
            }
            try {
                this.renewTransaction();
                return;
            }
            catch (TransactionCreateException e) {
                JMSException jmse = new JMSException(e.msg);
                jmse.setLinkedException(e.orig);
                throw jmse;
            }
            finally {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "GSSessionImpl.recover(): Restarting session");
                }
                this.start();
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "GSSessionImpl.recover(): Restarting session");
        }
        this.start();
    }

    void recoverMessages() throws RollbackFailedException {
        if (this.m_isQueue) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "GSSessionImpl.recoverMessages(): Recovering messages of Queue");
            }
            this.unackedMessages.clear();
            if (!this.isAutoAck()) {
                this.rollbackLocalTransaction();
            }
        } else {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "GSSessionImpl.recoverMessages(): Recovering messages of Topic");
            }
            this.unackedMessages.addAll(this.recoverMessages);
            LinkedList<MessageQueueElement> temp = this.unackedMessages;
            this.recoverMessages.clear();
            this.unackedMessages = this.recoverMessages;
            this.recoverMessages = temp;
        }
    }

    boolean isRecovering() {
        return this.recoverMessages.size() > 0;
    }

    GSMessageImpl getNextRecoveredMessage() {
        if (this.recoverMessages.size() == 0) {
            return null;
        }
        return this.recoverMessages.remove(0).getMessage();
    }

    void addUnackedMessage(GSMessageImpl message, String consumerID) throws JMSException {
        if (!this.m_isQueue) {
            message = message.duplicate();
        }
        this.unackedMessages.add(new MessageQueueElement(consumerID, message));
    }

    private void commitLocalTransaction() throws CommitFailedException {
        if (this._tx == null) {
            return;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Committing local transaction: " + this._tx);
        }
        try {
            this._tx.commit();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to commit local transaction: " + this._tx, e);
            }
            throw new CommitFailedException(e);
        }
    }

    void rollbackLocalTransaction() throws RollbackFailedException {
        if (this._tx == null) {
            return;
        }
        try {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Aborting local transaction: " + this._tx);
            }
            this._tx.abort();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Internal error during local transaction abort: " + this._tx, e);
            }
            throw new RollbackFailedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() throws JMSException {
        this.ensureOpen();
        if (this.m_stopped) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.stop(): Stopping the session: " + this.toString());
        }
        Object object = this.stopMonitor;
        synchronized (object) {
            block11: {
                this.m_stopped = true;
                if (this.onProcess) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Waiting for the consumers to stop: " + this.toString());
                    }
                    try {
                        Iterator<GSMessageConsumerImpl> consumers = this.m_consumers.values().iterator();
                        while (consumers.hasNext()) {
                            consumers.next().notifyStop();
                        }
                        this.stopMonitor.wait();
                    }
                    catch (InterruptedException e) {
                        if (!_logger.isLoggable(Level.SEVERE)) break block11;
                        _logger.severe("GSSessionImpl.stop(): InterruptedException during wait: " + e);
                    }
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.stop(): The session is stopped: " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() throws JMSException {
        this.ensureOpen();
        if (!this.m_stopped) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.start(): Starting the session: " + this.toString());
        }
        this.m_stopped = false;
        Object object = this.stopMonitor;
        synchronized (object) {
            this.stopMonitor.notifyAll();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.start()  session was started: " + this.toString());
        }
    }

    public void close() throws JMSException {
        block16: {
            this.closeLock.lock();
            try {
                block17: {
                    if (this.m_closed) break block16;
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("GSSession.close(): Closing the session: " + this.toString());
                    }
                    this.m_closing = true;
                    this.stop();
                    if (!(this instanceof XASession) && this.getTransacted()) {
                        this.rollback();
                    } else {
                        try {
                            this.rollbackLocalTransaction();
                        }
                        catch (RollbackFailedException e) {
                            if (!_logger.isLoggable(Level.SEVERE)) break block17;
                            _logger.severe("Failed to rollback transaction during session.close(): " + e.orig);
                        }
                    }
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Closing the session's resources: " + this.toString());
                }
                for (GSMessageConsumerImpl consumer : this.m_consumers.values()) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Closing consumer: " + consumer.toString());
                    }
                    consumer.close();
                }
                while (!this.m_browsers.isEmpty()) {
                    GSQueueBrowserImpl browser = this.m_browsers.get(0);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Closing queue browser: " + browser.toString());
                    }
                    browser.close();
                }
                while (!this.m_producers.isEmpty()) {
                    GSMessageProducerImpl producer = this.m_producers.get(0);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Closing producer: " + producer.toString());
                    }
                    producer.close();
                }
                this.m_conn.removeSession(this);
                this.m_closed = true;
                this.m_closing = false;
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("GSSession.close() session was closed: " + this.toString());
                }
            }
            finally {
                this.closeLock.unlock();
            }
        }
    }

    void ensureOpen() throws IllegalStateException {
        if (this.m_closed) {
            throw new IllegalStateException("Forbidden call on a closed session.");
        }
    }

    protected void ensureTX() throws IllegalStateException {
        if (this.m_acknowledgeMode != 0) {
            throw new IllegalStateException("Forbidden call on a non transacted session.");
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        this.ensureOpen();
        throw new JMSException("Forbidden call to GSSessionImpl.getMessageListener(). You should Call its subclass");
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.ensureOpen();
        throw new JMSException("Forbidden call to GSSessionImpl.setMessageListener(). You should Call its subclass");
    }

    @Override
    public void run() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSSessionImpl.run() method is not implemented. ");
        }
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.ensureOpen();
        if (destination == null || destination instanceof Queue || destination instanceof Topic) {
            return this.createGenericProducer(destination);
        }
        throw new InvalidDestinationException("The destination type is not recognized: " + destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageProducer createGenericProducer(Destination dest) throws JMSException {
        GSMessageProducerImpl producer;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Creating publisher for destination: " + dest);
        }
        GSSessionImpl gSSessionImpl = this;
        synchronized (gSSessionImpl) {
            String destName = "";
            if (dest != null) {
                destName = dest.toString();
            }
            if (this.getConn() != null) {
                String clientID = this.getConn().getClientID();
                this.getConn().updateClientIDInternally(clientID + ":" + destName);
            }
            IMessageConverter messageConverter = this.m_conn.connFacParent.getMessageConverter();
            producer = new GSMessageProducerImpl(this, dest, messageConverter);
            producer.setProducerID(this.nextProducerId());
            this.addProducer(producer);
        }
        return producer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        GSMessageConsumerImpl consumer;
        this.ensureOpen();
        if (destination == null) {
            throw new InvalidDestinationException("Invalid destination: null");
        }
        if (!(destination instanceof Queue) && !(destination instanceof Topic)) {
            throw new InvalidDestinationException("The destination type is not recognized: " + destination);
        }
        if (this.m_consumers.size() > 0) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.severe("GSSession.addConsumer(): Sessions support only one consumer: " + this.toString());
            }
            throw new JMSException("Sessions support only one consumer.");
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Creating MessageConsumer: dest=" + destination + ", selector=" + messageSelector + ", noLocal=" + noLocal);
        }
        GSSessionImpl gSSessionImpl = this;
        synchronized (gSSessionImpl) {
            String queueName = "";
            if (destination != null) {
                queueName = destination.toString();
            }
            if (this.getConn() != null) {
                String clientID = this.getConn().getClientID();
                if (clientID.indexOf(":") != -1) {
                    this.getConn().updateClientIDInternally(clientID.substring(0, clientID.indexOf(":")) + ":" + queueName);
                } else {
                    this.getConn().updateClientIDInternally(clientID + ":" + queueName);
                }
            }
            consumer = new GSMessageConsumerImpl(this, destination, this.nextConsumerId(), null, messageSelector, noLocal);
            this.addConsumer(consumer);
        }
        this.m_isQueue = destination instanceof Queue;
        if (this.m_isQueue && !this.isAutoAck() && this._tx == null) {
            try {
                this.renewTransaction();
            }
            catch (TransactionCreateException e) {
                JMSException jmse = new JMSException(e.msg);
                jmse.setLinkedException(e.orig);
                throw jmse;
            }
        }
        return consumer;
    }

    public String getSessionID() {
        return this.m_sessionID;
    }

    public void setSessionID(String string) {
        this.m_sessionID = string;
    }

    void removeJMSAckDataEntryFromSpace(JMSAckDataEntry ackDataEntry) throws JMSException {
        try {
            this.m_space.clear((Object)ackDataEntry, null);
        }
        catch (EntryAlreadyInSpaceException entryInSpaceException) {
            JMSException e = new JMSException("EntryAlreadyInSpaceException in GSSessionImpl.removeJMSAckDataEntryFromSpace()");
            e.setLinkedException((Exception)((Object)entryInSpaceException));
            throw e;
        }
        catch (TransactionException te) {
            JMSException e = new JMSException("TransactionException in GSSessionImpl.removeJMSAckDataEntryFromSpace()");
            e.setLinkedException((Exception)((Object)te));
            throw e;
        }
        catch (UnusableEntryException uue) {
            if (uue instanceof EntryNotInSpaceException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "GSSessionImpl.removeJMSAckDataEntryFromSpace(): The Entry " + ((EntryNotInSpaceException)uue).getUID() + " No Longer In Space " + uue.getCause(), uue);
                }
            }
            JMSException ex = new JMSException("UnusableEntryException : ");
            ex.setLinkedException((Exception)((Object)uue));
            throw ex;
        }
        catch (RemoteException re) {
            JMSException e = new JMSException("RemoteException in GSSessionImpl.removeJMSAckDataEntryFromSpace()" + re.toString());
            e.setLinkedException((Exception)re);
            throw e;
        }
    }

    boolean isLocalProducer(String prodKey) {
        if (this.m_producers != null) {
            int prodKeyHashCode = prodKey.hashCode();
            for (int i = 0; i < this.m_producers.size(); ++i) {
                GSMessageProducerImpl messageProducer = this.m_producers.get(i);
                if (messageProducer == null) continue;
                return messageProducer.getProducerID().hashCode() == prodKeyHashCode;
            }
        }
        return false;
    }

    boolean isLocalConsumer(String consKey) {
        return this.m_consumers.containsKey(consKey);
    }

    String nextConsumerId() {
        return this.m_sessionID + "_cons_" + this.m_consumersC.increment();
    }

    String nextProducerId() {
        return this.m_sessionID + "_prod_" + this.m_producersC.increment();
    }

    int nextMessageNum() {
        return this.m_messagesC.increment();
    }

    protected int getRandomInt() {
        return random.nextInt(Integer.MAX_VALUE);
    }

    public int getConsumersC() {
        return this.m_consumersC.getValue();
    }

    public int getMessagesC() {
        return this.m_messagesC.getValue();
    }

    public int getProducersC() {
        return this.m_producersC.getValue();
    }

    public void setConsumersC(int i) {
        this.m_consumersC.setValue(i);
    }

    public void setMessagesC(int i) {
        this.m_messagesC.setValue(i);
    }

    public void setProducersC(int i) {
        this.m_producersC.setValue(i);
    }

    public String toString() {
        return "GSSessionImpl || session ID: " + this.m_sessionID;
    }

    public int getNumOfConsumedMsg() {
        return this.m_numOfConsumedMsg;
    }

    public int getNumOfProducedMsg() {
        return this.m_numOfProducedMsg;
    }

    protected void addConsumer(GSMessageConsumerImpl consumer) {
        this.m_consumers.put(consumer.getConsumerID(), consumer);
    }

    protected void removeConsumer(GSMessageConsumerImpl consumer) {
        this.m_consumers.remove(consumer.getConsumerID());
    }

    protected void addProducer(GSMessageProducerImpl producer) {
        this.m_producers.addElement(producer);
    }

    protected void removeProducer(GSMessageProducerImpl producer) {
        this.m_producers.remove(producer);
    }

    protected final boolean isClosed() {
        return this.m_closed;
    }

    protected GSConnectionImpl getConn() {
        return this.m_conn;
    }

    void startTransaction(Transaction transaction, boolean resume) {
    }

    public void unsubscribe(String subscriptionName) throws JMSException {
        this.ensureOpen();
        throw new JMSException("This version of JMS does not support durable subscribers.");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.ensureOpen();
        throw new JMSException("This version of JMS does not support durable subscribers.");
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.ensureOpen();
        throw new JMSException("This version of JMS does not support durable subscribers.");
    }

    public synchronized TemporaryTopic createTemporaryTopic() throws JMSException {
        this.ensureOpen();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating temporary Topic");
        }
        return new GSTemporaryTopicImpl(this.m_sessionID + ":" + this.getRandomInt(), this.m_sessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic createTopic(String topicName) throws JMSException {
        GSTopicImpl topic;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "GSTopicSessionImpl.createTopic(String)");
        }
        GSSessionImpl gSSessionImpl = this;
        synchronized (gSSessionImpl) {
            this.ensureOpen();
            if (StringsUtils.isEmpty(topicName)) {
                throw new JMSException("Invalid or null topic name specified");
            }
            topic = new GSTopicImpl(topicName);
        }
        return topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue createQueue(String queueName) throws JMSException {
        GSQueueImpl queue;
        GSSessionImpl gSSessionImpl = this;
        synchronized (gSSessionImpl) {
            this.ensureOpen();
            if (StringsUtils.isEmpty(queueName)) {
                throw new JMSException("Invalid or null queue name specified");
            }
            queue = new GSQueueImpl(queueName);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        GSQueueBrowserImpl browser;
        GSSessionImpl gSSessionImpl = this;
        synchronized (gSSessionImpl) {
            this.ensureOpen();
            if (queue == null) {
                throw new InvalidDestinationException("Cannot browse a null queue.");
            }
            browser = new GSQueueBrowserImpl(this, queue, null);
            this.addBrowser(browser);
        }
        return browser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        GSQueueBrowserImpl browser;
        GSSessionImpl gSSessionImpl = this;
        synchronized (gSSessionImpl) {
            this.ensureOpen();
            if (queue == null) {
                throw new InvalidDestinationException("Cannot browse a null queue.");
            }
            browser = new GSQueueBrowserImpl(this, queue, messageSelector);
            this.addBrowser(browser);
        }
        return browser;
    }

    protected void addBrowser(GSQueueBrowserImpl browser) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "GSQueueSessionImpl.addBrowser(GSQueueBrowserImpl)");
        }
        if (this.m_browsers == null) {
            this.m_browsers = new Vector();
        }
        this.m_browsers.addElement(browser);
    }

    protected void removeBrower(GSQueueBrowserImpl browser) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "GSQueueSessionImpl.removeBrower(GSQueueBrowserImpl)");
        }
        this.m_browsers.remove(browser);
        browser = null;
    }

    public synchronized TemporaryQueue createTemporaryQueue() throws JMSException {
        this.ensureOpen();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Creating temporary Queue");
        }
        return new GSTemporaryQueueImpl(this.m_sessionID + ":" + this.getRandomInt(), this.m_sessionID);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return (TopicPublisher)this.createProducer((Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        return (TopicSubscriber)this.createConsumer((Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        return (TopicSubscriber)this.createConsumer((Destination)topic, messageSelector, noLocal);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return (QueueReceiver)this.createConsumer((Destination)queue, messageSelector);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return (QueueSender)this.createProducer((Destination)queue);
    }

    static {
        random = new Random();
        _logger = Logger.getLogger("com.gigaspaces.jms");
        reservedSelectorIdentifiers = new HashSet();
        reservedSelectorIdentifiers.add("NULL");
        reservedSelectorIdentifiers.add("TRUE");
        reservedSelectorIdentifiers.add("FALSE");
        reservedSelectorIdentifiers.add("NOT");
        reservedSelectorIdentifiers.add("AND");
        reservedSelectorIdentifiers.add("OR");
        reservedSelectorIdentifiers.add("BETWEEN");
        reservedSelectorIdentifiers.add("LIKE");
        reservedSelectorIdentifiers.add("IN");
        reservedSelectorIdentifiers.add("IS");
        reservedSelectorIdentifiers.add("ESCAPE");
        useLocalTransactions = !Boolean.getBoolean("com.gs.jms.use_mahalo");
        txnType = useLocalTransactions ? "Local" : "Mahalo";
        reservedSelectorIdentifiers.add("JMSReplyTo");
        reservedSelectorIdentifiers.add("JMSDestination");
        JMSX_CLIENT_NAMES = new Object[][]{{"JMSXGroupID", String.class}, {"JMSXGroupSeq", Integer.class}};
    }

    class MessageQueueElement {
        private String consumerId;
        private GSMessageImpl message;

        public MessageQueueElement(String consumerId, GSMessageImpl message) {
            this.consumerId = consumerId;
            this.message = message;
        }

        public String getConsumerId() {
            return this.consumerId;
        }

        public GSMessageImpl getMessage() {
            return this.message;
        }
    }
}

