/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.jms.GSMessageImpl;
import com.j_spaces.jms.GSSessionImpl;
import com.j_spaces.jms.utils.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import javax.jms.StreamMessage;

public class GSStreamMessageImpl
extends GSMessageImpl
implements StreamMessage {
    private static final long serialVersionUID = 1L;
    private ByteArrayOutputStream bytesOut;
    private DataOutputStream dataOut;
    private DataInputStream dataIn;
    private int bytesToRead = -1;
    static final byte _EOF = 2;
    static final byte _BYTES = 3;
    static final byte _STRING = 4;
    static final byte _BOOLEAN = 5;
    static final byte _CHAR = 6;
    static final byte _BYTE = 7;
    static final byte _SHORT = 8;
    static final byte _INT = 9;
    static final byte _LONG = 10;
    static final byte _FLOAT = 11;
    static final byte _DOUBLE = 12;
    static final byte _NULL = 13;

    public GSStreamMessageImpl() throws JMSException {
        this(null);
    }

    GSStreamMessageImpl(GSSessionImpl session) throws JMSException {
        super(session, "Stream");
    }

    public boolean readBoolean() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(10);
            int type = this.dataIn.read();
            if (type == 5) {
                return this.dataIn.readBoolean();
            }
            if (type == 4) {
                return Boolean.valueOf(this.dataIn.readUTF());
            }
            if (type == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to boolean.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a boolean type");
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public byte readByte() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(10);
            int type = this.dataIn.read();
            if (type == 7) {
                return this.dataIn.readByte();
            }
            if (type == 4) {
                return Byte.valueOf(this.dataIn.readUTF());
            }
            if (type == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to byte.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a byte type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed");
                jmsEx.setLinkedException((Exception)ioe);
            }
            throw mfe;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public short readShort() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(17);
            int type = this.dataIn.read();
            if (type == 8) {
                return this.dataIn.readShort();
            }
            if (type == 7) {
                return this.dataIn.readByte();
            }
            if (type == 4) {
                return Short.valueOf(this.dataIn.readUTF());
            }
            if (type == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to short.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a short type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed");
                jmsEx.setLinkedException((Exception)ioe);
            }
            throw mfe;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public char readChar() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(17);
            int type = this.dataIn.read();
            if (type == 6) {
                return this.dataIn.readChar();
            }
            if (type == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to char.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a char type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed");
                jmsEx.setLinkedException((Exception)ioe);
            }
            throw mfe;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public int readInt() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(33);
            int type = this.dataIn.read();
            if (type == 9) {
                return this.dataIn.readInt();
            }
            if (type == 8) {
                return this.dataIn.readShort();
            }
            if (type == 7) {
                return this.dataIn.readByte();
            }
            if (type == 4) {
                return Integer.valueOf(this.dataIn.readUTF());
            }
            if (type == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to int.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not an int type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed");
                jmsEx.setLinkedException((Exception)ioe);
            }
            throw mfe;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public long readLong() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(65);
            int type = this.dataIn.read();
            if (type == 10) {
                return this.dataIn.readLong();
            }
            if (type == 9) {
                return this.dataIn.readInt();
            }
            if (type == 8) {
                return this.dataIn.readShort();
            }
            if (type == 7) {
                return this.dataIn.readByte();
            }
            if (type == 4) {
                return Long.valueOf(this.dataIn.readUTF());
            }
            if (type == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to long.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a long type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed");
                jmsEx.setLinkedException((Exception)ioe);
            }
            throw mfe;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public float readFloat() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(33);
            int type = this.dataIn.read();
            if (type == 11) {
                return this.dataIn.readFloat();
            }
            if (type == 4) {
                return Float.valueOf(this.dataIn.readUTF()).floatValue();
            }
            if (type == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to float.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a float type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed");
                jmsEx.setLinkedException((Exception)ioe);
            }
            throw mfe;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public double readDouble() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(65);
            int type = this.dataIn.read();
            if (type == 12) {
                return this.dataIn.readDouble();
            }
            if (type == 11) {
                return this.dataIn.readFloat();
            }
            if (type == 4) {
                return Double.valueOf(this.dataIn.readUTF());
            }
            if (type == 13) {
                this.dataIn.reset();
                throw new NullPointerException("Cannot convert _NULL value to double.");
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a double type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed");
                jmsEx.setLinkedException((Exception)ioe);
            }
            throw mfe;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public String readString() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(65);
            int type = this.dataIn.read();
            if (type == 13) {
                return null;
            }
            if (type == 4) {
                return this.dataIn.readUTF();
            }
            if (type == 10) {
                return Long.toString(this.dataIn.readLong());
            }
            if (type == 9) {
                return Integer.toString(this.dataIn.readInt());
            }
            if (type == 8) {
                return Short.toString(this.dataIn.readShort());
            }
            if (type == 7) {
                return Byte.toString(this.dataIn.readByte());
            }
            if (type == 11) {
                return Float.toString(this.dataIn.readFloat());
            }
            if (type == 12) {
                return Double.toString(this.dataIn.readDouble());
            }
            if (type == 5) {
                return Boolean.toString(this.dataIn.readBoolean());
            }
            if (type == 6) {
                return Character.toString(this.dataIn.readChar());
            }
            this.dataIn.reset();
            throw new MessageFormatException(" not a String type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed");
                jmsEx.setLinkedException((Exception)ioe);
            }
            throw mfe;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.initializeReading();
        try {
            if (value == null) {
                throw new NullPointerException();
            }
            if (this.bytesToRead == 0) {
                this.bytesToRead = -1;
                return -1;
            }
            if (this.bytesToRead > 0) {
                if (value.length >= this.bytesToRead) {
                    this.bytesToRead = 0;
                    return this.dataIn.read(value, 0, this.bytesToRead);
                }
                this.bytesToRead -= value.length;
                return this.dataIn.read(value);
            }
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            if (this.dataIn.available() < 1) {
                throw new MessageFormatException("Not enough data left to read value");
            }
            this.dataIn.mark(value.length + 1);
            int type = this.dataIn.read();
            if (this.dataIn.available() < 1) {
                return -1;
            }
            if (type != 3) {
                throw new MessageFormatException("Not a byte array");
            }
            int len = this.dataIn.readInt();
            if (len >= value.length) {
                this.bytesToRead = len - value.length;
                return this.dataIn.read(value);
            }
            this.bytesToRead = 0;
            return this.dataIn.read(value, 0, len);
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public Object readObject() throws JMSException {
        this.initializeReading();
        try {
            if (this.dataIn.available() == 0) {
                throw new MessageEOFException("reached end of data");
            }
            this.dataIn.mark(65);
            int type = this.dataIn.read();
            if (type == 13) {
                return null;
            }
            if (type == 4) {
                return this.dataIn.readUTF();
            }
            if (type == 10) {
                return this.dataIn.readLong();
            }
            if (type == 9) {
                return this.dataIn.readInt();
            }
            if (type == 8) {
                return this.dataIn.readShort();
            }
            if (type == 7) {
                return this.dataIn.readByte();
            }
            if (type == 11) {
                return Float.valueOf(this.dataIn.readFloat());
            }
            if (type == 12) {
                return this.dataIn.readDouble();
            }
            if (type == 5) {
                return this.dataIn.readBoolean();
            }
            if (type == 6) {
                return new Character(this.dataIn.readChar());
            }
            if (type == 3) {
                int len = this.dataIn.readInt();
                byte[] value = new byte[len];
                this.dataIn.read(value);
                return value;
            }
            this.dataIn.reset();
            throw new MessageFormatException("unknown type");
        }
        catch (NumberFormatException mfe) {
            try {
                this.dataIn.reset();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed");
                jmsEx.setLinkedException((Exception)ioe);
            }
            throw mfe;
        }
        catch (EOFException e) {
            MessageEOFException jmsEx = new MessageEOFException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (IOException e) {
            MessageFormatException jmsEx = new MessageFormatException(e.toString());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(5);
            this.dataOut.writeBoolean(value);
        }
        catch (IOException ioe) {
            this.raise(ioe);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(7);
            this.dataOut.writeByte(value);
        }
        catch (IOException ioe) {
            this.raise(ioe);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(8);
            this.dataOut.writeShort(value);
        }
        catch (IOException ioe) {
            this.raise(ioe);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(6);
            this.dataOut.writeChar(value);
        }
        catch (IOException ioe) {
            this.raise(ioe);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(9);
            this.dataOut.writeInt(value);
        }
        catch (IOException ioe) {
            this.raise(ioe);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(10);
            this.dataOut.writeLong(value);
        }
        catch (IOException ioe) {
            this.raise(ioe);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(11);
            this.dataOut.writeFloat(value);
        }
        catch (IOException ioe) {
            this.raise(ioe);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(12);
            this.dataOut.writeDouble(value);
        }
        catch (IOException ioe) {
            this.raise(ioe);
        }
    }

    public void writeString(String value) throws JMSException {
        this.initializeWriting();
        try {
            if (value == null) {
                this.dataOut.write(13);
            } else {
                this.dataOut.write(4);
                this.dataOut.writeUTF(value);
            }
        }
        catch (IOException ioe) {
            this.raise(ioe);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writeBytes(value, 0, value.length);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.initializeWriting();
        try {
            this.dataOut.write(3);
            this.dataOut.writeInt(length);
            this.dataOut.write(value, offset, length);
        }
        catch (IOException ioe) {
            this.raise(ioe);
        }
    }

    public void writeObject(Object value) throws JMSException {
        this.initializeWriting();
        if (value == null) {
            try {
                this.dataOut.write(13);
            }
            catch (IOException ioe) {
                this.raise(ioe);
            }
        } else if (value instanceof String) {
            this.writeString(value.toString());
        } else if (value instanceof Character) {
            this.writeChar(((Character)value).charValue());
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        }
    }

    public void setBodyAsBytes(byte[] bodyAsBytes, int offset, int length) {
        this.Body = new ByteArray(bodyAsBytes);
        this.dataOut = null;
        this.dataIn = null;
    }

    public ByteArray getBodyAsBytes() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.flush();
            byte[] data = this.bytesOut.toByteArray();
            this.Body = new ByteArray(data);
            this.dataOut.close();
            this.dataOut = null;
        }
        if (this.Body == null) {
            this.Body = new ByteArray();
        }
        return (ByteArray)this.Body;
    }

    public void reset() throws JMSException {
        this.setBodyReadOnly(true);
        if (this.dataOut != null) {
            try {
                this.dataOut.flush();
                byte[] data = this.bytesOut.toByteArray();
                this.Body = new ByteArray(data);
                this.dataOut.close();
            }
            catch (IOException ioe) {
                JMSException jmsEx = new JMSException("reset failed: " + ioe.toString());
                jmsEx.setLinkedException((Exception)ioe);
                throw jmsEx;
            }
        }
        this.bytesOut = null;
        this.dataIn = null;
        this.dataOut = null;
    }

    private void initializeWriting() throws MessageNotWriteableException {
        this.checkBodyReadOnly();
        if (this.dataOut == null) {
            this.bytesOut = new ByteArrayOutputStream();
            this.dataOut = new DataOutputStream(this.bytesOut);
        }
    }

    private void initializeReading() throws MessageNotReadableException {
        ByteArray data;
        this.checkBodyWriteOnly();
        if (this.Body == null) {
            data = new ByteArray();
            this.Body = data;
        } else {
            data = (ByteArray)this.Body;
        }
        if (this.dataIn == null && data != null) {
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(data.getBuf(), data.getOffset(), data.getLength());
            this.dataIn = new DataInputStream(bytesIn);
        }
    }

    private final void raise(IOException exception) throws JMSException {
        JMSException error = new JMSException(exception.toString());
        error.setLinkedException((Exception)exception);
        throw error;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.dataOut = null;
        this.dataIn = null;
        this.bytesOut = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\n\n\tStreamMessage:");
        sb.append("\n\t\tbytesOut:\t\t");
        sb.append(this.bytesOut);
        sb.append("\n\t\tdataIn:\t\t\t");
        sb.append(this.dataIn);
        sb.append("\n\t\tbytesToRead:\t\t");
        sb.append(this.bytesToRead);
        sb.append("\n\t\tdataOut:\t\t");
        sb.append(this.dataOut);
        return sb.toString();
    }
}

