/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.j_spaces.core.IJSpace;
import com.j_spaces.jms.GSConnectionFactoryImpl;
import com.j_spaces.jms.GSXAConnectionImpl;
import com.j_spaces.jms.utils.IMessageConverter;
import java.util.logging.Level;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;

public class GSXAConnectionFactoryImpl
extends GSConnectionFactoryImpl
implements XAConnectionFactory,
XAQueueConnectionFactory,
XATopicConnectionFactory {
    private static final long serialVersionUID = 1L;

    public GSXAConnectionFactoryImpl() {
    }

    public GSXAConnectionFactoryImpl(IJSpace space, IMessageConverter messageConverter) throws JMSException {
        super(space, messageConverter);
    }

    public XAConnection createXAConnection() throws JMSException {
        return this.createGSXAConnection("xac");
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        return this.createGSXAConnection("xac", userName, password);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return this.createGSXAConnection("xaqc");
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        return this.createGSXAConnection("xaqc", userName, password);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return this.createGSXAConnection("xatc");
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        return this.createGSXAConnection("xatc", userName, password);
    }

    private GSXAConnectionImpl createGSXAConnection(String prefix) throws JMSException {
        GSXAConnectionImpl conn = new GSXAConnectionImpl(this);
        String connKey = this.nextCnxKey();
        conn.setCnxKey(connKey);
        conn.updateClientIDInternally(connKey + "_" + this.getSpaceName());
        this.addConnection(conn);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSConnectionFactoryImpl.createGSConnection() connKey: " + connKey);
        }
        return conn;
    }

    private GSXAConnectionImpl createGSXAConnection(String prefix, String userName, String password) throws JMSException {
        this.setSpaceSecurityContext(userName, password);
        return this.createGSXAConnection(prefix);
    }
}

