/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.gigaspaces.internal.server.space.SpaceConfigReader;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.IJSpace;
import com.j_spaces.jms.GSJmsFactory;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;

public class GsJmsLookupManager
implements Closeable {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.lookupmanager");
    private final String spaceName;
    private final IJSpace spaceProxy;
    private final GSJmsFactory jmsFactory;
    private final Context internalContext;
    private final Context externalContext;
    private final String connectionFactoryBindString;
    private final String topicConnectionFactoryBindString;
    private final String queueConnectionFactoryBindString;
    private final String xaTopicConnectionFactoryBindString;
    private final String xaQueueConnectionFactoryBindString;
    private final Collection<String> queueNames;
    private final Collection<String> topicNames;

    public GsJmsLookupManager(String containerName, IJSpace spaceProxy, GSJmsFactory jmsFactory, Context internalJndiContext, Context externalJndiContext) {
        this.spaceName = spaceProxy.getName();
        this.spaceProxy = spaceProxy;
        this.jmsFactory = jmsFactory;
        this.internalContext = internalJndiContext;
        this.externalContext = externalJndiContext;
        String prefix = "GigaSpaces;" + containerName + ";" + this.spaceName + ";";
        this.connectionFactoryBindString = prefix + "GSConnectionFactoryImpl";
        this.queueConnectionFactoryBindString = prefix + "GSQueueConnectionFactoryImpl";
        this.topicConnectionFactoryBindString = prefix + "GSTopicConnectionFactoryImpl";
        this.xaQueueConnectionFactoryBindString = prefix + "GSXAQueueConnectionFactoryImpl";
        this.xaTopicConnectionFactoryBindString = prefix + "GSXATopicConnectionFactoryImpl";
        String fullSpaceName = JSpaceUtilities.createFullSpaceName((String)containerName, (String)this.spaceName);
        SpaceConfigReader configReader = new SpaceConfigReader(fullSpaceName);
        String destinationPrefix = prefix + "jms" + ";" + "destinations" + ";";
        this.topicNames = GsJmsLookupManager.toCollection(configReader.getSpaceProperty("jms.administrated-destinations.topics.topic-names", "MyTopic,TempTopic"), destinationPrefix);
        this.queueNames = GsJmsLookupManager.toCollection(configReader.getSpaceProperty("jms.administrated-destinations.queues.queue-names", "MyQueue,TempQueue"), destinationPrefix);
        String rmiPort = configReader.getSpaceProperty("jms.connections.rmi-port", "10098");
    }

    public void initialize() throws Exception {
        this.rebind(this.connectionFactoryBindString, this.jmsFactory.createConnectionFactory(this.spaceProxy), "ConnectionFactory");
        this.rebind(this.queueConnectionFactoryBindString, this.jmsFactory.createQueueConnectionFactory(this.spaceProxy), "QueueConnectionFactory");
        this.rebind(this.topicConnectionFactoryBindString, this.jmsFactory.createTopicConnectionFactory(this.spaceProxy), "TopicConnectionFactory");
        this.rebind(this.xaQueueConnectionFactoryBindString, this.jmsFactory.createXAQueueConnectionFactory(this.spaceProxy), "XAQueueConnectionFactory");
        this.rebind(this.xaTopicConnectionFactoryBindString, this.jmsFactory.createXATopicConnectionFactory(this.spaceProxy), "XATopicConnectionFactory");
        for (String name : this.topicNames) {
            this.rebind(name, this.jmsFactory.createTopic(name), "Topic");
        }
        for (String name : this.queueNames) {
            this.rebind(name, this.jmsFactory.createQueue(name), "Queue");
        }
    }

    @Override
    public void close() {
        this.unbind(this.topicConnectionFactoryBindString, "TopicConnectionFactory");
        this.unbind(this.queueConnectionFactoryBindString, "QueueConnectionFactory");
        this.unbind(this.xaTopicConnectionFactoryBindString, "XATopicConnectionFactory");
        this.unbind(this.xaQueueConnectionFactoryBindString, "XAQueueConnectionFactory");
        for (String name : this.topicNames) {
            this.unbind(name, "Topic");
        }
        for (String name : this.queueNames) {
            this.unbind(name, "Queue");
        }
    }

    protected void rebind(String name, Object obj, String desc) {
        block9: {
            block8: {
                if (this.internalContext != null) {
                    try {
                        this.internalContext.rebind(name, obj);
                        if (_logger.isLoggable(Level.INFO)) {
                            _logger.info("JMS " + desc + " < " + name + " > bound successfully to the RMIRegistry lookup service.");
                        }
                    }
                    catch (NamingException e) {
                        if (!_logger.isLoggable(Level.WARNING)) break block8;
                        _logger.log(Level.WARNING, "Failed to register < " + name + " > JMS Admin Object, on space <" + this.spaceName + "> using the the RMIRegistry lookup service: " + this.internalContext + " | ", e);
                    }
                }
            }
            if (this.externalContext != null) {
                try {
                    this.externalContext.rebind(name, obj);
                    if (_logger.isLoggable(Level.INFO)) {
                        _logger.info("JMS " + desc + " < " + name + " > bound successfully to the External JNDI lookup service: " + this.externalContext.getEnvironment().toString());
                    }
                }
                catch (NamingException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block9;
                    _logger.log(Level.SEVERE, "Failed to register < " + name + " > JMS Admin Object, on space <" + this.spaceName + "> using the external JNDI lookup service: " + this.externalContext + " | " + e.getRootCause().getMessage(), e);
                }
            }
        }
    }

    protected void unbind(String name, String desc) {
        block10: {
            block9: {
                if (StringUtils.isEmpty((String)name)) {
                    return;
                }
                if (this.internalContext != null) {
                    try {
                        this.internalContext.unbind(name);
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine("JMS " + desc + " < " + name + " > unbound successfully from the RMIRegistry lookup service");
                        }
                    }
                    catch (NamingException e) {
                        if (!_logger.isLoggable(Level.WARNING)) break block9;
                        _logger.log(Level.WARNING, "Failed to unbind the < " + name + " > JMS Admin Object, from space <" + this.spaceName + "> using the the RMIRegistry lookup service: " + this.internalContext + " | " + e.getRootCause().toString(), e);
                    }
                }
            }
            if (this.externalContext != null) {
                try {
                    this.externalContext.unbind(name);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("JMS " + desc + " < " + name + " > unbound successfully from the External JNDI lookup service: " + this.externalContext.getEnvironment().toString());
                    }
                }
                catch (NamingException e) {
                    if (!_logger.isLoggable(Level.WARNING)) break block10;
                    _logger.log(Level.WARNING, "Failed to unbind the < " + name + " > JMS Admin Object, from space <" + this.spaceName + "> using the external JNDI lookup service: " + this.externalContext + " | " + e.getRootCause().toString(), e);
                }
            }
        }
    }

    private static Collection<String> toCollection(String s, String prefix) {
        if (StringUtils.isEmpty((String)s)) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(s, ",");
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            result.add(prefix + st.nextToken());
        }
        return result;
    }
}

