/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.events.DataEventSessionFactory;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.client.ExternalEntry;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.NotifyModifiers;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.jms.JMSDurableSubDataEntry;
import com.j_spaces.jms.JMSOfflineStateDurSubDataEntry;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.transaction.TransactionException;

public class JMSDurableSubService
extends GSThread {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.jms");
    private static final String DELIM = "!#$%";
    private static final String[] FIELDS_NAMES = new String[]{"message_body", "JMSDestination", "JMSDeliveryMode", "JMSExpiration", "JMSPriority", "JMSMessageID", "JMSTimestamp", "JMSCorrelationID", "JMSReplyTo", "JMSType", "JMSRedelivered", "JMS_GSProducerKey", "JMS_GSTTLKey", "JMSXGroupID", "JMSXGroupSeq", "JMSXUserID", "message_client_properties"};
    private static final String[] FIELDS_TYPES = new String[]{Object.class.getName(), Destination.class.getName(), Integer.class.getName(), Long.class.getName(), Integer.class.getName(), String.class.getName(), Long.class.getName(), Object.class.getName(), Destination.class.getName(), String.class.getName(), Boolean.class.getName(), String.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), String.class.getName(), HashMap.class.getName()};
    private boolean m_ShouldShutdown;
    private final Object m_ShutdownMonitor;
    private final Hashtable<String, JMSDurableSubDataEntry> m_subscriptionNamesHash;
    private final Hashtable m_topicsHash;
    private final Hashtable m_registrations;
    private DataEventSession _eventSession;
    private final WriteRemoteEventListener m_WriteRemoteEventListener;
    private final IJSpace m_space;
    private ExternalEntry _defaultTemplate;
    private final ReentrantLock unsubscribeLock;

    public JMSDurableSubService(IJSpace space) {
        block2: {
            super("JMSDurableSubscriptionService");
            this.m_ShouldShutdown = false;
            this.unsubscribeLock = new ReentrantLock();
            this.setDaemon(true);
            this.m_space = space;
            this.m_subscriptionNamesHash = new Hashtable();
            this.m_topicsHash = new Hashtable();
            this.m_registrations = new Hashtable();
            this.m_ShutdownMonitor = new Object();
            SubscriptionRemoteEventListener m_subscriptionRemoteEventListener = new SubscriptionRemoteEventListener();
            this.m_WriteRemoteEventListener = new WriteRemoteEventListener();
            try {
                this._eventSession = DataEventSessionFactory.create((IJSpace)space, (EventSessionConfig)new EventSessionConfig().setFifo(true));
                NotifyActionType notifyType = NotifyActionType.NOTIFY_WRITE.or(NotifyActionType.NOTIFY_TAKE).or(NotifyActionType.NOTIFY_LEASE_EXPIRATION);
                this._eventSession.addListener((Object)new JMSDurableSubDataEntry(), (RemoteEventListener)m_subscriptionRemoteEventListener, notifyType);
                this._eventSession.addListener((Object)new JMSOfflineStateDurSubDataEntry(), (RemoteEventListener)m_subscriptionRemoteEventListener, NotifyActionType.NOTIFY_LEASE_EXPIRATION);
            }
            catch (RemoteException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribe(String subscriptionName, String unsubscribedTopicName, String clientIDToUnSubscribe) {
        block10: {
            this.unsubscribeLock.lock();
            try {
                EventRegistration registration;
                String id = clientIDToUnSubscribe + DELIM + subscriptionName + DELIM + unsubscribedTopicName;
                JMSDurableSubDataEntry subscriptionEntryToRemove = this.m_subscriptionNamesHash.remove(id);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" unsubscribe() with ID: " + id);
                }
                Vector subscriptionEntriesVec = (Vector)this.m_topicsHash.remove(unsubscribedTopicName);
                for (int i = 0; i < subscriptionEntriesVec.size(); ++i) {
                    JMSDurableSubDataEntry subscriptionEntry = (JMSDurableSubDataEntry)((Object)subscriptionEntriesVec.get(i));
                    if (!subscriptionEntry.m_durableSubscriptionName.equalsIgnoreCase(subscriptionName) || !subscriptionEntry.m_subscriberClientID.equalsIgnoreCase(clientIDToUnSubscribe)) continue;
                    subscriptionEntriesVec.remove(i);
                }
                this.m_topicsHash.put(unsubscribedTopicName, subscriptionEntriesVec);
                if (subscriptionEntriesVec.size() > 0 || (registration = (EventRegistration)this.m_registrations.get(unsubscribedTopicName)) == null) break block10;
                try {
                    this._eventSession.removeListener(registration);
                }
                catch (UnknownLeaseException e) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "unsubscribe() cancel ND lease:  " + e.toString(), e);
                    }
                }
                catch (RemoteException e) {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "unsubscribe() cancel ND lease:  " + e.toString(), e);
                    }
                }
            }
            finally {
                this.unsubscribeLock.unlock();
            }
        }
    }

    private JMSDurableSubDataEntry getDurSubEntryFromSubscriptionNamesHash(String subscriptionName, String subscribedTopicName, String clientIDToSubscribe) throws JMSException {
        String id = clientIDToSubscribe + DELIM + subscriptionName + DELIM + subscribedTopicName;
        JMSDurableSubDataEntry retObj = this.m_subscriptionNamesHash.get(id);
        if (retObj != null) {
            return retObj;
        }
        return null;
    }

    private JMSDurableSubDataEntry[] updateDurSubEntriesFromTopicsHash(String subscribedTopicName, String offlineExtEntryUID) throws JMSException {
        Vector subscriptionEntriesVec = (Vector)this.m_topicsHash.get(subscribedTopicName);
        JMSDurableSubDataEntry[] jmsDurableSubDataEntryArray = new JMSDurableSubDataEntry[subscriptionEntriesVec.size()];
        for (int i = 0; i < subscriptionEntriesVec.size(); ++i) {
            JMSDurableSubDataEntry subscriptionEntry = (JMSDurableSubDataEntry)((Object)subscriptionEntriesVec.get(i));
            subscriptionEntry.m_offlineEntryUIDsVec.addElement(offlineExtEntryUID);
            jmsDurableSubDataEntryArray[i] = subscriptionEntry;
        }
        return jmsDurableSubDataEntryArray;
    }

    private void removeOfflineStateSubscription(String subscriptionName, String subscribedTopicName, String clientIDToSubscribe) throws JMSException {
        String id = clientIDToSubscribe + DELIM + subscriptionName + DELIM + subscribedTopicName;
        JMSDurableSubDataEntry subscriptionEntryToRemove = this.m_subscriptionNamesHash.get(id);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(" removeOfflineStateSubscription() with ID: " + id);
        }
        Vector subscriptionEntriesVec = (Vector)this.m_topicsHash.get(subscribedTopicName);
        for (int i = 0; i < subscriptionEntriesVec.size(); ++i) {
            JMSDurableSubDataEntry subscriptionEntry = (JMSDurableSubDataEntry)((Object)subscriptionEntriesVec.get(i));
            if (!subscriptionEntry.m_durableSubscriptionName.equalsIgnoreCase(subscriptionName) || !subscriptionEntry.m_subscriberClientID.equalsIgnoreCase(clientIDToSubscribe)) continue;
            subscriptionEntriesVec.remove(i);
        }
    }

    private void addOfflineStateSubscription(String subscriptionName, String subscribedTopicName, String clientIDToSubscribe) throws JMSException {
        block4: {
            String id = clientIDToSubscribe + DELIM + subscriptionName + DELIM + subscribedTopicName;
            JMSDurableSubDataEntry subscriptionEntry = this.m_subscriptionNamesHash.get(id);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JMSDurableSubService.addOfflineStateSubscription() with ID: " + id);
            }
            Vector subscriptionEntriesVec = (Vector)this.m_topicsHash.remove(subscribedTopicName);
            subscriptionEntriesVec.addElement(subscriptionEntry);
            this.m_topicsHash.put(subscribedTopicName, subscriptionEntriesVec);
            if (this.m_registrations.get(subscribedTopicName) == null) {
                Object offlineWrittenExtEntryTemplate = this.getDefaultTemplate(subscribedTopicName);
                try {
                    EventRegistration registration = this._eventSession.addListener(offlineWrittenExtEntryTemplate, (RemoteEventListener)this.m_WriteRemoteEventListener, NotifyActionType.NOTIFY_WRITE);
                    this.m_registrations.put(subscribedTopicName, registration);
                }
                catch (RemoteException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block4;
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    private void addOnlineStateSubsciption(String subscriptionName, String subscribedTopicName, String clientIDToSubscribe, JMSDurableSubDataEntry subsriptionDataEntry) throws JMSException {
        String id = clientIDToSubscribe + DELIM + subscriptionName + DELIM + subscribedTopicName;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JMSDurableSubService.addOnlineStateSubscription() with ID: " + id);
        }
        this.m_subscriptionNamesHash.put(id, subsriptionDataEntry);
        Object subscriptionEntriesVec = this.m_topicsHash.get(subscribedTopicName);
        if (subscriptionEntriesVec == null) {
            this.m_topicsHash.put(subscribedTopicName, new Vector());
        }
    }

    private Object getDefaultTemplate(String destName) {
        if (this._defaultTemplate == null || !this._defaultTemplate.m_ClassName.equalsIgnoreCase(destName)) {
            this._defaultTemplate = new ExternalEntry(destName, new Object[17], FIELDS_NAMES, FIELDS_TYPES);
            this._defaultTemplate.setFifo(true);
        }
        return this._defaultTemplate;
    }

    public void run() {
        while (!this.shouldShutdown()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, this.getName() + " interrupted.", ie);
                }
                this.interrupt();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldShutdown() {
        Object object = this.m_ShutdownMonitor;
        synchronized (object) {
            return this.m_ShouldShutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("inside shutdown() ");
        }
        Object object = this.m_ShutdownMonitor;
        synchronized (object) {
            if (this.m_ShouldShutdown) {
                return;
            }
            this.m_ShouldShutdown = true;
        }
        this.shutdown();
    }

    public static void main(String[] args) {
        IJSpace space;
        block2: {
            space = null;
            try {
                space = (IJSpace)SpaceFinder.find((String)args[0]);
            }
            catch (FinderException e) {
                if (!_logger.isLoggable(Level.SEVERE)) break block2;
                _logger.log(Level.SEVERE, e.toString(), e);
            }
        }
        new JMSDurableSubService(space);
    }

    class WriteRemoteEventListener
    implements RemoteEventListener {
        private ReentrantLock notifyLock = new ReentrantLock();

        WriteRemoteEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(RemoteEvent theEvent) throws UnknownEventException, RemoteException {
            this.notifyLock.lock();
            try {
                String topicName;
                JMSDurableSubDataEntry[] updatedSubEntriesArray;
                EntryArrivedRemoteEvent spaceEvent = (EntryArrivedRemoteEvent)theEvent;
                String uid = spaceEvent.getEntryPacket().getUID();
                String className = spaceEvent.getEntryPacket().getTypeName();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("WriteRemoteEventListener.notify() -- className: " + className + " | uid: " + uid);
                }
                if (null != (updatedSubEntriesArray = JMSDurableSubService.this.updateDurSubEntriesFromTopicsHash(topicName = className, uid))) {
                    long[] leases = new long[updatedSubEntriesArray.length];
                    Arrays.fill(leases, 0L);
                    JMSDurableSubService.this.m_space.updateMultiple((Object[])updatedSubEntriesArray, null, leases);
                }
            }
            catch (UnusableEntryException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
            catch (JMSException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
            catch (RemoteException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
            catch (TransactionException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
            finally {
                this.notifyLock.unlock();
            }
        }
    }

    class SubscriptionRemoteEventListener
    implements RemoteEventListener {
        private final ReentrantLock notifyLock = new ReentrantLock();

        SubscriptionRemoteEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(RemoteEvent theEvent) throws UnknownEventException, RemoteException {
            this.notifyLock.lock();
            try {
                Object entry = ((EntryArrivedRemoteEvent)theEvent).getObject();
                int notifyType = ((EntryArrivedRemoteEvent)theEvent).getNotifyType();
                if (entry instanceof JMSOfflineStateDurSubDataEntry) {
                    JMSOfflineStateDurSubDataEntry jmsOfflineStateDurSubDataEntry = (JMSOfflineStateDurSubDataEntry)((Object)entry);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(" SubscriptionRemoteEventListener.notify()  " + jmsOfflineStateDurSubDataEntry.toString());
                    }
                    Boolean isSubscribed = jmsOfflineStateDurSubDataEntry.m_isSubscribed;
                    Boolean isSubscriberOnline = jmsOfflineStateDurSubDataEntry.m_isSubscriberOnline;
                    String durableSubscriptionName = jmsOfflineStateDurSubDataEntry.m_durableSubscriptionName;
                    String subscriberClientID = jmsOfflineStateDurSubDataEntry.m_subscriberClientID;
                    String subscribedTopicName = jmsOfflineStateDurSubDataEntry.m_topicName;
                    if (NotifyModifiers.isLeaseExpiration((int)notifyType)) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.fine(" SubscriptionRemoteEventListener.notify() -- Lease has expired -- the durable subscriber went down.  || --  " + jmsOfflineStateDurSubDataEntry.toString());
                        }
                        JMSDurableSubService.this.addOfflineStateSubscription(durableSubscriptionName, subscribedTopicName, subscriberClientID);
                    }
                } else if (entry instanceof JMSDurableSubDataEntry) {
                    JMSDurableSubDataEntry jmsDurableSubDataEntry = (JMSDurableSubDataEntry)((Object)entry);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine(" SubscriptionRemoteEventListener.notify()  || --  " + jmsDurableSubDataEntry.toString());
                    }
                    Boolean isSubscribed = jmsDurableSubDataEntry.m_isSubscribed;
                    Boolean isSubscriberOnline = jmsDurableSubDataEntry.m_isSubscriberOnline;
                    String durableSubscriptionName = jmsDurableSubDataEntry.m_durableSubscriptionName;
                    String subscribedTopicName = jmsDurableSubDataEntry.m_topicName;
                    String subscriberClientID = jmsDurableSubDataEntry.m_subscriberClientID;
                    JMSDurableSubDataEntry subscriptionDataEntry = JMSDurableSubService.this.getDurSubEntryFromSubscriptionNamesHash(durableSubscriptionName, subscribedTopicName, subscriberClientID);
                    if (subscriptionDataEntry == null && isSubscriberOnline.booleanValue() && isSubscribed.booleanValue()) {
                        JMSDurableSubService.this.addOnlineStateSubsciption(durableSubscriptionName, subscribedTopicName, subscriberClientID, jmsDurableSubDataEntry);
                    } else if (subscriptionDataEntry != null && !isSubscriberOnline.booleanValue() && isSubscribed.booleanValue()) {
                        JMSDurableSubService.this.removeOfflineStateSubscription(durableSubscriptionName, subscribedTopicName, subscriberClientID);
                    } else if (subscriptionDataEntry != null && !isSubscribed.booleanValue()) {
                        JMSDurableSubService.this.unsubscribe(durableSubscriptionName, subscribedTopicName, subscriberClientID);
                    }
                }
            }
            catch (UnusableEntryException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
            catch (JMSException e) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, e.toString(), e);
                }
            }
            finally {
                this.notifyLock.unlock();
            }
        }
    }
}

