/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import java.util.Vector;

public class MessageAcks {
    private Vector acksVec;
    private volatile boolean queueMode;
    private String destinationNameToBeAcked;

    MessageAcks(boolean queueMode, String destNameToBeAcked) {
        this.queueMode = queueMode;
        this.acksVec = new Vector();
        this.destinationNameToBeAcked = destNameToBeAcked;
    }

    void addAck(String producerKey, String consumerKey, String ackedMessageID, String destNameToBeAcked) {
        this.acksVec.add(new Ack(producerKey, consumerKey, ackedMessageID, destNameToBeAcked));
    }

    public Vector getAcksVec() {
        return this.acksVec;
    }

    boolean getQueueMode() {
        return this.queueMode;
    }

    public String getTargetName() {
        return this.destinationNameToBeAcked;
    }

    public void setTargetName(String targetName) {
        this.destinationNameToBeAcked = targetName;
    }

    static class Ack {
        String producerKey;
        String consumerKey;
        String ackedMessageID;
        String destNameToBeAcked;

        Ack(String producerKey, String consumerKey, String ackedMessageID, String destNameToBeAcked) {
            this.producerKey = producerKey;
            this.consumerKey = consumerKey;
            this.ackedMessageID = ackedMessageID;
            this.destNameToBeAcked = destNameToBeAcked;
        }

        public String getAckedMessageID() {
            return this.ackedMessageID;
        }

        public String getConsumerKey() {
            return this.consumerKey;
        }

        public String getProducerKey() {
            return this.producerKey;
        }

        public String getDestNameToBeAcked() {
            return this.destNameToBeAcked;
        }
    }
}

