/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms;

import com.gigaspaces.client.transaction.xa.GSServerTransaction;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.XAResourceImpl;
import com.j_spaces.jms.GSXASessionImpl;
import com.j_spaces.jms.XATrasactionContext;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.server.TransactionManager;

public class XAResourceJMSImpl
extends XAResourceImpl {
    private GSXASessionImpl session = null;
    private static Logger logger = Logger.getLogger("com.gigaspaces.core.xa");
    private HashMap<Xid, XATrasactionContext> transactionsTable;

    public XAResourceJMSImpl(TransactionManager tm, GSXASessionImpl session, ISpaceProxy proxy) {
        super(tm, (IJSpace)proxy);
        this.session = session;
        this.transactionsTable = new HashMap();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Initialized: " + this.toString());
        }
    }

    public void start(Xid xid, int flag) throws XAException {
        Xid originalxid = xid;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Associating transaction: " + xid);
        }
        xid = this.createGSXid(xid);
        Transaction.Created cr = this.startIn(originalxid, flag, false);
        XATrasactionContext context = this.transactionsTable.get(xid);
        if (context == null) {
            context = new XATrasactionContext(cr.transaction);
            this.transactionsTable.put(xid, context);
        } else {
            context.setTransaction(cr.transaction);
        }
        context.setStatus(2);
        this.session.setTransaction(context);
    }

    public void end(Xid xid, int flag) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Disassociating transaction: " + xid);
        }
        this.session.setTransaction(null);
        xid = this.createGSXid(xid);
        XATrasactionContext context = this.transactionsTable.get(xid);
        if (context != null) {
            boolean isEmpty;
            boolean bl = isEmpty = this._activeEmptyTransactions.contains(xid) && context.getSentMessages().isEmpty();
            if (!isEmpty) {
                this._activeEmptyTransactions.remove(xid);
            }
            switch (flag) {
                case 0x4000000: {
                    context.setStatus(2);
                    break;
                }
                case 0x2000000: {
                    context.setStatus(1);
                    break;
                }
                case 0x20000000: {
                    context.setStatus(3);
                    this.rollback(xid);
                    break;
                }
            }
        }
        this._proxy.replaceContextTransaction(null);
    }

    public int prepare(Xid xid) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Preparing transaction: " + xid);
        }
        Xid originalxid = xid;
        XATrasactionContext context = this.transactionsTable.get(xid = this.createGSXid(xid));
        if (context != null) {
            try {
                this.session.sendMessages(context.getSentMessages(), context.getTransaction());
            }
            catch (RemoteException e) {
                throw new XAException(101);
            }
            catch (Exception e) {
                throw new XAException(100);
            }
        }
        int result = super.prepare(originalxid);
        return result;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Committing transaction: " + xid);
        }
        if (onePhase) {
            this.prepare(xid);
        }
        Xid originalxid = xid;
        xid = this.createGSXid(xid);
        super.commit(originalxid, onePhase);
        this.transactionsTable.remove(xid);
    }

    public void rollback(Xid xid) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Rolling back transaction: " + xid);
        }
        Xid originalxid = xid;
        if (this.transactionsTable.containsKey(xid = this.createGSXid(xid))) {
            super.rollback(originalxid);
            this.transactionsTable.remove(xid);
        }
    }

    public void forget(Xid xid) throws XAException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Forgetting transaction: " + xid);
        }
        xid = this.createGSXid(xid);
        this.transactionsTable.remove(xid);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        block5: {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Comparing XAResource to: " + xares);
            }
            if (xares == this) {
                return true;
            }
            try {
                if (super.isSameRM(xares) && xares instanceof XAResourceJMSImpl) {
                    XAResourceJMSImpl xaresImpl = (XAResourceJMSImpl)((Object)xares);
                    return this.session.equals(xaresImpl.session);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, "Exception while comparing XAResource to: " + xares);
            }
        }
        return false;
    }

    public String toString() {
        return "XAResourceJMSImpl:\nLocalTransactionManager: " + this.m_txnManger + "\nXASession: " + this.session.m_sessionID;
    }

    public void action(Transaction txn) {
        if (txn != null && txn.equals(this.session.getTransaction())) {
            GSServerTransaction gstxn = (GSServerTransaction)txn;
            this._activeEmptyTransactions.remove(gstxn.getId());
        }
    }
}

