/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms.utils;

import java.util.concurrent.locks.ReentrantLock;

public class Counter {
    protected ReentrantLock lock = new ReentrantLock();
    protected int value;
    protected int start;

    public Counter() {
        this(0);
    }

    public Counter(int startValue) {
        this.start = startValue;
        this.value = startValue;
    }

    public void reset() {
        this.lock.lock();
        this.value = this.start;
        this.lock.unlock();
    }

    public void setValue(int val) {
        this.lock.lock();
        this.value = val;
        this.lock.unlock();
    }

    public int getValue() {
        this.lock.lock();
        int newValue = this.value;
        this.lock.unlock();
        return newValue;
    }

    public int increment() {
        this.lock.lock();
        int newValue = ++this.value;
        this.lock.unlock();
        return newValue;
    }

    public int increment(int val) {
        if (val < 0) {
            return this.decrement(-val);
        }
        this.lock.lock();
        int newValue = this.value += val;
        this.lock.unlock();
        return newValue;
    }

    public int decrement() {
        this.lock.lock();
        int newValue = --this.value;
        this.lock.unlock();
        return newValue;
    }

    public int decrement(int val) {
        if (val < 0) {
            return this.increment(-val);
        }
        this.lock.lock();
        int newValue = this.value -= val;
        this.lock.unlock();
        return newValue;
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }
}

