/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms.utils;

import com.j_spaces.jms.utils.Counter;

public class CyclicCounter
extends Counter {
    public CyclicCounter() {
    }

    public CyclicCounter(int startValue) {
        super(startValue);
    }

    @Override
    public int increment() {
        this.lock.lock();
        this.value = this.value != Integer.MAX_VALUE ? ++this.value : 0;
        int newValue = this.value;
        this.lock.unlock();
        return newValue;
    }

    @Override
    public int increment(int val) {
        if (val < 0) {
            return this.decrement(-val);
        }
        this.lock.lock();
        int remain = Integer.MAX_VALUE - this.value;
        int dif = remain - val;
        this.value = dif >= 0 ? (this.value += val) : -dif - 1;
        int newValue = this.value;
        this.lock.unlock();
        return newValue;
    }

    @Override
    public int decrement() {
        this.lock.lock();
        this.value = this.value != 0 ? --this.value : Integer.MAX_VALUE;
        int newValue = this.value;
        this.lock.unlock();
        return newValue;
    }

    @Override
    public int decrement(int val) {
        if (val < 0) {
            return this.increment(-val);
        }
        this.lock.lock();
        int dif = this.value - val;
        this.value = dif >= 0 ? (this.value -= val) : Integer.MAX_VALUE + (dif + 1);
        int newValue = this.value;
        this.lock.unlock();
        return newValue;
    }
}

