/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms.utils;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.jms.GSConnectionFactoryImpl;
import com.j_spaces.jms.GSQueueImpl;
import com.j_spaces.jms.GSTopicImpl;
import com.j_spaces.jms.GSXAConnectionFactoryImpl;
import com.j_spaces.jms.utils.IMessageConverter;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.ResourceAllocationException;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;

public class GSJMSAdmin {
    private static GSJMSAdmin m_adminInstance = null;
    private static final String COMPRESSION_PROPERTY = "com.gs.jms.compressionMinSize";
    private int compressionMinSize;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.jms");
    private HashMap<String, ConnectionFactory> connectionfactories = new HashMap();
    private HashMap<String, XAConnectionFactory> xaConnectionfactories = new HashMap();
    private HashMap<String, Queue> queues = new HashMap();
    private HashMap<String, Topic> topics = new HashMap();
    private InitialContext jndiContext = null;

    private GSJMSAdmin() {
        String compression = System.getProperty(COMPRESSION_PROPERTY, "500000");
        this.compressionMinSize = Integer.valueOf(compression);
    }

    public static synchronized GSJMSAdmin getInstance() {
        if (m_adminInstance == null) {
            m_adminInstance = new GSJMSAdmin();
        }
        return m_adminInstance;
    }

    public ConnectionFactory getConnectionFactory(String spaceURL) throws JMSException {
        return this.getConnectionFactory(spaceURL, null);
    }

    public synchronized ConnectionFactory getConnectionFactory(String spaceURL, IMessageConverter messageConverter) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getConnectionFactory(String): spaceURL=" + spaceURL + ", IMessageConverter=" + messageConverter);
        }
        IJSpace space = this.findSpace(spaceURL);
        return this.getConnectionFactory(space, messageConverter);
    }

    public ConnectionFactory getConnectionFactory(IJSpace space) throws JMSException {
        return this.getConnectionFactory(space, null);
    }

    public synchronized ConnectionFactory getConnectionFactory(IJSpace space, IMessageConverter messageConverter) throws JMSException {
        String key;
        ConnectionFactory connectionFactory;
        if (space == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSJMSAdmin.getConnectionFactory(IJSpace): Space proxy is null");
            }
            throw new JMSException("Space proxy is null");
        }
        Uuid spaceUuid = ((ReferentUuid)space).getReferentUuid();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getConnectionFactory(IJSpace): Space URL=" + space.getURL().getURL() + ", Space UUID=" + spaceUuid + ", IMessageConverter=" + messageConverter);
        }
        if ((connectionFactory = this.connectionfactories.get(key = messageConverter == null ? spaceUuid.toString() : spaceUuid.toString() + messageConverter.getClass().getName())) != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSJMSAdmin.getConnectionFactory(IJSpace): Found ConnectionFactory in cache: " + connectionFactory);
            }
            return connectionFactory;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getConnectionFactory(IJSpace): ConnectionFactory not found in cache");
        }
        connectionFactory = new GSConnectionFactoryImpl(space, messageConverter);
        this.connectionfactories.put(key, connectionFactory);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getConnectionFactory(IJSpace): Created a new ConnectionFactory: " + connectionFactory);
        }
        return connectionFactory;
    }

    public QueueConnectionFactory getQueueConnectionFactory(String spaceURL) throws JMSException {
        return this.getQueueConnectionFactory(spaceURL, null);
    }

    public synchronized QueueConnectionFactory getQueueConnectionFactory(String spaceURL, IMessageConverter messageConverter) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getQueueConnectionFactory(String): spaceURL=" + spaceURL + ", IMessageConverter=" + messageConverter);
        }
        return (QueueConnectionFactory)this.getConnectionFactory(spaceURL, messageConverter);
    }

    public TopicConnectionFactory getTopicConnectionFactory(String spaceURL) throws JMSException {
        return this.getTopicConnectionFactory(spaceURL, null);
    }

    public synchronized TopicConnectionFactory getTopicConnectionFactory(String spaceURL, IMessageConverter messageConverter) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getTopicConnectionFactory(String): spaceURL=" + spaceURL + ", IMessageConverter=" + messageConverter);
        }
        return (TopicConnectionFactory)this.getConnectionFactory(spaceURL, messageConverter);
    }

    public QueueConnectionFactory getQueueConnectionFactory(IJSpace space) throws JMSException {
        return this.getQueueConnectionFactory(space, null);
    }

    public synchronized QueueConnectionFactory getQueueConnectionFactory(IJSpace space, IMessageConverter messageConverter) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getQueueConnectionFactory(IJSpace): Space=" + space.getName() + ", IMessageConverter=" + messageConverter);
        }
        return (QueueConnectionFactory)this.getConnectionFactory(space, messageConverter);
    }

    public TopicConnectionFactory getTopicConnectionFactory(IJSpace space) throws JMSException {
        return this.getTopicConnectionFactory(space, null);
    }

    public synchronized TopicConnectionFactory getTopicConnectionFactory(IJSpace space, IMessageConverter messageConverter) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getTopicConnectionFactory(IJSpace): Space=" + space.getName() + ", IMessageConverter=" + messageConverter);
        }
        return (TopicConnectionFactory)this.getConnectionFactory(space, messageConverter);
    }

    public XAConnectionFactory getXAConnectionFactory(String spaceURL) throws JMSException {
        return this.getXAConnectionFactory(spaceURL, null);
    }

    public synchronized XAConnectionFactory getXAConnectionFactory(String spaceURL, IMessageConverter messageConverter) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getXAConnectionFactory(String): spaceURL=" + spaceURL + ", IMessageConverter=" + messageConverter);
        }
        IJSpace space = this.findSpace(spaceURL);
        return this.getXAConnectionFactory(space, messageConverter);
    }

    public XAConnectionFactory getXAConnectionFactory(IJSpace space) throws JMSException {
        return this.getXAConnectionFactory(space, null);
    }

    public synchronized XAConnectionFactory getXAConnectionFactory(IJSpace space, IMessageConverter messageConverter) throws JMSException {
        String key;
        XAConnectionFactory connectionFactory;
        if (space == null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSJMSAdmin.getXAConnectionFactory(IJSpace): Space proxy is null");
            }
            throw new JMSException("Space proxy is null");
        }
        Uuid spaceUuid = ((ReferentUuid)space).getReferentUuid();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getXAConnectionFactory(IJSpace): Space URL=" + space.getURL().getURL() + ", Space UUID=" + spaceUuid + ", IMessageConverter=" + messageConverter);
        }
        if ((connectionFactory = this.xaConnectionfactories.get(key = messageConverter == null ? spaceUuid.toString() : spaceUuid.toString() + messageConverter.getClass().getName())) != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("GSJMSAdmin.getXAConnectionFactory(IJSpace): Found XAConnectionFactory in cache: " + connectionFactory);
            }
            return connectionFactory;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getXAConnectionFactory(IJSpace): XAConnectionFactory not found in cache");
        }
        connectionFactory = new GSXAConnectionFactoryImpl(space, messageConverter);
        this.xaConnectionfactories.put(key, connectionFactory);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getXAConnectionFactory(IJSpace): Created a new XAConnectionFactory: " + connectionFactory);
        }
        return connectionFactory;
    }

    public XAQueueConnectionFactory getXAQueueConnectionFactory(String spaceURL) throws JMSException {
        return this.getXAQueueConnectionFactory(spaceURL, null);
    }

    public synchronized XAQueueConnectionFactory getXAQueueConnectionFactory(String spaceURL, IMessageConverter messageConverter) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getXAQueueConnectionFactory(String): spaceURL=" + spaceURL + ", IMessageConverter=" + messageConverter);
        }
        return (XAQueueConnectionFactory)this.getConnectionFactory(spaceURL, messageConverter);
    }

    public XATopicConnectionFactory getXATopicConnectionFactory(String spaceURL) throws JMSException {
        return this.getXATopicConnectionFactory(spaceURL, null);
    }

    public synchronized XATopicConnectionFactory getXATopicConnectionFactory(String spaceURL, IMessageConverter messageConverter) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getXATopicConnectionFactory(String): spaceURL=" + spaceURL + ", IMessageConverter=" + messageConverter);
        }
        return (XATopicConnectionFactory)this.getConnectionFactory(spaceURL, messageConverter);
    }

    public XAQueueConnectionFactory getXAQueueConnectionFactory(IJSpace space) throws JMSException {
        return this.getXAQueueConnectionFactory(space, null);
    }

    public synchronized XAQueueConnectionFactory getXAQueueConnectionFactory(IJSpace space, IMessageConverter messageConverter) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getXAQueueConnectionFactory(IJSpace): Space=" + space.getName() + ", IMessageConverter=" + messageConverter);
        }
        return (XAQueueConnectionFactory)this.getXAConnectionFactory(space, messageConverter);
    }

    public XATopicConnectionFactory getXATopicConnectionFactory(IJSpace space) throws JMSException {
        return this.getXATopicConnectionFactory(space, null);
    }

    public synchronized XATopicConnectionFactory getXATopicConnectionFactory(IJSpace space, IMessageConverter messageConverter) throws JMSException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("GSJMSAdmin.getXATopicConnectionFactory(IJSpace): Space=" + space.getName() + ", IMessageConverter=" + messageConverter);
        }
        return (XATopicConnectionFactory)this.getXAConnectionFactory(space, messageConverter);
    }

    public synchronized Queue getQueue(String name) {
        Queue queue = this.queues.get(name);
        if (queue == null) {
            queue = new GSQueueImpl(name);
            this.queues.put(name, queue);
        }
        return queue;
    }

    public synchronized Topic getTopic(String name) {
        Topic topic = this.topics.get(name);
        if (topic == null) {
            topic = new GSTopicImpl(name);
            this.topics.put(name, topic);
        }
        return topic;
    }

    private IJSpace findSpace(String spaceURL) throws JMSException {
        IJSpace spaceProxy = null;
        try {
            spaceProxy = (IJSpace)SpaceFinder.find((String)spaceURL);
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("GSJMSAdmin.findSpace() Found space <" + spaceProxy.getName() + ">  using SpaceURL: " + spaceURL);
            }
        }
        catch (FinderException ex) {
            ResourceAllocationException rae = new ResourceAllocationException("GSJMSAdmin - ERROR: Could not find space: " + spaceURL + ex.toString() + "\n");
            rae.setLinkedException((Exception)((Object)ex));
            throw rae;
        }
        return spaceProxy;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public Object jndiLookup(String name) throws NamingException {
        return this.getInitialContext().lookup(name);
    }

    private synchronized InitialContext getInitialContext() throws NamingException {
        block3: {
            if (this.jndiContext == null) {
                try {
                    this.jndiContext = new InitialContext();
                    this.jndiContext.getEnvironment();
                }
                catch (NoInitialContextException ne) {
                    Properties props = new Properties();
                    props.setProperty("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
                    props.setProperty("java.naming.provider.url", "rmi://localhost:10098");
                    this.jndiContext = new InitialContext(props);
                    if (!_logger.isLoggable(Level.FINE)) break block3;
                    _logger.fine("GSJMSAdmin.getInitialContext() Using fallback jndiContext environment: " + this.jndiContext.getEnvironment());
                }
            }
        }
        return this.jndiContext;
    }

    public void createAndBindDestination(boolean isQueue, String destinationName) throws NamingException, JMSException {
        try {
            Object dest = this.jndiLookup(destinationName);
        }
        catch (NamingException ne) {
            Object dest = isQueue ? this.getQueue(destinationName) : this.getTopic(destinationName);
            this.getInitialContext().rebind(destinationName, dest);
        }
    }

    public void destroyAndUnBindDestination(String destinationName) throws JMSException {
        try {
            this.getInitialContext().unbind(destinationName);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }
}

