/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms.utils;

import com.gigaspaces.internal.io.GSByteArrayOutputStream;
import com.j_spaces.jms.utils.ClassLoading;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Proxy;

public class SerializationHelper {
    private static final GSByteArrayOutputStream outStream = new GSByteArrayOutputStream(65535);
    private static final ClassLoader GIGASPACES_JMS_CLASSLOADER = SerializationHelper.class.getClassLoader();

    public static byte[] writeObject(Object object) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(object);
        out.close();
        return buffer.toByteArray();
    }

    public static Object readObject(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream buffer = new ByteArrayInputStream(data);
        ObjectInputStreamExt in = new ObjectInputStreamExt(buffer);
        Object answer = in.readObject();
        in.close();
        return answer;
    }

    public static Object readObject(InputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStreamExt objIn = new ObjectInputStreamExt(in);
        Object result = objIn.readObject();
        return result;
    }

    public static Object objectFromByteBuffer(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(buffer);
        ObjectInputStreamExt in = new ObjectInputStreamExt(inStream);
        Object retval = in.readObject();
        in.close();
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByteBuffer(Object obj) throws Exception {
        byte[] result = null;
        GSByteArrayOutputStream gSByteArrayOutputStream = outStream;
        synchronized (gSByteArrayOutputStream) {
            outStream.reset();
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)outStream);
            out.writeObject(obj);
            out.flush();
            result = outStream.toByteArray();
            out.close();
        }
        return result;
    }

    public static Object deepClone(Object obj) {
        try {
            byte[] bArray = SerializationHelper.objectToByteBuffer(obj);
            return SerializationHelper.objectFromByteBuffer(bArray);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to perform deep clone on [" + obj + "] object. Check that the all object context are implements java.io.Serializable.", ex);
        }
    }

    public static void writeObject(OutputStream out, Object obj) throws IOException {
        ObjectOutputStream objOut = new ObjectOutputStream(out);
        objOut.writeObject(obj);
        objOut.flush();
    }

    public static class ObjectInputStreamExt
    extends ObjectInputStream {
        public ObjectInputStreamExt(InputStream in) throws IOException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return this.load(classDesc.getName(), cl);
        }

        protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class[] cinterfaces = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                cinterfaces[i] = this.load(interfaces[i], cl);
            }
            try {
                return Proxy.getProxyClass(cinterfaces[0].getClassLoader(), cinterfaces);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }

        private Class load(String className, ClassLoader cl) throws ClassNotFoundException {
            try {
                return ClassLoading.loadClass(className, cl);
            }
            catch (ClassNotFoundException e) {
                return ClassLoading.loadClass(className, GIGASPACES_JMS_CLASSLOADER);
            }
        }
    }
}

