/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.jms.utils;

import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class StringsUtils {
    public static final String EMPTY = "";
    private static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"};
    private static final String[] ejbQlIdentifiers = new String[]{"AND", "AS", "BETWEEN", "DISTINCT", "EMPTY", "FALSE", "FROM", "IN", "IS", "LIKE", "MEMBER", "NOT", "NULL", "OBJECT", "OF", "OR", "SELECT", "UNKNOWN", "TRUE", "WHERE"};
    public static final int listMax = 10;
    public static final int listBorder = 3;

    public static final boolean isEjbQlIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < ejbQlIdentifiers.length; ++i) {
            if (!ejbQlIdentifiers[i].equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        return string.equals(EMPTY);
    }

    public static final boolean isValidJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    public static final boolean isJavaKeyword(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!keywords[i].equals(s)) continue;
            return true;
        }
        return false;
    }

    public static final void toString(StringBuffer output, Object obj) {
        if (obj == null) {
            output.append("null");
            return;
        }
        if (obj instanceof String) {
            StringsUtils.toString(output, (String)obj);
            return;
        }
        if (obj instanceof Vector) {
            StringsUtils.toString(output, (Vector)obj);
            return;
        }
        if (obj instanceof Hashtable) {
            StringsUtils.toString(output, (Hashtable)obj);
            return;
        }
        Class<?> type = obj.getClass();
        if (type.isArray()) {
            StringsUtils.toString(output, obj, type.getComponentType());
            return;
        }
        output.append(obj.toString());
    }

    public static final String toString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return StringsUtils.toString((String)obj);
        }
        StringBuffer output = new StringBuffer();
        StringsUtils.toString(output, obj);
        return output.toString();
    }

    public static final void toByteArray(ByteArrayOutputStream output, String str) {
        if (str == null) {
            return;
        }
        output.write(34);
        int max = str.length();
        block10: for (int i = 0; i < max; ++i) {
            char b = str.charAt(i);
            if (b >= ' ' && b <= '~') {
                switch (b) {
                    case '\"': 
                    case '\\': {
                        output.write(92);
                    }
                }
                output.write(b);
                continue;
            }
            output.write(92);
            switch (b) {
                case '\b': {
                    output.write(98);
                    continue block10;
                }
                case '\t': {
                    output.write(116);
                    continue block10;
                }
                case '\n': {
                    output.write(110);
                    continue block10;
                }
                case '\f': {
                    output.write(102);
                    continue block10;
                }
                case '\r': {
                    output.write(114);
                    continue block10;
                }
                default: {
                    output.write(117);
                    int b3 = b >> 4;
                    int b4 = b & 0xF;
                    b4 = b4 < 10 ? (b4 += 48) : (b4 += 87);
                    int b2 = b3 >> 4;
                    b3 = (b3 &= 0xF) < 10 ? (b3 += 48) : (b3 += 87);
                    int b1 = b2 >> 4;
                    b2 = (b2 &= 0xF) < 10 ? (b2 += 48) : (b2 += 87);
                    b1 = b1 < 10 ? (b1 += 48) : (b1 += 87);
                    output.write(b1);
                    output.write(b2);
                    output.write(b3);
                    output.write(b4);
                }
            }
        }
        output.write(34);
    }

    public static final void toString(StringBuffer output, String str) {
        if (str == null) {
            output.append("null");
            return;
        }
        output.append(StringsUtils.toString(str));
    }

    public static final String toString(String str) {
        if (str == null) {
            return "null";
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StringsUtils.toByteArray(buffer, str);
        return buffer.toString();
    }

    public static final void toString(StringBuffer output, Object obj, Class type) {
        if (obj == null) {
            output.append("null");
            return;
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                StringsUtils.toString(output, (boolean[])obj);
            } else if (type == Character.TYPE) {
                StringsUtils.toString(output, (char[])obj);
            } else if (type == Byte.TYPE) {
                StringsUtils.toString(output, (byte[])obj);
            } else if (type == Short.TYPE) {
                StringsUtils.toString(output, (short[])obj);
            } else if (type == Integer.TYPE) {
                StringsUtils.toString(output, (int[])obj);
            } else if (type == Long.TYPE) {
                StringsUtils.toString(output, (long[])obj);
            } else if (type == Float.TYPE) {
                StringsUtils.toString(output, (float[])obj);
            } else if (type == Double.TYPE) {
                StringsUtils.toString(output, (double[])obj);
            }
            return;
        }
        Object[] tab = (Object[])obj;
        output.append("(");
        int size = tab.length;
        output.append(size);
        if (size <= 10) {
            for (int i = 0; i < size; ++i) {
                output.append(",");
                StringsUtils.toString(output, tab[i]);
            }
        } else {
            int i;
            int border = size / 2;
            if (3 < border) {
                border = 3;
            }
            for (i = 0; i < border; ++i) {
                output.append(",");
                StringsUtils.toString(output, tab[i]);
            }
            output.append(",...");
            for (i = border; i > 0; --i) {
                output.append(",");
                StringsUtils.toString(output, tab[size - i]);
            }
        }
        output.append(")");
    }

    public static final void toStringArray(StringBuffer output, Object tab) {
        if (tab == null) {
            output.append("null");
            return;
        }
        Class<?> type = tab.getClass();
        if (!type.isArray()) {
            StringsUtils.toString(output, tab);
            return;
        }
        StringsUtils.toString(output, tab, type.getComponentType());
    }

    public static final String toStringArray(Object tab) {
        if (tab == null) {
            return "null";
        }
        Class<?> type = tab.getClass();
        if (!type.isArray()) {
            return StringsUtils.toString(tab);
        }
        StringBuffer output = new StringBuffer();
        StringsUtils.toString(output, tab, type.getComponentType());
        return output.toString();
    }

    public static final void toString(StringBuffer output, boolean[] tab) {
        if (tab == null) {
            output.append("null");
            return;
        }
        output.append("(");
        int size = tab.length;
        output.append(size);
        if (size <= 10) {
            for (int i = 0; i < size; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
        } else {
            int i;
            int border = size / 2;
            if (3 < border) {
                border = 3;
            }
            for (i = 0; i < border; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
            output.append(",...");
            for (i = border; i > 0; --i) {
                output.append(",");
                output.append(tab[size - i]);
            }
        }
        output.append(")");
    }

    public static final void toString(StringBuffer output, byte[] tab) {
        if (tab == null) {
            output.append("null");
            return;
        }
        output.append("(");
        int size = tab.length;
        output.append(size);
        if (size <= 10) {
            for (int i = 0; i < size; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
        } else {
            int i;
            int border = size / 2;
            if (3 < border) {
                border = 3;
            }
            for (i = 0; i < border; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
            output.append(",...");
            for (i = border; i > 0; --i) {
                output.append(",");
                output.append(tab[size - i]);
            }
        }
        output.append(")");
    }

    public static final void toString(StringBuffer output, char[] tab) {
        if (tab == null) {
            output.append("null");
            return;
        }
        output.append("(");
        int size = tab.length;
        output.append(size);
        if (size <= 10) {
            for (int i = 0; i < size; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
        } else {
            int i;
            int border = size / 2;
            if (3 < border) {
                border = 3;
            }
            for (i = 0; i < border; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
            output.append(",...");
            for (i = border; i > 0; --i) {
                output.append(",");
                output.append(tab[size - i]);
            }
        }
        output.append(")");
    }

    public static final void toString(StringBuffer output, short[] tab) {
        if (tab == null) {
            output.append("null");
            return;
        }
        output.append("(");
        int size = tab.length;
        output.append(size);
        if (size <= 10) {
            for (int i = 0; i < size; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
        } else {
            int i;
            int border = size / 2;
            if (3 < border) {
                border = 3;
            }
            for (i = 0; i < border; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
            output.append(",...");
            for (i = border; i > 0; --i) {
                output.append(",");
                output.append(tab[size - i]);
            }
        }
        output.append(")");
    }

    public static final void toString(StringBuffer output, int[] tab) {
        if (tab == null) {
            output.append("null");
            return;
        }
        output.append("(");
        int size = tab.length;
        output.append(size);
        if (size <= 10) {
            for (int i = 0; i < size; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
        } else {
            int i;
            int border = size / 2;
            if (3 < border) {
                border = 3;
            }
            for (i = 0; i < border; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
            output.append(",...");
            for (i = border; i > 0; --i) {
                output.append(",");
                output.append(tab[size - i]);
            }
        }
        output.append(")");
    }

    public static final void toString(StringBuffer output, long[] tab) {
        if (tab == null) {
            output.append("null");
            return;
        }
        output.append("(");
        int size = tab.length;
        output.append(size);
        if (size <= 10) {
            for (int i = 0; i < size; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
        } else {
            int i;
            int border = size / 2;
            if (3 < border) {
                border = 3;
            }
            for (i = 0; i < border; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
            output.append(",...");
            for (i = border; i > 0; --i) {
                output.append(",");
                output.append(tab[size - i]);
            }
        }
        output.append(")");
    }

    public static final void toString(StringBuffer output, float[] tab) {
        if (tab == null) {
            output.append("null");
            return;
        }
        output.append("(");
        int size = tab.length;
        output.append(size);
        if (size <= 10) {
            for (int i = 0; i < size; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
        } else {
            int i;
            int border = size / 2;
            if (3 < border) {
                border = 3;
            }
            for (i = 0; i < border; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
            output.append(",...");
            for (i = border; i > 0; --i) {
                output.append(",");
                output.append(tab[size - i]);
            }
        }
        output.append(")");
    }

    public static final void toString(StringBuffer output, double[] tab) {
        if (tab == null) {
            output.append("null");
            return;
        }
        output.append("(");
        int size = tab.length;
        output.append(size);
        if (size <= 10) {
            for (int i = 0; i < size; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
        } else {
            int i;
            int border = size / 2;
            if (3 < border) {
                border = 3;
            }
            for (i = 0; i < border; ++i) {
                output.append(",");
                output.append(tab[i]);
            }
            output.append(",...");
            for (i = border; i > 0; --i) {
                output.append(",");
                output.append(tab[size - i]);
            }
        }
        output.append(")");
    }

    public static final void toString(StringBuffer output, Vector vector) {
        if (vector == null) {
            output.append("null");
            return;
        }
        output.append("(");
        int size = vector.size();
        output.append(size);
        if (size <= 10) {
            Enumeration e = vector.elements();
            while (e.hasMoreElements()) {
                output.append(",");
                StringsUtils.toString(output, e.nextElement());
            }
        } else {
            int i;
            int border = size / 2;
            if (3 < border) {
                border = 3;
            }
            for (i = 0; i < border; ++i) {
                output.append(",");
                StringsUtils.toString(output, vector.elementAt(i));
            }
            output.append(",...");
            for (i = border; i > 0; --i) {
                output.append(",");
                StringsUtils.toString(output, vector.elementAt(size - i));
            }
        }
        output.append(")");
    }

    public static final String toString(Vector vector) {
        if (vector == null) {
            return "null";
        }
        StringBuffer output = new StringBuffer();
        StringsUtils.toString(output, vector);
        return output.toString();
    }

    public static final void toString(StringBuffer output, Hashtable table) {
        if (table == null) {
            output.append("null");
            return;
        }
        output.append("(");
        int size = table.size();
        output.append(size);
        if (size <= 10) {
            Enumeration e = table.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                output.append(",(");
                StringsUtils.toString(output, key);
                output.append(",");
                StringsUtils.toString(output, table.get(key));
                output.append(")");
            }
        } else {
            int border = size;
            if (3 < border) {
                border = 3;
            }
            Enumeration e = table.keys();
            for (int i = 0; i < border; ++i) {
                Object key = e.nextElement();
                output.append(",(");
                StringsUtils.toString(output, key);
                output.append(",");
                StringsUtils.toString(output, table.get(key));
                output.append(")");
            }
            if (border < size) {
                output.append(",...");
            }
        }
        output.append(")");
    }

    public static final String toString(Hashtable table) {
        if (table == null) {
            return "null";
        }
        StringBuffer output = new StringBuffer();
        StringsUtils.toString(output, table);
        return output.toString();
    }
}

