/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.gnu.trove;

import com.gigaspaces.internal.gnu.trove.TIterator;
import com.gigaspaces.internal.gnu.trove.TObjectHash;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

abstract class THashIterator<V>
extends TIterator
implements Iterator<V> {
    private final TObjectHash _object_hash;

    public THashIterator(TObjectHash hash) {
        super(hash);
        this._object_hash = hash;
    }

    @Override
    public V next() {
        this.moveToNextIndex();
        return this.objectAtIndex(this._index);
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._object_hash._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == TObjectHash.FREE || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    protected abstract V objectAtIndex(int var1);
}

