/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.gnu.trove;

import com.gigaspaces.internal.gnu.trove.HashFunctions;
import com.gigaspaces.internal.gnu.trove.TIntHashingStrategy;
import com.gigaspaces.internal.gnu.trove.TIntProcedure;
import com.gigaspaces.internal.gnu.trove.TPrimitiveHash;

public abstract class TIntHash
extends TPrimitiveHash
implements TIntHashingStrategy {
    private static final long serialVersionUID = -7713228974804414188L;
    protected transient int[] _set;
    protected TIntHashingStrategy _hashingStrategy;

    public TIntHash() {
        this._hashingStrategy = this;
    }

    public TIntHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TIntHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TIntHash(TIntHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TIntHash(int initialCapacity, TIntHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TIntHash(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public Object clone() {
        TIntHash h = (TIntHash)super.clone();
        h._set = (int[])this._set.clone();
        return h;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new int[capacity];
        return capacity;
    }

    public boolean contains(int val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TIntProcedure procedure) {
        byte[] states = this._states;
        int[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int index) {
        this._set[index] = 0;
        super.removeAt(index);
    }

    protected int index(int val) {
        byte[] states = this._states;
        int[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set[index] != val));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(int val) {
        byte[] states = this._states;
        int[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (states[index] != 2) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] == 1 && set[index] != val);
        }
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }

    @Override
    public final int computeHashCode(int val) {
        return HashFunctions.hash(val);
    }
}

