/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.gnu.trove;

import com.gigaspaces.internal.gnu.trove.TIterator;
import com.gigaspaces.internal.gnu.trove.TObjectHash;
import com.gigaspaces.internal.gnu.trove.TObjectIntHashMap;
import java.util.ConcurrentModificationException;

public class TObjectIntIterator<K>
extends TIterator {
    private final TObjectIntHashMap<K> _map;

    public TObjectIntIterator(TObjectIntHashMap<K> map) {
        super(map);
        this._map = map;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == null || set[i] == TObjectHash.REMOVED || set[i] == TObjectHash.FREE)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public K key() {
        return (K)this._map._set[this._index];
    }

    public int value() {
        return this._map._values[this._index];
    }

    public int setValue(int val) {
        int old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

