/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.gnu.trove;

import com.gigaspaces.internal.gnu.trove.TIterator;
import com.gigaspaces.internal.gnu.trove.TObjectHash;
import com.gigaspaces.internal.gnu.trove.TObjectLongHashMap;
import java.util.ConcurrentModificationException;

public class TObjectLongIterator<K>
extends TIterator {
    private final TObjectLongHashMap<K> _map;

    public TObjectLongIterator(TObjectLongHashMap<K> map) {
        super(map);
        this._map = map;
    }

    @Override
    protected final int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == null || set[i] == TObjectHash.REMOVED || set[i] == TObjectHash.FREE)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public K key() {
        return (K)this._map._set[this._index];
    }

    public long value() {
        return this._map._values[this._index];
    }

    public long setValue(long val) {
        long old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

