/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.gnu.trove;

import com.gigaspaces.internal.gnu.trove.HashFunctions;
import com.gigaspaces.internal.gnu.trove.TPrimitiveHash;
import com.gigaspaces.internal.gnu.trove.TShortHashingStrategy;
import com.gigaspaces.internal.gnu.trove.TShortProcedure;

public abstract class TShortHash
extends TPrimitiveHash
implements TShortHashingStrategy {
    private static final long serialVersionUID = -5517990019894702919L;
    protected transient short[] _set;
    protected TShortHashingStrategy _hashingStrategy;

    public TShortHash() {
        this._hashingStrategy = this;
    }

    public TShortHash(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TShortHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TShortHash(TShortHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TShortHash(int initialCapacity, TShortHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TShortHash(int initialCapacity, float loadFactor, TShortHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public Object clone() {
        TShortHash h = (TShortHash)super.clone();
        h._set = (short[])this._set.clone();
        return h;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new short[capacity];
        return capacity;
    }

    public boolean contains(short val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TShortProcedure procedure) {
        byte[] states = this._states;
        short[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void removeAt(int index) {
        this._set[index] = 0;
        super.removeAt(index);
    }

    protected int index(short val) {
        byte[] states = this._states;
        short[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set[index] != val));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(short val) {
        byte[] states = this._states;
        short[] set = this._set;
        int length = states.length;
        int hash = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (states[index] != 2) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] == 1 && set[index] != val);
        }
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }

    @Override
    public final int computeHashCode(short val) {
        return HashFunctions.hash(val);
    }
}

