/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.kms.model.ListRetirableGrantsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListRetirableGrantsRequestMarshaller
implements Marshaller<Request<ListRetirableGrantsRequest>, ListRetirableGrantsRequest> {
    public Request<ListRetirableGrantsRequest> marshall(ListRetirableGrantsRequest listRetirableGrantsRequest) {
        if (listRetirableGrantsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listRetirableGrantsRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.ListRetirableGrants");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (listRetirableGrantsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue((long)listRetirableGrantsRequest.getLimit().intValue());
            }
            if (listRetirableGrantsRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listRetirableGrantsRequest.getMarker());
            }
            if (listRetirableGrantsRequest.getRetiringPrincipal() != null) {
                jsonGenerator.writeFieldName("RetiringPrincipal").writeValue(listRetirableGrantsRequest.getRetiringPrincipal());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

