/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.insightedge.udt;

import java.util.Collection;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.openspaces.spatial.ShapeFactory;
import org.openspaces.spatial.shapes.Circle;
import org.openspaces.spatial.shapes.LineString;
import org.openspaces.spatial.shapes.Polygon;
import org.openspaces.spatial.shapes.Rectangle;
import org.openspaces.spatial.spatial4j.Spatial4jShapeProvider;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class GeoUtils$ {
    public static final GeoUtils$ MODULE$;
    private final double pointId;
    private final double circleId;
    private final double rectangleId;
    private final double polygonId;
    private final double lineStringId;
    private SpatialContext defaultContext;
    private volatile boolean bitmap$0;

    static {
        new GeoUtils$();
    }

    private SpatialContext defaultContext$lzycompute() {
        GeoUtils$ geoUtils$ = this;
        synchronized (geoUtils$) {
            if (!this.bitmap$0) {
                this.defaultContext = this.createDefaultSpatialContext();
                this.bitmap$0 = true;
            }
            return this.defaultContext;
        }
    }

    public double pointId() {
        return this.pointId;
    }

    public double circleId() {
        return this.circleId;
    }

    public double rectangleId() {
        return this.rectangleId;
    }

    public double polygonId() {
        return this.polygonId;
    }

    public double lineStringId() {
        return this.lineStringId;
    }

    public SpatialContext defaultContext() {
        return this.bitmap$0 ? this.defaultContext : this.defaultContext$lzycompute();
    }

    public SpatialContext createDefaultSpatialContext() {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.geo = true;
        return new JtsSpatialContext(factory);
    }

    public ArrayData pack(Object shape) {
        Object object;
        block7: {
            Object object2;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                object = shape;
                                if (!(object instanceof org.openspaces.spatial.shapes.Point)) break block2;
                                org.openspaces.spatial.shapes.Point point = (org.openspaces.spatial.shapes.Point)object;
                                object2 = new double[]{this.pointId(), point.getX(), point.getY()};
                                break block3;
                            }
                            if (!(object instanceof Circle)) break block4;
                            Circle circle = (Circle)object;
                            object2 = new double[]{this.circleId(), circle.getCenterX(), circle.getCenterY(), circle.getRadius()};
                            break block3;
                        }
                        if (!(object instanceof Rectangle)) break block5;
                        Rectangle rectangle = (Rectangle)object;
                        object2 = new double[]{this.rectangleId(), rectangle.getMinX(), rectangle.getMaxX(), rectangle.getMinY(), rectangle.getMaxY()};
                        break block3;
                    }
                    if (!(object instanceof Polygon)) break block6;
                    Polygon polygon = (Polygon)object;
                    double d = this.polygonId();
                    int n = polygon.getNumOfPoints();
                    List list = (List)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d)).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), polygon.getNumOfPoints()).flatMap((Function1)new Serializable(polygon){
                        public static final long serialVersionUID = 0L;
                        private final Polygon x5$1;

                        public final Seq<Object> apply(int index) {
                            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{this.x5$1.getX(index), this.x5$1.getY(index)}));
                        }
                        {
                            this.x5$1 = x5$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
                    object2 = list.toArray(ClassTag$.MODULE$.AnyVal());
                    break block3;
                }
                if (!(object instanceof LineString)) break block7;
                LineString lineString = (LineString)object;
                double d = this.lineStringId();
                int n = lineString.getNumOfPoints();
                List list = (List)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n)).$colon$colon((Object)BoxesRunTime.boxToDouble((double)d)).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), lineString.getNumOfPoints()).flatMap((Function1)new Serializable(lineString){
                    public static final long serialVersionUID = 0L;
                    private final LineString x6$1;

                    public final Seq<Object> apply(int index) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{this.x6$1.getX(index), this.x6$1.getY(index)}));
                    }
                    {
                        this.x6$1 = x6$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
                object2 = list.toArray(ClassTag$.MODULE$.AnyVal());
            }
            double[] array = object2;
            return new GenericArrayData((Object)array);
        }
        throw new MatchError(object);
    }

    public Shape unpackSpatialShape(Object anyData, SpatialContext context) {
        Object object;
        block10: {
            Shape shape;
            block9: {
                block2: {
                    double d;
                    block8: {
                        Point point;
                        block4: {
                            ArrayData arrayData;
                            block7: {
                                block6: {
                                    block5: {
                                        block3: {
                                            object = anyData;
                                            if (!(object instanceof ArrayData)) break block2;
                                            arrayData = (ArrayData)object;
                                            d = arrayData.getDouble(0);
                                            if (this.pointId() != d) break block3;
                                            point = context.makePoint(arrayData.getDouble(1), arrayData.getDouble(2));
                                            break block4;
                                        }
                                        if (this.circleId() != d) break block5;
                                        point = context.makeCircle(arrayData.getDouble(1), arrayData.getDouble(2), arrayData.getDouble(3));
                                        break block4;
                                    }
                                    if (this.rectangleId() != d) break block6;
                                    point = context.makeRectangle(arrayData.getDouble(1), arrayData.getDouble(2), arrayData.getDouble(3), arrayData.getDouble(4));
                                    break block4;
                                }
                                if (this.polygonId() != d) break block7;
                                point = ((Spatial4jShapeProvider)this.unpackXapPolygon(arrayData)).getSpatial4jShape(context);
                                break block4;
                            }
                            if (this.lineStringId() != d) break block8;
                            IndexedSeq points = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), arrayData.getInt(1)).map((Function1)new Serializable(context, arrayData){
                                public static final long serialVersionUID = 0L;
                                private final SpatialContext context$1;
                                private final ArrayData x2$1;

                                public final Point apply(int index) {
                                    return this.context$1.makePoint(this.x2$1.getDouble(index * 2 + 2), this.x2$1.getDouble(index * 2 + 3));
                                }
                                {
                                    this.context$1 = context$1;
                                    this.x2$1 = x2$1;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                            point = context.makeLineString((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)points).asJava());
                        }
                        shape = point;
                        break block9;
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToDouble((double)d));
                }
                if (!(object instanceof org.openspaces.spatial.shapes.Shape)) break block10;
                org.openspaces.spatial.shapes.Shape shape2 = (org.openspaces.spatial.shapes.Shape)object;
                shape = ((Spatial4jShapeProvider)shape2).getSpatial4jShape(context);
            }
            return shape;
        }
        throw new MatchError(object);
    }

    public org.openspaces.spatial.shapes.Point unpackXapPoint(ArrayData data) {
        return ShapeFactory.point((double)data.getDouble(1), (double)data.getDouble(2));
    }

    public Circle unpackXapCircle(ArrayData data) {
        return ShapeFactory.circle((org.openspaces.spatial.shapes.Point)ShapeFactory.point((double)data.getDouble(1), (double)data.getDouble(2)), (double)data.getDouble(3));
    }

    public Rectangle unpackXapRectangle(ArrayData data) {
        return ShapeFactory.rectangle((double)data.getDouble(1), (double)data.getDouble(2), (double)data.getDouble(3), (double)data.getDouble(4));
    }

    public Polygon unpackXapPolygon(ArrayData data) {
        IndexedSeq xapPoints = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), data.getInt(1)).map((Function1)new Serializable(data){
            public static final long serialVersionUID = 0L;
            private final ArrayData data$1;

            public final org.openspaces.spatial.shapes.Point apply(int index) {
                return ShapeFactory.point((double)this.data$1.getDouble(index * 2 + 2), (double)this.data$1.getDouble(index * 2 + 3));
            }
            {
                this.data$1 = data$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return ShapeFactory.polygon((Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)xapPoints).asJava()));
    }

    public LineString unpackXapLineString(ArrayData data) {
        IndexedSeq xapPoints = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), data.getInt(1)).map((Function1)new Serializable(data){
            public static final long serialVersionUID = 0L;
            private final ArrayData data$2;

            public final org.openspaces.spatial.shapes.Point apply(int index) {
                return ShapeFactory.point((double)this.data$2.getDouble(index * 2 + 2), (double)this.data$2.getDouble(index * 2 + 3));
            }
            {
                this.data$2 = data$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return ShapeFactory.lineString((Collection)((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)xapPoints).asJava()));
    }

    private GeoUtils$() {
        MODULE$ = this;
        this.pointId = 0.0;
        this.circleId = 1.0;
        this.rectangleId = 2.0;
        this.polygonId = 3.0;
        this.lineStringId = 4.0;
    }
}

