/*
 * Decompiled with CFR 0.152.
 */
package org.insightedge.spark;

import com.gigaspaces.internal.io.IOUtils;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.SparkSession;
import org.insightedge.internal.utils.ClassLoaderUtils;
import org.jini.rio.boot.ServiceClassLoader;
import scala.Option;

public class SparkSessionProvider
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final boolean CLOSABLE_ENABLED = !Boolean.getBoolean("com.gs.spark.session.auto-close-disabled");
    private String master;
    private Map<String, Object> configOptions = new HashMap<String, Object>();
    private boolean enableHiveSupport;
    private String logLevel;
    private transient Wrapper wrapper;

    public SparkSessionProvider() {
    }

    protected SparkSessionProvider(Builder builder) {
        this.master = builder.master;
        this.configOptions = builder.configOptions;
        this.enableHiveSupport = builder.enableHiveSupport;
        this.logLevel = builder.logLevel;
    }

    public String getMaster() {
        return this.master;
    }

    public boolean isEnableHiveSupport() {
        return this.enableHiveSupport;
    }

    public Map<String, Object> getConfigOptions() {
        return this.configOptions;
    }

    public synchronized Wrapper getOrCreate() {
        if (this.wrapper != null) {
            return this.wrapper.reuse();
        }
        if (this.master != null && !this.master.isEmpty()) {
            SparkSession.Builder builder = SparkSession.builder();
            builder.master(this.master);
            if (this.enableHiveSupport) {
                builder.enableHiveSupport();
            }
            this.configOptions.forEach((key, value) -> this.config(builder, (String)key, value));
            if (this.logLevel != null) {
                Logger.getLogger("org.apache").setLevel(Level.parse(this.logLevel));
            }
            SparkSession activeSession = (SparkSession)SparkSessionProvider.getIfExists(SparkSession.getActiveSession());
            SparkSession defaultSession = (SparkSession)SparkSessionProvider.getIfExists(SparkSession.getDefaultSession());
            SparkSession sparkSession = builder.getOrCreate();
            boolean closable = sparkSession != activeSession && sparkSession != defaultSession;
            this.wrapper = new Wrapper(sparkSession, closable && CLOSABLE_ENABLED);
            return this.wrapper;
        }
        Option activeSession = SparkSession.getActiveSession();
        if (activeSession.isDefined()) {
            this.wrapper = new Wrapper((SparkSession)activeSession.get(), false);
            return this.wrapper;
        }
        throw new IllegalStateException("Spark session is not configured and no active session was found");
    }

    private static <T> T getIfExists(Option<T> o) {
        return (T)(o.isDefined() ? o.get() : null);
    }

    private void config(SparkSession.Builder builder, String key, Object value) {
        if (value instanceof String) {
            builder.config(key, (String)value);
        } else if (value instanceof Boolean) {
            builder.config(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Long) {
            builder.config(key, ((Long)value).longValue());
        } else if (value instanceof Double) {
            builder.config(key, ((Double)value).doubleValue());
        } else {
            throw new IllegalArgumentException(String.format("config key %s has unsupported type: %s", key, value.getClass()));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString((ObjectOutput)out, (String)this.master);
        IOUtils.writeObject((ObjectOutput)out, this.configOptions);
        out.writeBoolean(this.enableHiveSupport);
        IOUtils.writeString((ObjectOutput)out, (String)this.logLevel);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.master = IOUtils.readString((ObjectInput)in);
        this.configOptions = (Map)IOUtils.readObject((ObjectInput)in);
        this.enableHiveSupport = in.readBoolean();
        this.logLevel = IOUtils.readString((ObjectInput)in);
    }

    public boolean hasSparkTaskContext() {
        return TaskContext.get() != null;
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader instanceof ServiceClassLoader) {
            ClassLoaderUtils.addSparkJars((ServiceClassLoader)classLoader);
        }
    }

    public static class Wrapper
    implements Closeable {
        private final SparkSession sparkSession;
        private final boolean closable;
        private final AtomicInteger referenceCounter;

        private Wrapper(SparkSession sparkSession, boolean closable) {
            this.sparkSession = sparkSession;
            this.closable = closable;
            this.referenceCounter = new AtomicInteger(1);
        }

        public SparkSession get() {
            return this.sparkSession;
        }

        private Wrapper reuse() {
            this.referenceCounter.incrementAndGet();
            return this;
        }

        @Override
        public void close() throws IOException {
            if (this.referenceCounter.decrementAndGet() == 0 && this.closable) {
                this.sparkSession.close();
            }
        }
    }

    public static class Builder {
        private String master;
        private Map<String, Object> configOptions = new HashMap<String, Object>();
        private boolean enableHiveSupport;
        private String logLevel;

        public SparkSessionProvider create() {
            return new SparkSessionProvider(this);
        }

        public Builder master(String master) {
            this.master = master;
            return this;
        }

        public Builder configOptions(Map<String, Object> configOptions) {
            this.configOptions = configOptions;
            return this;
        }

        public Builder config(String key, String value) {
            this.configOptions.put(key, value);
            return this;
        }

        public Builder enableHiveSupport(boolean enableHiveSupport) {
            this.enableHiveSupport = enableHiveSupport;
            return this;
        }

        public Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }
    }
}

