/*
 * Decompiled with CFR 0.152.
 */
package org.insightedge.spark.utils;

import com.gigaspaces.async.AsyncFuture;
import org.insightedge.spark.context.InsightEdgeConfig;
import org.insightedge.spark.impl.InsightEdgePartition;
import org.insightedge.spark.impl.InsightEdgePartition$;
import org.insightedge.spark.utils.GridProxyFactory$;
import org.insightedge.spark.utils.InsightEdgeConstants$;
import org.insightedge.spark.utils.Logging;
import org.insightedge.spark.utils.Logging$class;
import org.insightedge.spark.utils.LookupPartitionTask;
import org.insightedge.spark.utils.Profiler$;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.executor.DistributedTask;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class GridProxyUtils$
implements Logging {
    public static final GridProxyUtils$ MODULE$;
    private transient Logger org$insightedge$spark$utils$Logging$$_log;

    static {
        new GridProxyUtils$();
    }

    @Override
    public Logger org$insightedge$spark$utils$Logging$$_log() {
        return this.org$insightedge$spark$utils$Logging$$_log;
    }

    @Override
    public void org$insightedge$spark$utils$Logging$$_log_$eq(Logger x$1) {
        this.org$insightedge$spark$utils$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public <R> Seq<InsightEdgePartition> buildGridPartitions(InsightEdgeConfig ieConfig, Option<Object> splitCount, boolean supportsBuckets, ClassTag<R> evidence$1) {
        return (Seq)this.profileWithInfo("lookupInsightEdgePartitions", (Function0)new Serializable(ieConfig, splitCount, supportsBuckets){
            public static final long serialVersionUID = 0L;
            private final InsightEdgeConfig ieConfig$1;
            private final Option splitCount$1;
            private final boolean supportsBuckets$1;

            public final Seq<InsightEdgePartition> apply() {
                GigaSpace gs = GridProxyFactory$.MODULE$.getOrCreateClustered(this.ieConfig$1);
                AsyncFuture asyncResult = gs.execute((DistributedTask)new LookupPartitionTask());
                Seq<InsightEdgePartition> gsPartitions = (Seq<InsightEdgePartition>)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer((java.util.List)asyncResult.get()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<String> apply(java.util.List<String> x$1) {
                        return JavaConversions$.MODULE$.asScalaBuffer(x$1).toList();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final InsightEdgePartition apply(List<String> x0$1) {
                        List<String> list = x0$1;
                        Some some = List$.MODULE$.unapplySeq(list);
                        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(3) == 0) {
                            String hostName = (String)((LinearSeqOptimized)some.get()).apply(0);
                            String containerName = (String)((LinearSeqOptimized)some.get()).apply(1);
                            String id = (String)((LinearSeqOptimized)some.get()).apply(2);
                            if (hostName != null) {
                                String string = hostName;
                                if (containerName != null) {
                                    String string2 = containerName;
                                    if (id != null) {
                                        String string3 = id;
                                        InsightEdgePartition insightEdgePartition = new InsightEdgePartition(new StringOps(Predef$.MODULE$.augmentString(string3)).toInt(), string, string2, InsightEdgePartition$.MODULE$.apply$default$4(), InsightEdgePartition$.MODULE$.apply$default$5());
                                        return insightEdgePartition;
                                    }
                                }
                            }
                        }
                        throw new MatchError(list);
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                return this.supportsBuckets$1 ? GridProxyUtils$.MODULE$.splitPartitionsByBuckets(gsPartitions, (Option<Object>)this.splitCount$1) : gsPartitions;
            }
            {
                this.ieConfig$1 = ieConfig$1;
                this.splitCount$1 = splitCount$1;
                this.supportsBuckets$1 = supportsBuckets$1;
            }
        });
    }

    public Seq<InsightEdgePartition> splitPartitionsByBuckets(Seq<InsightEdgePartition> gridPartitions, Option<Object> optionalSplitCount) {
        int splitCount = Math.max(1, BoxesRunTime.unboxToInt((Object)optionalSplitCount.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return InsightEdgeConstants$.MODULE$.DefaultSplitCount();
            }
        })));
        int gridPartitionsSize = gridPartitions.size();
        Seq sparkPartitions = (Seq)gridPartitions.flatMap((Function1)new Serializable(splitCount, gridPartitionsSize){
            public static final long serialVersionUID = 0L;
            private final int splitCount$2;
            private final int gridPartitionsSize$1;

            public final Seq<InsightEdgePartition> apply(InsightEdgePartition x$2) {
                return GridProxyUtils$.MODULE$.splitPartitionByBuckets(x$2, this.splitCount$2, this.gridPartitionsSize$1);
            }
            {
                this.splitCount$2 = splitCount$2;
                this.gridPartitionsSize$1 = gridPartitionsSize$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return sparkPartitions;
    }

    public Seq<InsightEdgePartition> assignPartitionIds(Seq<InsightEdgePartition> partitions) {
        return (Seq)((TraversableLike)partitions.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InsightEdgePartition apply(Tuple2<InsightEdgePartition, Object> x0$2) {
                Tuple2<InsightEdgePartition, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    InsightEdgePartition partition = (InsightEdgePartition)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    InsightEdgePartition insightEdgePartition = partition.copy(index, partition.copy$default$2(), partition.copy$default$3(), partition.copy$default$4(), partition.copy$default$5());
                    return insightEdgePartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<InsightEdgePartition> splitPartitionByBuckets(InsightEdgePartition gridPartition, int sparkCount, int gridPartitionsSize) {
        IntRef totalBuckets = IntRef.create((int)0);
        IntRef localPartitionId = IntRef.create((int)gridPartition.id());
        return (Seq)this.equallySplit(InsightEdgeConstants$.MODULE$.BucketsCount(), sparkCount).map((Function1)new Serializable(gridPartition, gridPartitionsSize, totalBuckets, localPartitionId){
            public static final long serialVersionUID = 0L;
            private final InsightEdgePartition gridPartition$1;
            private final int gridPartitionsSize$2;
            private final IntRef totalBuckets$1;
            private final IntRef localPartitionId$1;

            /*
             * WARNING - void declaration
             */
            public final InsightEdgePartition apply(int bucketsCount) {
                void var2_2;
                InsightEdgePartition sparkPartition = new InsightEdgePartition(this.localPartitionId$1.elem, this.gridPartition$1.hostName(), this.gridPartition$1.gridContainerName(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.totalBuckets$1.elem)), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)(this.totalBuckets$1.elem + bucketsCount))));
                this.totalBuckets$1.elem += bucketsCount;
                this.localPartitionId$1.elem += this.gridPartitionsSize$2;
                return var2_2;
            }
            {
                this.gridPartition$1 = gridPartition$1;
                this.gridPartitionsSize$2 = gridPartitionsSize$2;
                this.totalBuckets$1 = totalBuckets$1;
                this.localPartitionId$1 = localPartitionId$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Object> equallySplit(int value, int partsCount) {
        int valuePerPart = value / partsCount;
        int plusOneValue = value % partsCount;
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partsCount).toList().map((Function1)new Serializable(valuePerPart, plusOneValue){
            public static final long serialVersionUID = 0L;
            private final int valuePerPart$1;
            private final int plusOneValue$1;

            public final int apply(int index) {
                return this.apply$mcII$sp(index);
            }

            public int apply$mcII$sp(int index) {
                return index < this.plusOneValue$1 ? this.valuePerPart$1 + 1 : this.valuePerPart$1;
            }
            {
                this.valuePerPart$1 = valuePerPart$1;
                this.plusOneValue$1 = plusOneValue$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    private <T> T profileWithInfo(String message, Function0<T> block) {
        return Profiler$.MODULE$.profile(message, (Function1<String, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String x$3) {
                GridProxyUtils$.MODULE$.logInfo((Function0<String>)new Serializable(this, x$3){
                    public static final long serialVersionUID = 0L;
                    private final String x$3$1;

                    public final String apply() {
                        return this.x$3$1;
                    }
                    {
                        this.x$3$1 = x$3$1;
                    }
                });
            }
        }, block);
    }

    private GridProxyUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

