/*
 * Decompiled with CFR 0.152.
 */
package org.insightedge.spark.utils;

import org.insightedge.spark.utils.GridTopologyAllocator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Try$;

public final class GridTopologyAllocator$ {
    public static final GridTopologyAllocator$ MODULE$;

    static {
        new GridTopologyAllocator$();
    }

    public void main(String[] args) {
        String output = this.allocateAndRender(args);
        Predef$.MODULE$.println((Object)output);
    }

    public String allocateAndRender(String[] args) {
        String[] stringArray;
        Option option;
        if (args.length != 2) {
            System.err.println("Usage: GridTopologyAllocator <topology> <hosts>");
            System.exit(1);
        }
        if (!(option = Array$.MODULE$.unapplySeq((Object)(stringArray = args))).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String topologyStr = (String)((SeqLike)option.get()).apply(0);
            String hostsStr = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)topologyStr, (Object)hostsStr);
            String topologyStr2 = (String)tuple22._1();
            String hostsStr2 = (String)tuple22._2();
            GridTopologyAllocator.Topology topology = (GridTopologyAllocator.Topology)Try$.MODULE$.apply((Function0)new Serializable(topologyStr2){
                public static final long serialVersionUID = 0L;
                private final String topologyStr$1;

                public final GridTopologyAllocator.Topology apply() {
                    return GridTopologyAllocator$.MODULE$.parseTopology(this.topologyStr$1);
                }
                {
                    this.topologyStr$1 = topologyStr$1;
                }
            }).getOrElse((Function0)new Serializable(topologyStr2){
                public static final long serialVersionUID = 0L;
                private final String topologyStr$1;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse topology: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topologyStr$1})));
                }
                {
                    this.topologyStr$1 = topologyStr$1;
                }
            });
            Seq hosts = (Seq)Try$.MODULE$.apply((Function0)new Serializable(hostsStr2){
                public static final long serialVersionUID = 0L;
                private final String hostsStr$1;

                public final Seq<GridTopologyAllocator.Host> apply() {
                    return GridTopologyAllocator$.MODULE$.parseHosts(this.hostsStr$1);
                }
                {
                    this.hostsStr$1 = hostsStr$1;
                }
            }).getOrElse((Function0)new Serializable(hostsStr2){
                public static final long serialVersionUID = 0L;
                private final String hostsStr$1;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse hosts: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostsStr$1})));
                }
                {
                    this.hostsStr$1 = hostsStr$1;
                }
            });
            LinkedHashMap<GridTopologyAllocator.Host, Seq<GridTopologyAllocator.SpaceInstance>> allocation = this.allocate(topology, (Seq<GridTopologyAllocator.Host>)hosts);
            return this.allocationToString(allocation);
        }
        throw new MatchError((Object)stringArray);
    }

    public LinkedHashMap<GridTopologyAllocator.Host, Seq<GridTopologyAllocator.SpaceInstance>> allocate(GridTopologyAllocator.Topology topology, Seq<GridTopologyAllocator.Host> hosts) {
        Seq initialMap = (Seq)hosts.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<GridTopologyAllocator.Host, Seq<GridTopologyAllocator.SpaceInstance>> apply(GridTopologyAllocator.Host h) {
                return new Tuple2((Object)h, (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
            }
        }, Seq$.MODULE$.canBuildFrom());
        LinkedHashMap mutableAllocation = (LinkedHashMap)LinkedHashMap$.MODULE$.apply(initialMap);
        List primaries = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), topology.partitionsCount()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GridTopologyAllocator.PrimaryInstance apply(int id) {
                return new GridTopologyAllocator.PrimaryInstance(id);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
        this.org$insightedge$spark$utils$GridTopologyAllocator$$allocateInstances$1(mutableAllocation, primaries, 0, hosts);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), topology.backupsCount()).foreach((Function1)new Serializable(hosts, mutableAllocation, primaries){
            public static final long serialVersionUID = 0L;
            private final Seq hosts$1;
            private final LinkedHashMap mutableAllocation$1;
            private final List primaries$1;

            public final LinkedHashMap<GridTopologyAllocator.Host, Seq<GridTopologyAllocator.SpaceInstance>> apply(int backupId) {
                List backups = (List)this.primaries$1.map((Function1)new Serializable(this, backupId){
                    public static final long serialVersionUID = 0L;
                    private final int backupId$1;

                    public final GridTopologyAllocator.BackupInstance apply(GridTopologyAllocator.PrimaryInstance p) {
                        return new GridTopologyAllocator.BackupInstance(p.partId(), this.backupId$1);
                    }
                    {
                        this.backupId$1 = backupId$1;
                    }
                }, List$.MODULE$.canBuildFrom());
                int currHostIndex = this.hosts$1.length() == 1 ? 0 : backupId % this.hosts$1.length();
                return GridTopologyAllocator$.MODULE$.org$insightedge$spark$utils$GridTopologyAllocator$$allocateInstances$1(this.mutableAllocation$1, backups, currHostIndex, this.hosts$1);
            }
            {
                this.hosts$1 = hosts$1;
                this.mutableAllocation$1 = mutableAllocation$1;
                this.primaries$1 = primaries$1;
            }
        });
        return mutableAllocation;
    }

    public void validateTopology(GridTopologyAllocator.Topology t) {
        Predef$.MODULE$.require(t.partitionsCount() >= 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Space partitions count should be >= 1";
            }
        });
        Predef$.MODULE$.require(t.backupsCount() >= 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Backups count couldn't be negative";
            }
        });
    }

    public Seq<GridTopologyAllocator.Host> parseHosts(String hostsStr) {
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])hostsStr.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GridTopologyAllocator.Host apply(String h) {
                return new GridTopologyAllocator.Host(h);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public GridTopologyAllocator.Topology parseTopology(String topologyStr) {
        String[] split = topologyStr.split(",");
        String[] stringArray = split;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2 tuple2;
            String partitionsStr = (String)((SeqLike)option.get()).apply(0);
            String backupsStr = (String)((SeqLike)option.get()).apply(1);
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)partitionsStr, (Object)backupsStr);
            String partitionsStr2 = (String)tuple22._1();
            String backupsStr2 = (String)tuple22._2();
            return new GridTopologyAllocator.Topology(new StringOps(Predef$.MODULE$.augmentString(partitionsStr2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(backupsStr2)).toInt());
        }
        throw new MatchError((Object)stringArray);
    }

    public String allocationToString(LinkedHashMap<GridTopologyAllocator.Host, Seq<GridTopologyAllocator.SpaceInstance>> allocation) {
        return ((TraversableOnce)allocation.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<GridTopologyAllocator.Host, Seq<GridTopologyAllocator.SpaceInstance>> x0$1) {
                Tuple2<GridTopologyAllocator.Host, Seq<GridTopologyAllocator.SpaceInstance>> tuple2 = x0$1;
                if (tuple2 != null) {
                    GridTopologyAllocator.Host host = (GridTopologyAllocator.Host)tuple2._1();
                    Seq instances = (Seq)tuple2._2();
                    String instancesStr = ((TraversableOnce)instances.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(GridTopologyAllocator.SpaceInstance x0$2) {
                            GridTopologyAllocator.SpaceInstance spaceInstance;
                            block4: {
                                String string;
                                block3: {
                                    block2: {
                                        spaceInstance = x0$2;
                                        if (!(spaceInstance instanceof GridTopologyAllocator.PrimaryInstance)) break block2;
                                        GridTopologyAllocator.PrimaryInstance primaryInstance = (GridTopologyAllocator.PrimaryInstance)spaceInstance;
                                        int partId = primaryInstance.partId();
                                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partId)}));
                                        break block3;
                                    }
                                    if (!(spaceInstance instanceof GridTopologyAllocator.BackupInstance)) break block4;
                                    GridTopologyAllocator.BackupInstance backupInstance = (GridTopologyAllocator.BackupInstance)spaceInstance;
                                    int partId = backupInstance.partId();
                                    int backupId = backupInstance.backupId();
                                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id=", ",backup_id=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partId), BoxesRunTime.boxToInteger((int)backupId)}));
                                }
                                return string;
                            }
                            throw new MatchError((Object)spaceInstance);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(";");
                    String string = host.ip();
                    String string2 = string.isEmpty() ? instancesStr : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, instancesStr}));
                    String string3 = string2;
                    return string3;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(" ");
    }

    public final LinkedHashMap org$insightedge$spark$utils$GridTopologyAllocator$$allocateInstances$1(LinkedHashMap allocation, List instancesLeft, int currHostIndex, Seq hosts$1) {
        List list;
        while (true) {
            int nextHostIndex;
            if (Nil$.MODULE$.equals(list = instancesLeft)) {
                LinkedHashMap linkedHashMap = allocation;
                return linkedHashMap;
            }
            if (!(list instanceof .colon.colon)) break;
            .colon.colon colon2 = (.colon.colon)list;
            GridTopologyAllocator.SpaceInstance instance = (GridTopologyAllocator.SpaceInstance)colon2.head();
            List instancesTail = colon2.tl$1();
            GridTopologyAllocator.Host host = (GridTopologyAllocator.Host)hosts$1.apply(currHostIndex);
            Seq currInstances = (Seq)allocation.apply((Object)host);
            Seq updatedInstances = (Seq)currInstances.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GridTopologyAllocator.SpaceInstance[]{instance})), Seq$.MODULE$.canBuildFrom());
            allocation.put((Object)host, (Object)updatedInstances);
            currHostIndex = nextHostIndex = (currHostIndex + 1) % hosts$1.length();
            instancesLeft = instancesTail;
        }
        throw new MatchError((Object)list);
    }

    private GridTopologyAllocator$() {
        MODULE$ = this;
    }
}

