/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme;

import com.gigaspaces.analytics_xtreme.DataLifecyclePolicy;
import com.gigaspaces.analytics_xtreme.QueryExecutionReport;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class AnalyticsXtremeConfiguration
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private final Map<String, DataLifecyclePolicy> policies = new LinkedHashMap<String, DataLifecyclePolicy>();
    private boolean coldStart;
    private boolean verbose;
    private transient Consumer<QueryExecutionReport> listener;

    public AnalyticsXtremeConfiguration() {
    }

    public AnalyticsXtremeConfiguration(Builder builder) {
        this.policies.putAll(builder.policies);
        this.coldStart = builder.coldStart;
        this.verbose = builder.verbose;
        this.listener = builder.listener;
    }

    public DataLifecyclePolicy getPolicy(String tableName) {
        return this.policies.get(tableName);
    }

    public Map<String, DataLifecyclePolicy> getPolicies() {
        return this.policies;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isColdStart() {
        return this.coldStart;
    }

    public Consumer<QueryExecutionReport> getListener() {
        return this.listener;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.policies.size());
        for (DataLifecyclePolicy policy : this.policies.values()) {
            IOUtils.writeObject((ObjectOutput)out, (Object)policy);
        }
        out.writeBoolean(this.verbose);
        out.writeBoolean(this.coldStart);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            DataLifecyclePolicy policy = (DataLifecyclePolicy)IOUtils.readObject((ObjectInput)in);
            this.policies.put(policy.getTypeName(), policy);
        }
        this.verbose = in.readBoolean();
        this.coldStart = in.readBoolean();
    }

    public static class Builder {
        private final Map<String, DataLifecyclePolicy> policies = new LinkedHashMap<String, DataLifecyclePolicy>();
        private boolean coldStart;
        private boolean verbose;
        private Consumer<QueryExecutionReport> listener;

        public AnalyticsXtremeConfiguration build() {
            return new AnalyticsXtremeConfiguration(this);
        }

        public Builder policies(Collection<DataLifecyclePolicy> policies) {
            for (DataLifecyclePolicy policy : policies) {
                this.addPolicy(policy);
            }
            return this;
        }

        public Builder addPolicy(DataLifecyclePolicy policy) {
            this.policies.put(policy.getTypeName(), policy);
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder coldStart(boolean coldStart) {
            this.coldStart = coldStart;
            return this;
        }

        public Builder listener(Consumer<QueryExecutionReport> listener) {
            this.listener = listener;
            return this;
        }
    }
}

