/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme;

import com.gigaspaces.analytics_xtreme.AnalyticsXtremeConfiguration;
import com.gigaspaces.analytics_xtreme.AnalyticsXtremeStatistics;
import com.gigaspaces.analytics_xtreme.AnalyticsXtremeStatisticsException;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.core.GigaSpace;
import org.openspaces.remoting.ExecutorRemotingProxyConfigurer;
import org.openspaces.remoting.SpaceRemotingResult;

public interface AnalyticsXtremeService {
    public AnalyticsXtremeConfiguration getConfiguration();

    public Map<Integer, AnalyticsXtremeStatistics> getStatistics();

    public static AnalyticsXtremeService proxy(GigaSpace gigaSpace) {
        return (AnalyticsXtremeService)new ExecutorRemotingProxyConfigurer(gigaSpace, AnalyticsXtremeService.class).broadcast((results, request) -> {
            switch (request.getMethodName()) {
                case "getStatistics": {
                    HashMap<Integer, AnalyticsXtremeStatistics> statistics = new HashMap<Integer, AnalyticsXtremeStatistics>();
                    HashMap<Integer, Throwable> errors = new HashMap<Integer, Throwable>();
                    for (SpaceRemotingResult result : results) {
                        if (result.getException() != null) {
                            errors.put(result.getInstanceId(), result.getException());
                            continue;
                        }
                        statistics.putAll((Map)result.getResult());
                    }
                    if (errors.isEmpty()) {
                        return statistics;
                    }
                    throw new AnalyticsXtremeStatisticsException(errors, statistics);
                }
            }
            SpaceRemotingResult result = results[0];
            if (result.getException() != null) {
                throw (Exception)result.getException();
            }
            return result.getResult();
        }).proxy();
    }
}

