/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme;

import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public class AnalyticsXtremeStatistics
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Instant snapshotTime;
    private Map<String, Object> statistics;
    private Map<String, TypeStatistics> typeStatistics;

    public AnalyticsXtremeStatistics() {
    }

    protected AnalyticsXtremeStatistics(Builder builder) {
        this.snapshotTime = builder.snapshotTime;
        this.statistics = builder.statistics;
        this.typeStatistics = builder.typeStatistics;
    }

    public Instant getSnapshotTime() {
        return this.snapshotTime;
    }

    public Map<String, Object> getStatistics() {
        return this.statistics;
    }

    public <T> T getStatistics(String key) {
        return (T)this.statistics.get(key);
    }

    public Map<String, TypeStatistics> getTypeStatistics() {
        return this.typeStatistics;
    }

    public TypeStatistics getTypeStatistics(String typeName) {
        return this.typeStatistics.get(typeName);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject((ObjectOutput)out, (Object)this.snapshotTime);
        IOUtils.writeMapRepetitiveKeys((ObjectOutput)out, this.statistics);
        IOUtils.writeMapRepetitiveKeys((ObjectOutput)out, this.typeStatistics);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.snapshotTime = (Instant)IOUtils.readObject((ObjectInput)in);
        this.statistics = IOUtils.readMapRepetitiveKeys((ObjectInput)in);
        this.typeStatistics = IOUtils.readMapRepetitiveKeys((ObjectInput)in);
    }

    public static class TypeStatistics
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private Map<String, Object> statistics;

        public TypeStatistics() {
        }

        private TypeStatistics(Builder builder) {
            this.statistics = builder.statistics;
        }

        public Map<String, Object> getStatistics() {
            return this.statistics;
        }

        public <T> T getStatistics(String key) {
            return (T)this.statistics.get(key);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            IOUtils.writeMapRepetitiveKeys((ObjectOutput)out, this.statistics);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.statistics = IOUtils.readMapRepetitiveKeys((ObjectInput)in);
        }

        public static class Builder {
            private Map<String, Object> statistics = new HashMap<String, Object>();

            public TypeStatistics build() {
                return new TypeStatistics(this);
            }

            public Builder statistics(String key, Serializable value) {
                this.statistics.put(key, value);
                return this;
            }
        }
    }

    public static class Builder {
        private Instant snapshotTime;
        private Map<String, Object> statistics = new HashMap<String, Object>();
        private final Map<String, TypeStatistics> typeStatistics = new HashMap<String, TypeStatistics>();

        public AnalyticsXtremeStatistics build() {
            return new AnalyticsXtremeStatistics(this);
        }

        public Builder snapshotTime(Instant snapshotTime) {
            this.snapshotTime = snapshotTime;
            return this;
        }

        public Builder statistics(String key, Serializable value) {
            this.statistics.put(key, value);
            return this;
        }

        public Builder typeStatistics(String typeName, TypeStatistics typeStatistics) {
            this.typeStatistics.put(typeName, typeStatistics);
            return this;
        }
    }
}

