/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme;

import com.gigaspaces.analytics_xtreme.spi.BatchDataSource;
import com.gigaspaces.analytics_xtreme.spi.BatchDataTarget;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Duration;

public class DataLifecyclePolicy
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_MUTABILITY_PERIOD = "80%";
    public static final String DEFAULT_BATCH_FEED_INTERVAL = Duration.ofMinutes(1L).toString();
    public static final int DEFAULT_BATCH_FEED_SIZE = 1000;
    public static final String DEFAULT_EVICTION_BUFFER = Duration.ofMinutes(10L).toString();
    public static final String DEFAULT_EVICTION_POLLING_INTERVAL = Duration.ofMinutes(1L).toString();
    private String typeName;
    private String timeColumn;
    private String timeFormat;
    private String speedPeriod;
    private BatchDataSource batchDataSource;
    private BatchDataTarget batchDataTarget;
    private String mutabilityPeriod = "80%";
    private String batchFeedInterval = DEFAULT_BATCH_FEED_INTERVAL;
    private int batchFeedSize = 1000;
    private String evictionBuffer = DEFAULT_EVICTION_BUFFER;
    private String evictionPollingInterval = DEFAULT_EVICTION_POLLING_INTERVAL;

    public DataLifecyclePolicy() {
    }

    public DataLifecyclePolicy(Builder builder) {
        this.typeName = builder.typeName;
        this.timeColumn = builder.timeColumn;
        this.timeFormat = builder.timeFormat;
        this.speedPeriod = builder.speedPeriod;
        this.batchDataSource = builder.batchDataSource;
        this.batchDataTarget = builder.batchDataTarget;
        this.mutabilityPeriod = builder.mutabilityPeriod;
        this.batchFeedInterval = builder.batchFeedInterval;
        this.batchFeedSize = builder.batchFeedSize;
        this.evictionBuffer = builder.evictionBuffer;
        this.evictionPollingInterval = builder.evictionPollingInterval;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getTimeColumn() {
        return this.timeColumn;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public String getSpeedPeriod() {
        return this.speedPeriod;
    }

    public BatchDataSource getBatchDataSource() {
        return this.batchDataSource;
    }

    public BatchDataTarget getBatchDataTarget() {
        return this.batchDataTarget;
    }

    public String getMutabilityPeriod() {
        return this.mutabilityPeriod;
    }

    public String getBatchFeedInterval() {
        return this.batchFeedInterval;
    }

    public int getBatchFeedSize() {
        return this.batchFeedSize;
    }

    public String getEvictionBuffer() {
        return this.evictionBuffer;
    }

    public String getEvictionPollingInterval() {
        return this.evictionPollingInterval;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString((ObjectOutput)out, (String)this.typeName);
        IOUtils.writeString((ObjectOutput)out, (String)this.timeColumn);
        IOUtils.writeString((ObjectOutput)out, (String)this.timeFormat);
        IOUtils.writeString((ObjectOutput)out, (String)this.speedPeriod);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.batchDataSource);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.batchDataTarget);
        IOUtils.writeString((ObjectOutput)out, (String)this.mutabilityPeriod);
        IOUtils.writeString((ObjectOutput)out, (String)this.batchFeedInterval);
        out.writeInt(this.batchFeedSize);
        IOUtils.writeString((ObjectOutput)out, (String)this.evictionBuffer);
        IOUtils.writeString((ObjectOutput)out, (String)this.evictionPollingInterval);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeName = IOUtils.readString((ObjectInput)in);
        this.timeColumn = IOUtils.readString((ObjectInput)in);
        this.timeFormat = IOUtils.readString((ObjectInput)in);
        this.speedPeriod = IOUtils.readString((ObjectInput)in);
        this.batchDataSource = (BatchDataSource)IOUtils.readObject((ObjectInput)in);
        this.batchDataTarget = (BatchDataTarget)IOUtils.readObject((ObjectInput)in);
        this.mutabilityPeriod = IOUtils.readString((ObjectInput)in);
        this.batchFeedInterval = IOUtils.readString((ObjectInput)in);
        this.batchFeedSize = in.readInt();
        this.evictionBuffer = IOUtils.readString((ObjectInput)in);
        this.evictionPollingInterval = IOUtils.readString((ObjectInput)in);
    }

    public static class Builder {
        private String typeName;
        private String timeColumn;
        private String timeFormat;
        private String speedPeriod;
        private BatchDataSource batchDataSource;
        private BatchDataTarget batchDataTarget;
        private String mutabilityPeriod = "80%";
        private String batchFeedInterval = DEFAULT_BATCH_FEED_INTERVAL;
        private int batchFeedSize = 1000;
        private String evictionBuffer = DEFAULT_EVICTION_BUFFER;
        private String evictionPollingInterval = DEFAULT_EVICTION_POLLING_INTERVAL;

        public DataLifecyclePolicy build() {
            this.assertRequired(this.typeName, "typeName");
            this.assertRequired(this.timeColumn, "timeColumn");
            this.assertRequired(this.speedPeriod, "speedPeriod");
            this.assertRequired(this.batchDataSource, "batchDataSource");
            return new DataLifecyclePolicy(this);
        }

        private void assertRequired(Object val, String name) {
            if (val == null) {
                throw this.missing(name);
            }
        }

        private void assertRequired(String val, String name) {
            if (val == null || val.isEmpty()) {
                throw this.missing(name);
            }
        }

        private IllegalArgumentException missing(String name) {
            String suffix = this.typeName != null && !this.typeName.isEmpty() ? " '" + this.typeName + "'" : "";
            return new IllegalArgumentException(this.getClass().getSimpleName() + suffix + " is missing required field '" + name + "'");
        }

        public Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public Builder timeColumn(String timeColumn) {
            this.timeColumn = timeColumn;
            return this;
        }

        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public Builder speedPeriod(String speedPeriod) {
            this.speedPeriod = speedPeriod;
            return this;
        }

        public Builder batchDataSource(BatchDataSource batchDataSource) {
            this.batchDataSource = batchDataSource;
            return this;
        }

        public Builder batchDataTarget(BatchDataTarget batchDataTarget) {
            this.batchDataTarget = batchDataTarget;
            return this;
        }

        public Builder mutabilityPeriod(String mutabilityPeriod) {
            this.mutabilityPeriod = mutabilityPeriod;
            return this;
        }

        public Builder batchFeedInterval(String batchFeedInterval) {
            this.batchFeedInterval = batchFeedInterval;
            return this;
        }

        public Builder batchFeedSize(int batchFeedSize) {
            this.batchFeedSize = batchFeedSize;
            return this;
        }

        public Builder evictionBuffer(String evictionBuffer) {
            this.evictionBuffer = evictionBuffer;
            return this;
        }

        public Builder evictionPollingInterval(String evictionPollingInterval) {
            this.evictionPollingInterval = evictionPollingInterval;
            return this;
        }
    }
}

