/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme;

import java.time.Duration;
import java.time.LocalDateTime;

public class LayerQueryExecutionReport {
    private final LocalDateTime startTime;
    private final LocalDateTime finishTime;
    private final Duration duration;

    private LayerQueryExecutionReport(Builder builder) {
        this.startTime = builder.startTime;
        this.finishTime = builder.finishTime;
        this.duration = Duration.between(this.startTime, this.finishTime);
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getFinishTime() {
        return this.finishTime;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("Duration: %sms", this.duration.toMillis());
    }

    public static class Builder {
        private LocalDateTime startTime;
        private LocalDateTime finishTime;

        public Builder startTime(LocalDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder setFinishTime(LocalDateTime finishTime) {
            this.finishTime = finishTime;
            return this;
        }

        public LayerQueryExecutionReport build() {
            return new LayerQueryExecutionReport(this);
        }
    }
}

