/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme;

import com.gigaspaces.analytics_xtreme.Layer;
import com.gigaspaces.analytics_xtreme.LayerQueryExecutionReport;
import java.time.Duration;
import java.time.LocalDateTime;

public class QueryExecutionReport {
    private final String sql;
    private final LocalDateTime startTime;
    private final LocalDateTime finishTime;
    private final Duration executionDuration;
    private final LayerQueryExecutionReport speedLayerReport;
    private final LayerQueryExecutionReport batchLayerReport;

    private QueryExecutionReport(Builder builder) {
        this.sql = builder.sql;
        this.startTime = builder.startTime;
        this.finishTime = builder.finishTime;
        this.executionDuration = Duration.between(this.startTime, this.finishTime);
        this.speedLayerReport = builder.speedLayerReport;
        this.batchLayerReport = builder.batchLayerReport;
    }

    public String getSql() {
        return this.sql;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getFinishTime() {
        return this.finishTime;
    }

    public Duration getExecutionDuration() {
        return this.executionDuration;
    }

    public LayerQueryExecutionReport getSpeedLayerReport() {
        return this.speedLayerReport;
    }

    public LayerQueryExecutionReport getBatchLayerReport() {
        return this.batchLayerReport;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        String speedLayerReport = this.getSpeedLayerReport() == null ? "N/A" : this.getSpeedLayerReport().toString();
        String batchLayerReport = this.getBatchLayerReport() == null ? "N/A" : this.getBatchLayerReport().toString();
        return String.format("Total duration: %sms || Speed layer: %s || Batch layer: %s", this.getExecutionDuration().toMillis(), speedLayerReport, batchLayerReport);
    }

    public static class Builder {
        private String sql;
        private LocalDateTime startTime;
        private LocalDateTime finishTime;
        private LayerQueryExecutionReport speedLayerReport;
        private LayerQueryExecutionReport batchLayerReport;

        public Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public Builder startTime(LocalDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder finishTime(LocalDateTime finishTime) {
            this.finishTime = finishTime;
            return this;
        }

        public Builder layerReport(Layer layer, LayerQueryExecutionReport layerReport) {
            if (layer == Layer.SPEED) {
                this.speedLayerReport = layerReport;
            } else if (layer == Layer.BATCH) {
                this.batchLayerReport = layerReport;
            }
            return this;
        }

        public QueryExecutionReport build() {
            return new QueryExecutionReport(this);
        }
    }
}

