/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme.internal;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Function;

public class TimeAdapter<T extends Comparable> {
    private final Function<Instant, T> importFunction;
    private final Function<T, Instant> exportFunction;

    public static TimeAdapter<?> of(Class<?> timeClass) {
        if (timeClass.equals(Instant.class)) {
            return new TimeAdapter(Function.identity(), Function.identity());
        }
        if (timeClass.equals(Long.TYPE) || timeClass.equals(Long.class)) {
            return new TimeAdapter<Long>(Instant::toEpochMilli, Instant::ofEpochMilli);
        }
        if (timeClass.equals(Timestamp.class)) {
            return new TimeAdapter<Timestamp>(Timestamp::from, Timestamp::toInstant);
        }
        if (timeClass.equals(Date.class)) {
            return new TimeAdapter<Date>(Date::from, Date::toInstant);
        }
        if (timeClass.equals(Calendar.class)) {
            return new TimeAdapter<Calendar>(i -> new Calendar.Builder().setInstant(i.toEpochMilli()).build(), Calendar::toInstant);
        }
        throw new IllegalStateException("Unsupported time class: " + timeClass.getName());
    }

    public TimeAdapter(Function<Instant, T> importFunction, Function<T, Instant> exportFunction) {
        this.importFunction = importFunction;
        this.exportFunction = exportFunction;
    }

    public T fromInstant(Instant instant) {
        return (T)((Comparable)this.importFunction.apply(instant));
    }

    public Instant toInstant(T time) {
        return this.exportFunction.apply(time);
    }
}

