/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme.internal;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.Optional;

public class TimeProvider {
    private final DateTimeFormatter formatter;

    public static TimeProvider of(String pattern) {
        return new TimeProvider(pattern);
    }

    private TimeProvider(String pattern) {
        this.formatter = pattern != null ? new DateTimeFormatterBuilder().appendPattern(pattern).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter() : DateTimeFormatter.ISO_DATE_TIME;
    }

    public Instant parse(String s) {
        return LocalDateTime.parse(s, this.formatter).toInstant(ZoneOffset.UTC);
    }

    public Optional<Instant> tryParse(String s) {
        try {
            return Optional.of(this.parse(s));
        }
        catch (DateTimeParseException e) {
            return Optional.empty();
        }
    }

    public String format(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC).format(this.formatter);
    }

    public static String format(Duration duration) {
        return duration != null ? duration.toString().toLowerCase() : "N/A";
    }
}

