/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme.jdbc;

import com.gigaspaces.analytics_xtreme.spi.BatchDataSource;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;

public class JdbcBatchDataSource
implements BatchDataSource,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Set<String> timeTypes = new HashSet<String>(Arrays.asList("TIMESTAMP", "TIME", "DATE"));
    private String connectionString;
    private transient Connection connection;
    private final transient Object connectionInitializerLock = new Object();

    public JdbcBatchDataSource() {
    }

    protected JdbcBatchDataSource(Builder builder) {
        this.connectionString = builder.connectionString;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Collection<Object[]> query(String sql, String tableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectionIfNeeded() throws SQLException {
        if (this.connection == null) {
            Object object = this.connectionInitializerLock;
            synchronized (object) {
                if (this.connection == null) {
                    this.connection = DriverManager.getConnection(this.connectionString);
                }
            }
        }
    }

    private static Object[] processRow(ResultSet resultSet) throws SQLException {
        Object[] values = new Object[resultSet.getMetaData().getColumnCount()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = timeTypes.contains(resultSet.getMetaData().getColumnTypeName(i + 1)) ? resultSet.getTimestamp(i + 1, Calendar.getInstance(TimeZone.getTimeZone("UTC"))) : resultSet.getObject(i + 1);
        }
        return values;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString((ObjectOutput)out, (String)this.connectionString);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.connectionString = IOUtils.readString((ObjectInput)in);
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new IOException("Failed to close " + this.getClass().getName(), e);
            }
        }
    }

    public static class Builder {
        private String connectionString;

        public JdbcBatchDataSource build() {
            return new JdbcBatchDataSource(this);
        }

        public Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }
    }
}

