/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme.jdbc;

import com.gigaspaces.analytics_xtreme.spi.BatchDataTarget;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JdbcBatchDataTarget
implements BatchDataTarget,
Externalizable {
    private static final long serialVersionUID = 1L;
    private String connectionString;
    private transient boolean toLowerCase;
    private final transient Map<String, TableInfo> typeToSql = new HashMap<String, TableInfo>();
    private transient boolean supportsBatch = true;
    private transient Connection connection;
    private final transient Object connectionInitializerLock = new Object();

    public JdbcBatchDataTarget() {
    }

    protected JdbcBatchDataTarget(Builder builder) {
        this.connectionString = builder.connectionString;
        this.toLowerCase = builder.useLowerCase;
    }

    @Override
    public void feed(Collection<SpaceDocument> entries, String tableName, SpaceTypeDescriptor typeDesc) {
        try {
            this.initConnectionIfNeeded();
            TableInfo tableInfo = this.getTableInfo(tableName, typeDesc);
            try (PreparedStatement statement = this.connection.prepareStatement(tableInfo.sql);){
                if (this.supportsBatch) {
                    this.executeBatch(entries, statement, tableInfo);
                } else {
                    this.executeSingle(entries, statement, tableInfo);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Query execution failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectionIfNeeded() throws SQLException {
        if (this.connection == null) {
            Object object = this.connectionInitializerLock;
            synchronized (object) {
                if (this.connection == null) {
                    this.connection = DriverManager.getConnection(this.connectionString);
                }
            }
        }
    }

    private void executeSingle(Collection<SpaceDocument> entries, PreparedStatement statement, TableInfo tableInfo) throws SQLException {
        for (SpaceDocument entry : entries) {
            tableInfo.entryToStatement(entry, statement);
            statement.executeUpdate();
        }
    }

    private void executeBatch(Collection<SpaceDocument> entries, PreparedStatement statement, TableInfo tableInfo) throws SQLException {
        try {
            for (SpaceDocument entry : entries) {
                tableInfo.entryToStatement(entry, statement);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLFeatureNotSupportedException e) {
            this.supportsBatch = false;
            this.executeSingle(entries, statement, tableInfo);
        }
    }

    private TableInfo getTableInfo(String tableName, SpaceTypeDescriptor typeDesc) {
        if (!this.typeToSql.containsKey(tableName)) {
            this.typeToSql.put(tableName, new TableInfo(tableName, typeDesc));
        }
        return this.typeToSql.get(tableName);
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                throw new IOException("Failed to close " + this.getClass().getName(), e);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString((ObjectOutput)out, (String)this.connectionString);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.connectionString = IOUtils.readString((ObjectInput)in);
    }

    public static class Builder {
        private String connectionString;
        private boolean useLowerCase;

        public JdbcBatchDataTarget build() {
            return new JdbcBatchDataTarget(this);
        }

        public Builder connectionString(String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        public Builder useLowerCase(boolean useLowerCase) {
            this.useLowerCase = useLowerCase;
            return this;
        }
    }

    private class TableInfo {
        final SpaceTypeDescriptor typeDesc;
        final Set<String> excludedProperties;
        final String sql;

        private TableInfo(String tableName, SpaceTypeDescriptor typeDesc) {
            this.typeDesc = typeDesc;
            this.excludedProperties = typeDesc.isAutoGenerateId() ? Collections.singleton(typeDesc.getIdPropertyName()) : Collections.emptySet();
            String columnNames = Arrays.stream(typeDesc.getPropertiesNames()).filter(name -> !this.excludedProperties.contains(name)).map(column -> JdbcBatchDataTarget.this.toLowerCase ? column.toLowerCase() : column).collect(Collectors.joining(","));
            String arguments = Arrays.stream(typeDesc.getPropertiesNames()).filter(name -> !this.excludedProperties.contains(name)).map(column -> "?").collect(Collectors.joining(","));
            this.sql = "INSERT INTO " + tableName + " (" + columnNames + ") VALUES (" + arguments + ")";
        }

        private void entryToStatement(SpaceDocument entry, PreparedStatement statement) throws SQLException {
            int i = 0;
            for (int index = 0; index < this.typeDesc.getNumOfFixedProperties(); ++index) {
                String name = this.typeDesc.getFixedProperty(index).getName();
                if (this.excludedProperties.contains(name)) continue;
                statement.setObject(i + 1, entry.getProperty(name));
                ++i;
            }
        }
    }
}

