/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme.server;

import com.gigaspaces.analytics_xtreme.AnalyticsXtremeConfiguration;
import com.gigaspaces.analytics_xtreme.AnalyticsXtremeStatistics;
import com.gigaspaces.analytics_xtreme.DataLifecyclePolicy;
import com.gigaspaces.analytics_xtreme.internal.TimeProvider;
import com.gigaspaces.analytics_xtreme.server.DataLifecycleManager;
import com.gigaspaces.attribute_store.AttributeStore;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.gigaspaces.metrics.LongCounter;
import com.gigaspaces.metrics.Metric;
import com.gigaspaces.metrics.MetricRegistrator;
import java.io.Closeable;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openspaces.core.GigaSpace;

public class AnalyticsXtremeManager
implements Closeable {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Map<String, DataLifecycleManager> tablesManagers = new HashMap<String, DataLifecycleManager>();
    private final Map<Duration, Collection<DataLifecycleManager>> evictionGroups = new HashMap<Duration, Collection<DataLifecycleManager>>();
    private final Collection<Future<?>> tasks = new ArrayList();
    private final ScheduledExecutorService executorService;
    private final GigaSpace gigaSpace;
    private final AttributeStore attributeStore;
    private boolean active;
    private final LongCounter totalEvicted = new LongCounter();
    private final LongCounter totalCopied = new LongCounter();
    private final Clock clock = Clock.systemUTC();

    public AnalyticsXtremeManager(AnalyticsXtremeConfiguration config, GigaSpace gigaSpace, AttributeStore attributeStore) {
        this.gigaSpace = gigaSpace;
        this.attributeStore = attributeStore;
        int policiesWithBatchTarget = 0;
        for (DataLifecyclePolicy policy : config.getPolicies().values()) {
            TimeProvider timeProvider = TimeProvider.of(policy.getTimeFormat());
            if (timeProvider.tryParse(policy.getSpeedPeriod()).isPresent()) {
                this.logger.info(String.format("speedPeriod for table %s is a fixed instant (%s) - this is supported for testing purposes only and will not be copied or evicted", policy.getTypeName(), policy.getSpeedPeriod()));
                continue;
            }
            DataLifecycleManager manager = new DataLifecycleManager(policy, this, config);
            this.tablesManagers.put(policy.getTypeName(), manager);
            Duration evictionPollingInterval = manager.getEvictionPollingInterval();
            if (!this.evictionGroups.containsKey(evictionPollingInterval)) {
                this.evictionGroups.put(evictionPollingInterval, new ArrayList());
            }
            this.evictionGroups.get(evictionPollingInterval).add(manager);
            if (!manager.hasBatchTarget()) continue;
            ++policiesWithBatchTarget;
        }
        this.executorService = Executors.newScheduledThreadPool(policiesWithBatchTarget + this.evictionGroups.size(), (ThreadFactory)new GSThreadFactory("analytics-xtreme-manager", true));
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info(String.format("AnalyticsXtremeManager created: policies=%s, verbose=%s, coldStart=%s", config.getPolicies().size(), config.isVerbose(), config.isColdStart()));
        }
    }

    public GigaSpace getGigaSpace() {
        return this.gigaSpace;
    }

    public Clock getClock() {
        return this.clock;
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean newActive, boolean coldStart) {
        AnalyticsXtremeManager analyticsXtremeManager = this;
        synchronized (analyticsXtremeManager) {
            if (this.active == newActive) {
                return;
            }
            if (newActive) {
                this.start(coldStart);
            } else {
                this.stop();
            }
            this.active = newActive;
        }
    }

    public DataLifecycleManager getTableLifecycleManager(String name) {
        return this.tablesManagers.get(name);
    }

    public Map<Duration, Collection<DataLifecycleManager>> getEvictionGroups() {
        return this.evictionGroups;
    }

    public AttributeStore getAttributeStore() {
        return this.attributeStore;
    }

    public AnalyticsXtremeStatistics getStatistics() {
        AnalyticsXtremeStatistics.Builder builder = new AnalyticsXtremeStatistics.Builder().snapshotTime(this.clock.instant()).statistics("totalCopied", Long.valueOf(this.totalCopied.getCount())).statistics("totalEvicted", Long.valueOf(this.totalEvicted.getCount()));
        this.tablesManagers.forEach((k, v) -> builder.typeStatistics((String)k, v.getStatistics()));
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(boolean coldStart) {
        this.logger.info("Started (cold=" + coldStart + ")");
        Collection<Future<?>> collection = this.tasks;
        synchronized (collection) {
            this.tablesManagers.values().stream().filter(DataLifecycleManager::hasBatchTarget).forEach(tableManager -> {
                tableManager.setColdStart(coldStart);
                this.tasks.add(this.executorService.submit(tableManager::feed));
            });
            this.evictionGroups.forEach((evictionPollingInterval, managers) -> this.tasks.add(this.executorService.scheduleWithFixedDelay(() -> this.evict((Collection<DataLifecycleManager>)managers), 0L, evictionPollingInterval.toMillis(), TimeUnit.MILLISECONDS)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        this.logger.info("Stopped");
        Collection<Future<?>> collection = this.tasks;
        synchronized (collection) {
            this.tasks.forEach(task -> task.cancel(true));
            this.tasks.clear();
        }
    }

    private void evict(Collection<DataLifecycleManager> managers) {
        Instant currTime = this.clock.instant();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(String.format("Started eviction for entries older than %s", currTime));
        }
        int totalEvicted = 0;
        for (DataLifecycleManager tableManager : managers) {
            totalEvicted += tableManager.evict(currTime);
        }
        this.totalEvicted.inc((long)totalEvicted);
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.fine(String.format("Finished eviction for entries older than %s - %s entries were evicted", currTime, totalEvicted));
        }
    }

    public void registerMetrics(MetricRegistrator metricRegistrator) {
        metricRegistrator.register("evicted-entries", (Metric)this.totalEvicted);
        metricRegistrator.register("copied-entries", (Metric)this.totalCopied);
        this.tablesManagers.values().forEach(t -> t.registerMetrics(metricRegistrator.extend(t.getTableName())));
    }

    public LongCounter getTotalCopied() {
        return this.totalCopied;
    }

    public LongCounter getTotalEvicted() {
        return this.totalEvicted;
    }

    @Override
    public void close() throws IOException {
        this.logger.fine("Closing");
        this.stop();
        this.attributeStore.close();
        this.tablesManagers.values().forEach(tableManager -> {
            try {
                tableManager.close();
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Failed to close table manager for type " + tableManager.getTableName(), e);
            }
        });
        this.logger.info("Closed");
    }
}

