/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme.server;

import com.gigaspaces.analytics_xtreme.AnalyticsXtremeConfiguration;
import com.gigaspaces.analytics_xtreme.AnalyticsXtremeService;
import com.gigaspaces.analytics_xtreme.AnalyticsXtremeStatistics;
import com.gigaspaces.analytics_xtreme.server.AnalyticsXtremeManager;
import com.gigaspaces.attribute_store.AttributeStore;
import com.gigaspaces.attribute_store.TransientAttributeStore;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.metrics.BeanMetricManager;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.server.space.suspend.SuspendType;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.space.status.SpaceStatusChanged;
import org.openspaces.core.space.status.SpaceStatusChangedEvent;
import org.openspaces.pu.container.ProcessingUnitContainerContext;
import org.openspaces.pu.container.ProcessingUnitContainerContextAware;
import org.openspaces.zookeeper.ZNodePathFactory;
import org.openspaces.zookeeper.attribute_store.ZooKeeperAttributeStore;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class AnalyticsXtremeManagerFactory
implements Closeable,
InitializingBean,
ProcessingUnitContainerContextAware,
AnalyticsXtremeService {
    private static long ZOOKEEPER_CONNECT_TIMEOUT = Long.getLong("com.gs.analytics_xtreme.zookeeper-connect-timeout", 101000L);
    @Autowired
    GigaSpace gigaSpace;
    private AnalyticsXtremeConfiguration config;
    private boolean coldStart;
    private AnalyticsXtremeManager manager;
    private ClusterInfo clusterInfo;
    private int partitionId;
    private BeanMetricManager beanMetricManager;
    private final Object lock = new Object();

    public void setConfig(AnalyticsXtremeConfiguration config) {
        this.config = config;
        this.coldStart = config.isColdStart();
    }

    public AnalyticsXtremeManager getManager() {
        return this.manager;
    }

    public void setProcessingUnitContainerContext(ProcessingUnitContainerContext processingUnitContainerContext) {
        this.clusterInfo = processingUnitContainerContext.getClusterInfo();
        this.beanMetricManager = processingUnitContainerContext.createBeanMetricManager("analytics-xtreme");
        this.partitionId = this.clusterInfo != null && this.clusterInfo.getInstanceId() != null ? this.clusterInfo.getInstanceId() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.manager == null) {
                this.manager = new AnalyticsXtremeManager(this.config, this.gigaSpace, AnalyticsXtremeManagerFactory.initAttributeStore(this.clusterInfo));
                if (this.beanMetricManager != null) {
                    this.manager.registerMetrics((MetricRegistrator)this.beanMetricManager);
                }
            }
        }
    }

    private static AttributeStore initAttributeStore(ClusterInfo clusterInfo) throws IOException, InterruptedException {
        if (clusterInfo == null) {
            return new TransientAttributeStore();
        }
        String puName = clusterInfo.getName();
        int partitionId = clusterInfo.getInstanceId() != null ? clusterInfo.getInstanceId() : 0;
        String path = ZNodePathFactory.processingUnit((String)puName, (String)"analytics-xtreme", (int)partitionId, (String[])new String[0]);
        long deadline = System.currentTimeMillis() + ZOOKEEPER_CONNECT_TIMEOUT;
        while (true) {
            try {
                return new ZooKeeperAttributeStore(path);
            }
            catch (IOException e) {
                if (System.currentTimeMillis() > deadline) {
                    throw e;
                }
                Thread.sleep(100L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SpaceStatusChanged
    public void onSpaceStatusChange(SpaceStatusChangedEvent event) {
        boolean active = event.getSpaceMode().equals((Object)SpaceMode.PRIMARY) && event.getSuspendType().equals((Object)SuspendType.NONE);
        Object object = this.lock;
        synchronized (object) {
            this.manager.setActive(active, this.coldStart);
            this.coldStart = false;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.beanMetricManager != null) {
            this.beanMetricManager.clear();
        }
        if (this.manager != null) {
            this.manager.close();
        }
    }

    @Override
    public AnalyticsXtremeConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public Map<Integer, AnalyticsXtremeStatistics> getStatistics() {
        AnalyticsXtremeStatistics statistics = this.manager != null ? this.manager.getStatistics() : null;
        return Collections.singletonMap(this.partitionId, statistics);
    }
}

