/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme.spark;

import com.gigaspaces.SpaceRuntimeException;
import com.gigaspaces.analytics_xtreme.spi.BatchDataSource;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.insightedge.spark.SparkSessionProvider;

public class SparkBatchDataSource
implements BatchDataSource,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SparkBatchDataSource.class.getName());
    private SparkSessionProvider sparkSessionProvider;
    private String format;
    private Map<String, String> options = new HashMap<String, String>();
    private StructType schema;
    private final transient Object lock = new Object();
    private transient SparkSessionProvider.Wrapper sparkSessionWrapper;
    private transient ExecutorService executorService;

    public SparkBatchDataSource() {
    }

    protected SparkBatchDataSource(Builder builder) {
        this.sparkSessionProvider = builder.sparkSessionProvider;
        this.format = builder.format;
        this.options = builder.options;
        this.schema = builder.schema;
    }

    public StructType getSchema() {
        return this.schema;
    }

    public String getFormat() {
        return this.format;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public SparkSessionProvider getSparkSessionProvider() {
        return this.sparkSessionProvider;
    }

    @Override
    public Collection<Object[]> query(String query, String tableName) {
        if (this.sparkSessionProvider.hasSparkTaskContext()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Current thread has spark task context, spawning a new thread to execute query via spark");
            }
            Future<Collection> future = this.getExecutorService().submit(() -> this.queryImpl(query, tableName));
            try {
                return future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SpaceRuntimeException("Query execution was interrupted", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SpaceRuntimeException("Query execution failed", e.getCause());
            }
        }
        return this.queryImpl(query, tableName);
    }

    private Collection<Object[]> queryImpl(String query, String tableName) {
        SparkSession sparkSession = this.getSparkSession();
        DataFrameReader dataFrameReader = sparkSession.read();
        if (this.format != null) {
            dataFrameReader.format(this.format);
        }
        if (this.schema != null) {
            dataFrameReader.schema(this.schema);
        }
        dataFrameReader.options(this.options);
        Dataset dataFrame = dataFrameReader.load();
        dataFrame.createOrReplaceTempView(tableName);
        dataFrame = dataFrame.sqlContext().sql(query);
        return dataFrame.collectAsList().stream().map(SparkBatchDataSource::convertRowToArray).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorService == null) {
                    this.executorService = Executors.newCachedThreadPool((ThreadFactory)new GSThreadFactory());
                }
            }
        }
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparkSession getSparkSession() {
        if (this.sparkSessionWrapper == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.sparkSessionWrapper == null) {
                    this.sparkSessionWrapper = this.sparkSessionProvider.getOrCreate();
                }
            }
        }
        return this.sparkSessionWrapper.get();
    }

    private static Object[] convertRowToArray(Row row) {
        int size = row.size();
        Object[] res = new Object[size];
        for (int i = 0; i < size; ++i) {
            res[i] = row.get(i);
        }
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString((ObjectOutput)out, (String)this.format);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.schema);
        IOUtils.writeObject((ObjectOutput)out, this.options);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.sparkSessionProvider);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.format = IOUtils.readString((ObjectInput)in);
        this.schema = (StructType)IOUtils.readObject((ObjectInput)in);
        this.options = (Map)IOUtils.readObject((ObjectInput)in);
        this.sparkSessionProvider = (SparkSessionProvider)IOUtils.readObject((ObjectInput)in);
    }

    @Override
    public void close() throws IOException {
        if (this.sparkSessionWrapper != null) {
            this.sparkSessionWrapper.close();
        }
    }

    public static class Builder {
        private SparkSessionProvider sparkSessionProvider;
        private String format;
        private Map<String, String> options;
        private StructType schema;

        public SparkBatchDataSource build() {
            return new SparkBatchDataSource(this);
        }

        public Builder sparkSessionProvider(SparkSessionProvider sparkSessionProvider) {
            this.sparkSessionProvider = sparkSessionProvider;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public Builder schema(StructType schema) {
            this.schema = schema;
            return this;
        }
    }
}

