/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme.spark;

import com.gigaspaces.analytics_xtreme.spi.BatchDataTarget;
import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.JavaTypeInference;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.insightedge.spark.SparkSessionProvider;

public class SparkBatchDataTarget
implements BatchDataTarget,
Externalizable {
    private static final long serialVersionUID = 1L;
    private SparkSessionProvider sparkSessionProvider;
    private String format;
    private StructType schema;
    private String mode;
    private Integer numBuckets;
    private String bucketColumn;
    private String[] partitionColumns;
    private Map<String, String> options = new HashMap<String, String>();
    private transient SparkSessionProvider.Wrapper sparkSessionWrapper;
    private final transient Object sparkSessionInitializerLock = new Object();

    public SparkBatchDataTarget() {
    }

    protected SparkBatchDataTarget(Builder builder) {
        this.sparkSessionProvider = builder.sparkSessionProvider;
        this.format = builder.format;
        this.schema = builder.schema;
        this.mode = builder.mode;
        this.numBuckets = builder.numBuckets;
        this.bucketColumn = builder.bucketColumn;
        this.partitionColumns = builder.partitionColumns;
        this.options = builder.options;
    }

    public StructType getSchema() {
        return this.schema;
    }

    public String getFormat() {
        return this.format;
    }

    public String getMode() {
        return this.mode;
    }

    public Integer getNumBuckets() {
        return this.numBuckets;
    }

    public String getBucketColumn() {
        return this.bucketColumn;
    }

    public String[] getPartitionColumns() {
        return this.partitionColumns;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public SparkSessionProvider getSparkSessionProvider() {
        return this.sparkSessionProvider;
    }

    @Override
    public void feed(Collection<SpaceDocument> entries, String tableName, SpaceTypeDescriptor typeDesc) {
        SparkSession sparkSession = this.getSparkSession();
        this.initSchema(typeDesc);
        List<Row> rows = this.convertEntriesToRows(entries);
        Dataset dataFrame = sparkSession.createDataFrame(rows, this.schema);
        this.saveDataFrame((Dataset<Row>)dataFrame, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparkSession getSparkSession() {
        if (this.sparkSessionWrapper == null) {
            Object object = this.sparkSessionInitializerLock;
            synchronized (object) {
                if (this.sparkSessionWrapper == null) {
                    this.sparkSessionWrapper = this.sparkSessionProvider.getOrCreate();
                }
            }
        }
        return this.sparkSessionWrapper.get();
    }

    private void saveDataFrame(Dataset<Row> dataFrame, String tableName) {
        DataFrameWriter dataFrameWriter = dataFrame.write();
        if (this.format != null) {
            dataFrameWriter.format(this.format);
        }
        if (this.mode != null) {
            dataFrameWriter.mode(this.mode);
        }
        if (this.numBuckets != null && this.bucketColumn != null) {
            dataFrameWriter.bucketBy(this.numBuckets.intValue(), this.bucketColumn, new String[0]);
        }
        if (this.partitionColumns != null) {
            dataFrameWriter.partitionBy(this.partitionColumns);
        }
        dataFrameWriter.options(this.options);
        this.save(dataFrameWriter, tableName);
    }

    protected void save(DataFrameWriter writer, String tableName) {
        writer.save();
    }

    public Row convertSpaceDocumentToRow(SpaceDocument spaceDocument) {
        String[] propertyNames = this.schema.fieldNames();
        Object[] values = new Object[propertyNames.length];
        Arrays.setAll(values, i -> spaceDocument.getProperty(propertyNames[i]));
        return new GenericRow(values);
    }

    public List<Row> convertEntriesToRows(Collection<SpaceDocument> spaceDocuments) {
        return spaceDocuments.stream().map(doc -> this.convertSpaceDocumentToRow((SpaceDocument)doc)).collect(Collectors.toList());
    }

    private synchronized void initSchema(SpaceTypeDescriptor typeDescriptor) {
        int numberOfProperties = typeDescriptor.getNumOfFixedProperties();
        StructField[] fields = new StructField[numberOfProperties];
        if (this.schema != null) {
            return;
        }
        for (int i = 0; i < numberOfProperties; ++i) {
            fields[i] = this.getStructField(typeDescriptor.getFixedProperty(i));
        }
        if (typeDescriptor.isAutoGenerateId()) {
            fields = this.removeIdPropertyFromFields(fields, typeDescriptor.getIdPropertyName());
        }
        this.schema = DataTypes.createStructType((StructField[])fields);
    }

    private StructField[] removeIdPropertyFromFields(StructField[] fields, String idPropertyField) {
        return (StructField[])Arrays.stream(fields).filter(field -> !field.name().equals(idPropertyField)).toArray(StructField[]::new);
    }

    private StructField getStructField(SpacePropertyDescriptor spacePropertyDescriptor) {
        String name = spacePropertyDescriptor.getName();
        DataType dataType = (DataType)JavaTypeInference.inferDataType((Class)spacePropertyDescriptor.getType())._1;
        return DataTypes.createStructField((String)name, (DataType)dataType, (boolean)true);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeString((ObjectOutput)out, (String)this.format);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.schema);
        IOUtils.writeString((ObjectOutput)out, (String)this.mode);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.numBuckets);
        IOUtils.writeString((ObjectOutput)out, (String)this.bucketColumn);
        IOUtils.writeStringArray((ObjectOutput)out, (String[])this.partitionColumns);
        IOUtils.writeObject((ObjectOutput)out, this.options);
        IOUtils.writeObject((ObjectOutput)out, (Object)this.sparkSessionProvider);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.format = IOUtils.readString((ObjectInput)in);
        this.schema = (StructType)IOUtils.readObject((ObjectInput)in);
        this.mode = IOUtils.readString((ObjectInput)in);
        this.numBuckets = (Integer)IOUtils.readObject((ObjectInput)in);
        this.bucketColumn = IOUtils.readString((ObjectInput)in);
        this.partitionColumns = IOUtils.readStringArray((ObjectInput)in);
        this.options = (Map)IOUtils.readObject((ObjectInput)in);
        this.sparkSessionProvider = (SparkSessionProvider)IOUtils.readObject((ObjectInput)in);
    }

    @Override
    public void close() throws IOException {
        if (this.sparkSessionWrapper != null) {
            this.sparkSessionWrapper.close();
        }
    }

    public static class Builder {
        private SparkSessionProvider sparkSessionProvider;
        private String format;
        private StructType schema;
        private String mode;
        private Integer numBuckets;
        private String bucketColumn;
        private String[] partitionColumns;
        private Map<String, String> options = new HashMap<String, String>();

        public SparkBatchDataTarget build() {
            return new SparkBatchDataTarget(this);
        }

        public Builder sparkSessionProvider(SparkSessionProvider sparkSessionProvider) {
            this.sparkSessionProvider = sparkSessionProvider;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder schema(StructType schema) {
            this.schema = schema;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder numBuckets(Integer numBuckets) {
            this.numBuckets = numBuckets;
            return this;
        }

        public Builder bucketColumn(String bucketColumn) {
            this.bucketColumn = bucketColumn;
            return this;
        }

        public Builder partitionColumns(String[] partitionColumns) {
            this.partitionColumns = partitionColumns;
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options = options;
            return this;
        }
    }
}

