/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.analytics_xtreme.spark;

import com.gigaspaces.SpaceRuntimeException;
import com.gigaspaces.analytics_xtreme.spi.BatchDataSource;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.insightedge.spark.SparkSessionProvider;

public class SparkHiveBatchDataSource
implements BatchDataSource,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SparkHiveBatchDataSource.class.getName());
    private SparkSessionProvider sparkSessionProvider;
    private final transient Object lock = new Object();
    private transient SparkSessionProvider.Wrapper sparkSessionWrapper;
    private transient ExecutorService executorService;

    public SparkHiveBatchDataSource() {
    }

    protected SparkHiveBatchDataSource(Builder builder) {
        this.sparkSessionProvider = builder.sparkSessionProvider;
    }

    public SparkSessionProvider getSparkSessionProvider() {
        return this.sparkSessionProvider;
    }

    @Override
    public Collection<Object[]> query(String query, String tableName) {
        if (this.sparkSessionProvider.hasSparkTaskContext()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Current thread has spark task context, spawning a new thread to execute query via spark");
            }
            Future<Collection> future = this.getExecutorService().submit(() -> this.queryImpl(query, tableName));
            try {
                return future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SpaceRuntimeException("Query execution was interrupted", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SpaceRuntimeException("Query execution failed", e.getCause());
            }
        }
        return this.queryImpl(query, tableName);
    }

    private Collection<Object[]> queryImpl(String query, String tableName) {
        SparkSession sparkSession = this.getSparkSession();
        Dataset dataFrame = sparkSession.sql(query);
        return dataFrame.collectAsList().stream().map(SparkHiveBatchDataSource::convertRowToArray).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorService == null) {
                    this.executorService = Executors.newCachedThreadPool((ThreadFactory)new GSThreadFactory());
                }
            }
        }
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SparkSession getSparkSession() {
        if (this.sparkSessionWrapper == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.sparkSessionWrapper == null) {
                    this.sparkSessionWrapper = this.sparkSessionProvider.getOrCreate();
                }
            }
        }
        return this.sparkSessionWrapper.get();
    }

    private static Object[] convertRowToArray(Row row) {
        int size = row.size();
        Object[] res = new Object[size];
        for (int i = 0; i < size; ++i) {
            res[i] = row.get(i);
        }
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject((ObjectOutput)out, (Object)this.sparkSessionProvider);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sparkSessionProvider = (SparkSessionProvider)IOUtils.readObject((ObjectInput)in);
    }

    @Override
    public void close() throws IOException {
        if (this.sparkSessionWrapper != null) {
            this.sparkSessionWrapper.close();
        }
    }

    public static class Builder {
        private SparkSessionProvider sparkSessionProvider;

        public SparkHiveBatchDataSource build() {
            return new SparkHiveBatchDataSource(this);
        }

        public Builder sparkSessionProvider(SparkSessionProvider sparkSessionProvider) {
            this.sparkSessionProvider = sparkSessionProvider;
            return this;
        }
    }
}

