/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractLocalCacheSpaceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String SPACE = "space";
    public static final String PROPERTIES = "properties";

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String batchTimeout;
        String batchSize;
        String maxDisconnectionDuration;
        Element propertiesEle;
        super.doParse(element, parserContext, builder);
        String space = element.getAttribute(SPACE);
        if (StringUtils.hasLength((String)space)) {
            builder.addPropertyReference(SPACE, space);
        }
        if ((propertiesEle = DomUtils.getChildElementByTagName((Element)element, (String)PROPERTIES)) != null) {
            Object properties = parserContext.getDelegate().parsePropertyValue(propertiesEle, (BeanDefinition)builder.getRawBeanDefinition(), PROPERTIES);
            builder.addPropertyValue(PROPERTIES, properties);
        }
        if (StringUtils.hasLength((String)(maxDisconnectionDuration = element.getAttribute("max-disconnection-duration")))) {
            builder.addPropertyValue("maxDisconnectionDuration", (Object)maxDisconnectionDuration);
        }
        if (StringUtils.hasLength((String)(batchSize = element.getAttribute("batch-size")))) {
            builder.addPropertyValue("batchSize", (Object)batchSize);
        }
        if (StringUtils.hasLength((String)(batchTimeout = element.getAttribute("batch-timeout")))) {
            builder.addPropertyValue("batchTimeout", (Object)batchTimeout);
        }
    }
}

