/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.cache;

import com.gigaspaces.internal.client.cache.ISpaceCache;
import com.gigaspaces.internal.client.cache.SpaceCacheFactory;
import com.gigaspaces.internal.client.cache.localcache.LocalCacheConfig;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.SpaceInitializationException;
import java.util.Properties;
import org.openspaces.core.space.CannotCreateSpaceException;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.core.space.cache.AbstractLocalCacheSpaceFactoryBean;
import org.openspaces.core.space.cache.LocalCacheSpaceConfigurer;
import org.openspaces.pu.service.ServiceDetails;
import org.springframework.util.Assert;

public class LocalCacheSpaceFactoryBean
extends AbstractLocalCacheSpaceFactoryBean {
    public static final String LOCAL_CACHE_UPDATE_MODE_PUSH = "push";
    public static final String LOCAL_CACHE_UPDATE_MODE_PULL = "pull";
    private String beanName;
    private final LocalCacheConfig config = new LocalCacheConfig();
    private IDirectSpaceProxy space;
    private IJSpace localCacheSpace;

    public Object getObject() {
        return this.localCacheSpace;
    }

    public Class<? extends IJSpace> getObjectType() {
        return this.localCacheSpace == null ? IJSpace.class : this.localCacheSpace.getClass();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.space, (String)"space property must be set");
        try {
            this.localCacheSpace = SpaceCacheFactory.createLocalCache((IDirectSpaceProxy)this.space, (LocalCacheConfig)this.config);
        }
        catch (SpaceInitializationException e) {
            throw new CannotCreateSpaceException("Failed to create local cache for space [" + this.space + "]", (Throwable)e);
        }
    }

    public void destroy() {
        if (this.localCacheSpace instanceof ISpaceCache) {
            ((ISpaceCache)this.localCacheSpace).close();
        }
    }

    public ServiceDetails[] getServicesDetails() {
        return new ServiceDetails[]{new SpaceServiceDetails(this.beanName, this.localCacheSpace)};
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected String getBeanName() {
        return this.beanName;
    }

    public void setSpace(IJSpace space) {
        Assert.isInstanceOf(IDirectSpaceProxy.class, (Object)space, (String)("unsupported space proxy class: " + space.getClass().getName()));
        this.space = (IDirectSpaceProxy)space;
    }

    public void setProperties(Properties properties) {
        this.config.setCustomProperties(properties);
    }

    public void addProperty(String name, String value) {
        this.config.getCustomProperties().setProperty(name, value);
    }

    public void setBatchSize(int batchSize) {
        this.config.setBatchSize(Integer.valueOf(batchSize));
    }

    public void setBatchTimeout(long batchTimeout) {
        this.config.setBatchTimeout(Long.valueOf(batchTimeout));
    }

    public void setMaxDisconnectionDuration(long maxDisconnectionDuration) {
        this.config.setMaxDisconnectionDuration(Long.valueOf(maxDisconnectionDuration));
    }

    public void setUpdateMode(int localCacheUpdateMode) {
        this.config.setUpdateMode(Integer.valueOf(localCacheUpdateMode));
    }

    public void setUpdateMode(LocalCacheSpaceConfigurer.UpdateMode localCacheUpdateMode) {
        if (localCacheUpdateMode == LocalCacheSpaceConfigurer.UpdateMode.NONE) {
            this.config.setUpdateMode(Integer.valueOf(0));
        } else if (localCacheUpdateMode == LocalCacheSpaceConfigurer.UpdateMode.PULL) {
            this.config.setUpdateMode(Integer.valueOf(1));
        } else if (localCacheUpdateMode == LocalCacheSpaceConfigurer.UpdateMode.PUSH) {
            this.config.setUpdateMode(Integer.valueOf(2));
        }
    }

    public void setUpdateModeName(String localCacheUpdateModeName) {
        if (LOCAL_CACHE_UPDATE_MODE_PULL.equalsIgnoreCase(localCacheUpdateModeName)) {
            this.setUpdateMode(1);
        } else if (LOCAL_CACHE_UPDATE_MODE_PUSH.equalsIgnoreCase(localCacheUpdateModeName)) {
            this.setUpdateMode(2);
        } else {
            throw new IllegalArgumentException("Wrong localCacheUpdateModeName [" + localCacheUpdateModeName + "], should be either '" + LOCAL_CACHE_UPDATE_MODE_PULL + "' or '" + LOCAL_CACHE_UPDATE_MODE_PUSH + "'");
        }
    }

    public void setMaxTimeToLive(long maxTimeToLive) {
        this.config.setMaxTimeToLive(Long.valueOf(maxTimeToLive));
    }

    public void setSize(int size) {
        this.config.setSize(size);
    }
}

