/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.cache;

import com.gigaspaces.internal.client.cache.ISpaceCache;
import com.gigaspaces.internal.client.cache.SpaceCacheFactory;
import com.gigaspaces.internal.client.cache.localview.LocalViewConfig;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.SpaceInitializationException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.openspaces.core.space.CannotCreateSpaceException;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.core.space.cache.AbstractLocalCacheSpaceFactoryBean;
import org.openspaces.pu.service.ServiceDetails;
import org.springframework.util.Assert;

public class LocalViewSpaceFactoryBean
extends AbstractLocalCacheSpaceFactoryBean {
    private String beanName;
    private final LocalViewConfig config = new LocalViewConfig();
    private IDirectSpaceProxy space;
    private IJSpace localCacheSpace;

    @Override
    public boolean isSingleton() {
        return true;
    }

    public Object getObject() {
        return this.localCacheSpace;
    }

    public Class<? extends IJSpace> getObjectType() {
        return this.localCacheSpace == null ? IJSpace.class : this.localCacheSpace.getClass();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.space, (String)"space property must be set");
        Assert.notNull((Object)this.config.getViewQueries(), (String)"localViews must be set");
        Assert.isTrue((this.config.getViewQueries().size() > 0 ? 1 : 0) != 0, (String)"At least one local view must be defined");
        try {
            this.localCacheSpace = SpaceCacheFactory.createLocalView((IDirectSpaceProxy)this.space, (LocalViewConfig)this.config);
        }
        catch (SpaceInitializationException e) {
            throw new CannotCreateSpaceException("Failed to create local view for space [" + this.space + "]", (Throwable)e);
        }
    }

    public void destroy() {
        if (this.localCacheSpace instanceof ISpaceCache) {
            ((ISpaceCache)this.localCacheSpace).close();
        }
    }

    public ServiceDetails[] getServicesDetails() {
        return new ServiceDetails[]{new SpaceServiceDetails(this.beanName, this.localCacheSpace)};
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected String getBeanName() {
        return this.beanName;
    }

    public void setSpace(IJSpace space) {
        Assert.isInstanceOf(IDirectSpaceProxy.class, (Object)space, (String)("unsupported space proxy class: " + space.getClass().getName()));
        this.space = (IDirectSpaceProxy)space;
    }

    public void setProperties(Properties properties) {
        this.config.setCustomProperties(properties);
    }

    public void addProperty(String name, String value) {
        this.config.getCustomProperties().setProperty(name, value);
    }

    public void setBatchSize(int batchSize) {
        this.config.setBatchSize(Integer.valueOf(batchSize));
    }

    public void setBatchTimeout(long batchTimeout) {
        this.config.setBatchTimeout(Long.valueOf(batchTimeout));
    }

    public void setMaxDisconnectionDuration(long maxDisconnectionDuration) {
        this.config.setMaxDisconnectionDuration(Long.valueOf(maxDisconnectionDuration));
    }

    public void setLocalViews(List<Object> queries) {
        this.config.setViewQueries(queries);
    }

    public void addViewQuery(Object query) {
        if (this.config.getViewQueries() == null) {
            this.config.setViewQueries(new ArrayList());
        }
        this.config.getViewQueries().add(query);
    }

    public void setInitialSynchronizationTimeout(long initialSynchronizationTimeout) {
        this.config.setInitialSynchronizationTimeout(Long.valueOf(initialSynchronizationTimeout));
    }
}

