/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.jdbc;

import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.jdbc.InsightEdgeConnection;
import com.gigaspaces.jdbc.InsightEdgeConnectionInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.calcite.avatica.DriverVersion;
import org.apache.calcite.avatica.Handler;
import org.apache.calcite.jdbc.InsightEdgeModelHandler;

public class Driver
extends org.apache.calcite.jdbc.Driver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:insightedge:";

    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    protected Handler createHandler() {
        return new InsightEdgeModelHandler();
    }

    public Connection connect(String url, Properties info) throws SQLException {
        Connection connection = super.connect(url, info);
        if (connection == null) {
            return null;
        }
        InsightEdgeConnection insightEdgeConnection = new InsightEdgeConnection(connection);
        boolean isJNI = Boolean.parseBoolean(insightEdgeConnection.getProperties().getProperty("enableContextClassLoaderProtection"));
        if (isJNI) {
            return (Connection)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new InsightEdgeConnectionInvocationHandler(insightEdgeConnection));
        }
        return insightEdgeConnection;
    }

    protected DriverVersion createDriverVersion() {
        DriverVersion driverVersion = super.createDriverVersion();
        return new DriverVersion("InsightEdge JDBC Driver", PlatformVersion.getVersion(), "Gigaspaces InsightEdge", PlatformVersion.getVersion(), driverVersion.jdbcCompliant, (int)PlatformVersion.getInstance().getMajorVersion(), (int)PlatformVersion.getInstance().getMinorVersion(), (int)PlatformVersion.getInstance().getMajorVersion(), (int)PlatformVersion.getInstance().getMinorVersion());
    }

    static {
        new Driver().register();
    }
}

